/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlListener;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FaderSlider;
import com.spacekiller.util.media.control.FloatControl;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FaderControlPanel
extends JPanel
implements SwingConstants {
    private static final long serialVersionUID = -8164899011156158178L;
    private Control control;
    private ControlHandler controlHandler = new ControlHandler();
    private boolean ignorePropertyChange;
    private SliderUpdater sliderUpdater = new SliderUpdater();
    private JPopupMenu popupMenu;
    private FaderSlider slider;
    private SliderChangeHandler sliderChangeHandler = new SliderChangeHandler();
    private boolean ignoreSliderChange;
    private int maxSliderValue = 1024;
    private int orientation = 1;
    private boolean inverted;
    private boolean snapToTicks;

    public FaderControlPanel() {
        this.initFaderControlPanel();
    }

    private void initFaderControlPanel() {
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        this.slider = new FaderSlider();
        this.slider.setOpaque(false);
        this.slider.addChangeListener(this.sliderChangeHandler);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.isPopupTrigger()) {
                    FaderControlPanel.this.showPopupMenu(e.getX(), e.getY());
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.isPopupTrigger()) {
                    FaderControlPanel.this.showPopupMenu(e.getX(), e.getY());
                    e.consume();
                }
            }
        });
        this.add(this.slider);
        this.refresh();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.refresh();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean snapToTicks) {
        this.snapToTicks = snapToTicks;
    }

    public int getMaxSliderValue() {
        return this.maxSliderValue;
    }

    public void setMaxSliderValue(int maxSliderValue) {
        this.maxSliderValue = maxSliderValue;
    }

    public Control getControl() {
        return this.control;
    }

    public synchronized void setControl(Control newControl) {
        if (this.control != newControl) {
            if (this.control != null) {
                this.control.removeControlListener(this.controlHandler);
            }
            this.control = newControl;
            if (this.control != null) {
                this.control.addControlListener(this.controlHandler);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.ignoreSliderChange = true;
            String name = null;
            String tooltip = null;
            Control ctrl = this.control;
            if (ctrl != null) {
                name = ctrl.getName();
                tooltip = ctrl.getTooltip();
            }
            if (name != null) {
                this.slider.setName(name);
            }
            this.slider.setToolTipText(tooltip);
            this.slider.setPaintTrack(true);
            this.slider.setPaintTicks(false);
            this.slider.setPaintLabels(false);
            this.slider.setOrientation(this.orientation);
            this.slider.setInverted(this.inverted);
            this.slider.setSnapToTicks(this.snapToTicks);
            Dimension prefSize = new Dimension();
            if (this.orientation == 1) {
                prefSize.width = 20;
                prefSize.height = 120;
            } else {
                prefSize.width = 120;
                prefSize.height = 20;
            }
            this.slider.setPreferredSize(prefSize);
        }
        finally {
            this.ignoreSliderChange = false;
        }
        this.updateSliderValue();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSliderValue() {
        double val = 0.0;
        double min = 0.0;
        double max = 0.0;
        Control ctrl = this.control;
        if (ctrl != null) {
            if (ctrl instanceof FloatControl) {
                FloatControl fc = (FloatControl)ctrl;
                val = fc.getFloat();
                min = fc.getMinimum();
                max = fc.getMaximum();
            } else if (ctrl instanceof DoubleControl) {
                DoubleControl dc = (DoubleControl)ctrl;
                val = dc.getDouble();
                min = dc.getMinimum();
                max = dc.getMaximum();
            }
        }
        int value = (int)Math.round((val - min) * (double)this.maxSliderValue / (max - min));
        try {
            this.ignoreSliderChange = true;
            this.slider.setMinimum(0);
            this.slider.setMaximum(this.maxSliderValue);
            this.slider.setValue(value);
        }
        finally {
            this.ignoreSliderChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySliderValue() {
        Control ctrl = this.control;
        if (ctrl == null) {
            return;
        }
        int value = this.slider.getValue();
        try {
            this.ignorePropertyChange = true;
            if (ctrl instanceof FloatControl) {
                float max;
                FloatControl fc = (FloatControl)ctrl;
                float min = fc.getMinimum();
                float val = (float)((double)min + (double)((max = fc.getMaximum()) - min) * (double)value / (double)this.maxSliderValue);
                if (val < min) {
                    val = min;
                }
                if (val > max) {
                    val = max;
                }
                fc.setFloat(val);
            } else if (ctrl instanceof DoubleControl) {
                double max;
                DoubleControl dc = (DoubleControl)ctrl;
                double min = dc.getMinimum();
                double val = min + ((max = dc.getMaximum()) - min) * (double)value / (double)this.maxSliderValue;
                if (val < min) {
                    val = min;
                }
                if (val > max) {
                    val = max;
                }
                dc.setDouble(val);
            }
        }
        finally {
            this.ignorePropertyChange = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    protected void showPopupMenu(int x, int y) {
        JPopupMenu menu = this.popupMenu;
        if (menu == null) {
            return;
        }
        menu.show(this, x, y);
    }

    protected class SliderChangeHandler
    implements ChangeListener {
        protected SliderChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (FaderControlPanel.this.ignoreSliderChange) {
                return;
            }
            FaderControlPanel.this.applySliderValue();
        }
    }

    protected class SliderUpdater
    implements Runnable {
        protected SliderUpdater() {
        }

        @Override
        public void run() {
            FaderControlPanel.this.updateSliderValue();
        }
    }

    protected class ControlHandler
    implements ControlListener {
        protected ControlHandler() {
        }

        @Override
        public void controlChanged(Control control) {
            if (FaderControlPanel.this.ignorePropertyChange) {
                return;
            }
            SwingUtilities.invokeLater(FaderControlPanel.this.sliderUpdater);
        }
    }
}

