/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.FaderSlider;
import com.spacekiller.util.media.control.FaderSliderIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FaderSliderUI
extends BasicSliderUI {
    private static final Logger logger = Logger.getLogger(FaderSliderUI.class.getName());
    private static Icon defaultHorizontalFaderIcon;
    private static Icon defaultVerticalFaderIcon;
    private static Icon defaultDisabledHorizontalFaderIcon;
    private static Icon defaultDisabledVerticalFaderIcon;
    private static final Color DEFAULT_SHADOW_COLOR;
    private static final Color DEFAULT_HIGHLIGHT_COLOR;
    private static final Color DEFAULT_FOCUS_COLOR;
    private static final Color DEFAULT_DISABLED_COLOR;
    private FaderSlider faderSlider;
    private Icon horizontalFaderIcon;
    private Icon verticalFaderIcon;
    private Icon disabledHorizontalFaderIcon;
    private Icon disabledVerticalFaderIcon;
    private Color shadowColor = DEFAULT_SHADOW_COLOR;
    private Color highlightColor = DEFAULT_HIGHLIGHT_COLOR;
    private Color focusColor = DEFAULT_FOCUS_COLOR;
    private Color disabledColor = DEFAULT_DISABLED_COLOR;
    private boolean paintFocus;
    private MouseHandler mouseHandler = new MouseHandler();
    private int mouseX = -1;
    private int mouseY = -1;

    public FaderSliderUI(FaderSlider b) {
        super(b);
        this.faderSlider = b;
        b.addMouseListener(this.mouseHandler);
        this.initFaderUI();
    }

    public static ComponentUI createUI(JComponent b) {
        return new FaderSliderUI((FaderSlider)b);
    }

    @Override
    protected Color getShadowColor() {
        return this.faderSlider.isEnabled() ? this.shadowColor : this.disabledColor;
    }

    @Override
    protected Color getHighlightColor() {
        return this.faderSlider.isEnabled() ? this.highlightColor : this.disabledColor;
    }

    @Override
    protected Color getFocusColor() {
        return this.faderSlider.isEnabled() ? this.focusColor : this.disabledColor;
    }

    @Override
    public void paintThumb(Graphics g) {
        super.paintThumb(g);
        Rectangle knobBounds = this.thumbRect;
        Icon icon = this.getThumbIcon();
        if (icon != null) {
            icon.paintIcon(this.slider, g, knobBounds.x, knobBounds.y);
        }
    }

    @Override
    public void paintFocus(Graphics g) {
        if (this.isPaintFocus()) {
            super.paintFocus(g);
        }
    }

    @Override
    protected Dimension getThumbSize() {
        int w = 1;
        int h = 1;
        Icon icon = this.getThumbIcon();
        if (icon != null) {
            w = icon.getIconWidth();
            h = icon.getIconHeight();
        }
        return new Dimension(w, h);
    }

    protected Icon getThumbIcon() {
        if (this.faderSlider.getOrientation() == 0) {
            return this.faderSlider.isEnabled() ? this.horizontalFaderIcon : this.disabledHorizontalFaderIcon;
        }
        return this.faderSlider.isEnabled() ? this.verticalFaderIcon : this.disabledVerticalFaderIcon;
    }

    private void initFaderUI() {
        try {
            if (defaultHorizontalFaderIcon == null) {
                defaultHorizontalFaderIcon = new FaderSliderIcon(7, 14, true, Color.DARK_GRAY, Color.WHITE);
                defaultVerticalFaderIcon = new FaderSliderIcon(14, 7, false, Color.DARK_GRAY, Color.WHITE);
                defaultDisabledHorizontalFaderIcon = new FaderSliderIcon(7, 14, true, Color.GRAY, Color.WHITE);
                defaultDisabledVerticalFaderIcon = new FaderSliderIcon(14, 7, false, Color.GRAY, Color.WHITE);
            }
            this.horizontalFaderIcon = defaultHorizontalFaderIcon;
            this.verticalFaderIcon = defaultVerticalFaderIcon;
            this.disabledHorizontalFaderIcon = defaultDisabledHorizontalFaderIcon;
            this.disabledVerticalFaderIcon = defaultDisabledVerticalFaderIcon;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        int mx = this.mouseX;
        int my = this.mouseY;
        this.faderSlider.setTrackClickMillis(System.currentTimeMillis());
        if (mx < 0 || my < 0) {
            super.scrollDueToClickInTrack(dir);
            return;
        }
        int value = this.slider.getValue();
        if (this.slider.getOrientation() == 0) {
            value = this.valueForXPosition(mx);
        } else if (this.slider.getOrientation() == 1) {
            value = this.valueForYPosition(my);
        }
        this.slider.setValue(value);
        int id = 1;
        long when = System.currentTimeMillis();
        int modifiers = 0;
        this.trackListener.mousePressed(new MouseEvent(this.slider, id, when, modifiers, mx, my, 1, false, 1));
    }

    protected int getMouseX() {
        return this.mouseX;
    }

    protected void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    protected int getMouseY() {
        return this.mouseY;
    }

    protected void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setPaintFocus(boolean paintFocus) {
        this.paintFocus = paintFocus;
    }

    static {
        DEFAULT_SHADOW_COLOR = new Color(128, 128, 128);
        DEFAULT_HIGHLIGHT_COLOR = new Color(150, 150, 150);
        DEFAULT_FOCUS_COLOR = Color.BLACK;
        DEFAULT_DISABLED_COLOR = new Color(180, 180, 180);
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            FaderSliderUI.this.mouseX = e.getX();
            FaderSliderUI.this.mouseY = e.getY();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            FaderSliderUI.this.mouseX = e.getX();
            FaderSliderUI.this.mouseY = e.getY();
        }
    }
}

