/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlListener;
import com.spacekiller.util.media.control.FileControl;
import com.spacekiller.util.media.control.TextControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileControlPanel
extends JPanel {
    private static final long serialVersionUID = -6555081769348723187L;
    private Control control;
    private ControlHandler controlHandler = new ControlHandler();
    private boolean ignorePropertyChange;
    private TextFieldUpdater textFieldUpdater = new TextFieldUpdater();
    private JTextField textField;
    private boolean ignoreTextFieldChange;
    private JButton browseButton;

    public FileControlPanel() {
        this.initFileControlPanel();
    }

    private void initFileControlPanel() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setEditable(true);
        this.textField.setColumns(15);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (FileControlPanel.this.ignoreTextFieldChange) {
                    return;
                }
                FileControlPanel.this.applyFileValue();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (FileControlPanel.this.ignoreTextFieldChange) {
                    return;
                }
                FileControlPanel.this.applyFileValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (FileControlPanel.this.ignoreTextFieldChange) {
                    return;
                }
                FileControlPanel.this.applyFileValue();
            }
        });
        this.browseButton = new JButton();
        this.browseButton.setToolTipText("Browse");
        this.browseButton.setMargin(new Insets(0, 0, 0, 0));
        this.browseButton.setIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/icons/button-browse.gif"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileControlPanel.this.showFileChooserDialog();
            }
        });
        this.add((Component)this.textField, "Center");
        this.add((Component)this.browseButton, "East");
        this.refresh();
    }

    public Control getControl() {
        return this.control;
    }

    public synchronized void setControl(Control newControl) {
        if (this.control != newControl) {
            if (this.control != null) {
                this.control.removeControlListener(this.controlHandler);
            }
            this.control = newControl;
            if (this.control != null) {
                this.control.addControlListener(this.controlHandler);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.ignoreTextFieldChange = true;
            String name = null;
            String tooltip = null;
            Control ctrl = this.control;
            if (ctrl != null) {
                name = ctrl.getName();
                tooltip = ctrl.getTooltip();
            }
            if (name != null) {
                this.textField.setName(name);
            }
            this.textField.setToolTipText(tooltip);
        }
        finally {
            this.ignoreTextFieldChange = false;
        }
        this.updateTextFieldValue();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTextFieldValue() {
        String path = null;
        Control ctrl = this.control;
        if (ctrl != null) {
            if (ctrl instanceof FileControl) {
                FileControl fc = (FileControl)ctrl;
                path = fc.getPath();
            } else if (ctrl instanceof TextControl) {
                TextControl tc = (TextControl)ctrl;
                path = tc.getText();
            }
        }
        try {
            this.ignoreTextFieldChange = true;
            String s = path == null ? "" : path;
            this.textField.setText(s);
        }
        finally {
            this.ignoreTextFieldChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFileValue() {
        Control ctrl = this.control;
        if (ctrl == null) {
            return;
        }
        String path = this.textField.getText();
        if (path == null || path.length() < 1) {
            path = null;
        }
        try {
            this.ignorePropertyChange = true;
            if (ctrl instanceof FileControl) {
                FileControl fc = (FileControl)ctrl;
                fc.setPath(path);
            } else if (ctrl instanceof TextControl) {
                TextControl tc = (TextControl)ctrl;
                tc.setText(path);
            }
        }
        finally {
            this.ignorePropertyChange = false;
        }
    }

    protected void showFileChooserDialog() {
        String approveButtonText;
        int result;
        File file;
        File dir;
        JFileChooser fileChooser = new JFileChooser();
        String currentPath = this.textField.getText();
        if (currentPath != null && currentPath.length() > 0 && (dir = (file = new File(currentPath)).getParentFile()) != null && dir.exists() && dir.isDirectory()) {
            fileChooser.setCurrentDirectory(dir);
            fileChooser.setSelectedFile(file);
        }
        if ((result = fileChooser.showDialog(this, approveButtonText = "Select File")) != 0) {
            return;
        }
        String path = null;
        File file2 = fileChooser.getSelectedFile();
        if (file2 != null) {
            path = file2.getPath();
        }
        if (path == null) {
            path = "";
        }
        this.textField.setText(path);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    protected class TextFieldUpdater
    implements Runnable {
        protected TextFieldUpdater() {
        }

        @Override
        public void run() {
            FileControlPanel.this.updateTextFieldValue();
        }
    }

    protected class ControlHandler
    implements ControlListener {
        protected ControlHandler() {
        }

        @Override
        public void controlChanged(Control control) {
            if (FileControlPanel.this.ignorePropertyChange) {
                return;
            }
            SwingUtilities.invokeLater(FileControlPanel.this.textFieldUpdater);
        }
    }
}

