/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlListener;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FloatControl;
import com.spacekiller.util.media.control.IntControl;
import com.spacekiller.util.media.control.TextControl;
import java.awt.GridLayout;
import java.text.Format;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldControlPanel
extends JPanel {
    private static final long serialVersionUID = 5442980356666999921L;
    private Control control;
    private ControlHandler controlHandler = new ControlHandler();
    private boolean ignorePropertyChange;
    private TextFieldUpdater textFieldUpdater = new TextFieldUpdater();
    private JTextField textField;
    private TextFieldHandler textFieldHandler = new TextFieldHandler();
    private boolean ignoreTextFieldChange;
    private Format format;

    public TextFieldControlPanel() {
        this.initTextFieldControlPanel();
    }

    private void initTextFieldControlPanel() {
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        this.textField = new JTextField();
        this.textField.setOpaque(false);
        this.textField.getDocument().addDocumentListener(this.textFieldHandler);
        this.add(this.textField);
        this.refresh();
    }

    public Control getControl() {
        return this.control;
    }

    public synchronized void setControl(Control newControl) {
        if (this.control != newControl) {
            if (this.control != null) {
                this.control.removeControlListener(this.controlHandler);
            }
            this.control = newControl;
            if (this.control != null) {
                this.control.addControlListener(this.controlHandler);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.ignoreTextFieldChange = true;
            String name = null;
            String tooltip = null;
            Control ctrl = this.control;
            if (ctrl != null) {
                name = ctrl.getName();
                tooltip = ctrl.getTooltip();
            }
            if (name != null) {
                this.textField.setName(name);
            }
            this.textField.setToolTipText(tooltip);
        }
        finally {
            this.ignoreTextFieldChange = false;
        }
        this.updateTextFieldValue();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTextFieldValue() {
        String text = null;
        Control ctrl = this.control;
        if (ctrl != null) {
            if (ctrl instanceof TextControl) {
                TextControl tc = (TextControl)ctrl;
                text = tc.getText();
            } else {
                Object value = ctrl.getValue();
                if (value != null) {
                    text = this.format == null ? String.valueOf(value) : this.format.format(value);
                }
            }
        }
        if (text == null) {
            text = "";
        }
        try {
            this.ignoreTextFieldChange = true;
            this.textField.setText(text);
            this.textField.setCaretPosition(0);
        }
        finally {
            this.ignoreTextFieldChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyTextFieldValue() {
        Control ctrl = this.control;
        if (ctrl == null) {
            return;
        }
        String text = this.textField.getText();
        try {
            this.ignorePropertyChange = true;
            if (ctrl instanceof TextControl) {
                TextControl tc = (TextControl)ctrl;
                tc.setText(text);
            } else if (ctrl instanceof IntControl) {
                IntControl ic = (IntControl)ctrl;
                try {
                    int value = Integer.parseInt(text.trim());
                    ic.setInt(value);
                }
                catch (NumberFormatException e) {}
            } else if (ctrl instanceof FloatControl) {
                FloatControl fc = (FloatControl)ctrl;
                try {
                    float value = Float.parseFloat(text.trim());
                    fc.setFloat(value);
                }
                catch (NumberFormatException e) {}
            } else if (ctrl instanceof DoubleControl) {
                DoubleControl dc = (DoubleControl)ctrl;
                try {
                    double value = Double.parseDouble(text.trim());
                    dc.setDouble(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.ignorePropertyChange = false;
        }
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    public void setColumns(int columns) {
        this.textField.setColumns(columns);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    protected class TextFieldHandler
    implements DocumentListener {
        protected TextFieldHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!TextFieldControlPanel.this.ignoreTextFieldChange) {
                TextFieldControlPanel.this.applyTextFieldValue();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!TextFieldControlPanel.this.ignoreTextFieldChange) {
                TextFieldControlPanel.this.applyTextFieldValue();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!TextFieldControlPanel.this.ignoreTextFieldChange) {
                TextFieldControlPanel.this.applyTextFieldValue();
            }
        }
    }

    protected class TextFieldUpdater
    implements Runnable {
        protected TextFieldUpdater() {
        }

        @Override
        public void run() {
            TextFieldControlPanel.this.updateTextFieldValue();
        }
    }

    protected class ControlHandler
    implements ControlListener {
        protected ControlHandler() {
        }

        @Override
        public void controlChanged(Control control) {
            if (TextFieldControlPanel.this.ignorePropertyChange) {
                return;
            }
            SwingUtilities.invokeLater(TextFieldControlPanel.this.textFieldUpdater);
        }
    }
}

