/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.control;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.Player;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.PlayerListener;
import com.spacekiller.util.media.control.FaderSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackPositionSlider
extends FaderSlider {
    private static final long serialVersionUID = -814743860331279232L;
    public static final int DEFAULT_ADJUST_DELAY = 500;
    private Player player;
    private final PlayerHandler playerHandler = new PlayerHandler();
    private Timer adjustTimer;
    private PlayerItem currentItem;
    private int maximumValue;
    private boolean refreshing;
    private long trackClickAdjustDelay = 1000L;

    public TrackPositionSlider() {
        this.setValue(0);
        this.setMinimum(0);
        this.setMaximum(1);
        this.setEnabled(false);
        this.setOpaque(false);
        this.setToolTipText("Track Position");
        this.adjustTimer = new Timer(500, new AdjustHandler());
        this.adjustTimer.setRepeats(true);
        this.getModel().addChangeListener(new ChangeHandler());
    }

    public Player getAudioPlayer() {
        return this.player;
    }

    public synchronized void setAudioPlayer(Player newAudioPlayer) {
        if (this.player == newAudioPlayer) {
            return;
        }
        if (this.player != null) {
            this.player.removePlayerListener((PlayerListener)this.playerHandler);
        }
        this.player = newAudioPlayer;
        if (this.player != null) {
            this.player.addPlayerListener((PlayerListener)this.playerHandler);
        }
        this.handleStateChanged(newAudioPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        super.doLayout();
        try {
            this.refreshing = true;
            this.maximumValue = this.getWidth();
            this.setMaximum(this.maximumValue);
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String s;
        PlayerItem item = this.currentItem;
        if (item == null) {
            return null;
        }
        Player p = this.player;
        if (p == null) {
            return null;
        }
        double millis = p.getTimePosition(item);
        if (millis < 0.0) {
            return null;
        }
        long secs = (long)(millis / 1000.0);
        if (secs < 60L) {
            s = "0:";
        } else {
            long mins = secs / 60L;
            secs %= 60L;
            s = Long.toString(mins) + ":";
        }
        return s + Long.toString(100L + secs).substring(1);
    }

    @Override
    public String getToolTipText() {
        String title;
        PlayerItem item = this.currentItem;
        if (item == null) {
            return null;
        }
        MediaEntry me = item.getMediaEntry();
        if (me != null && (title = me.getTitle()) != null && title.length() > 0) {
            return title;
        }
        Resource res = item.getResource();
        if (res != null) {
            return res.toString();
        }
        return null;
    }

    public long getTrackClickAdjustDelay() {
        return this.trackClickAdjustDelay;
    }

    public void setTrackClickAdjustDelay(long trackClickAdjustDelay) {
        this.trackClickAdjustDelay = trackClickAdjustDelay;
    }

    protected void handleStateChanged(Player player) {
        int state = player == null ? 0 : player.getState();
        switch (state) {
            case 1: {
                this.adjustTimer.start();
                break;
            }
            case 2: {
                this.adjustTimer.stop();
                break;
            }
            case 0: {
                this.adjustTimer.stop();
                this.setEnabled(false);
                this.currentItem = null;
                this.setValue(0);
            }
        }
    }

    protected void handleItemChanged(Player player) {
        PlayerItem item;
        this.currentItem = item = player.getCurrentItem();
    }

    protected class ChangeHandler
    implements ChangeListener {
        protected ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PlayerItem item;
            if (TrackPositionSlider.this.refreshing) {
                return;
            }
            if (TrackPositionSlider.this.getValueIsAdjusting()) {
                return;
            }
            double pos = (double)TrackPositionSlider.this.getValue() / (double)TrackPositionSlider.this.getMaximum();
            Player p = TrackPositionSlider.this.player;
            if (p != null && (item = TrackPositionSlider.this.currentItem) != null) {
                p.setNormalPosition(item, pos);
            }
        }
    }

    protected class AdjustHandler
    implements ActionListener {
        protected AdjustHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            PlayerItem item;
            if (TrackPositionSlider.this.getValueIsAdjusting()) {
                return;
            }
            long trackClickElapsed = System.currentTimeMillis() - TrackPositionSlider.this.getTrackClickMillis();
            if (trackClickElapsed < TrackPositionSlider.this.trackClickAdjustDelay && trackClickElapsed >= 0L) {
                return;
            }
            double pos = -1.0;
            Player p = TrackPositionSlider.this.player;
            if (p != null && (item = TrackPositionSlider.this.currentItem) != null) {
                pos = p.getNormalPosition(item);
            }
            try {
                TrackPositionSlider.this.refreshing = true;
                if (pos < 0.0) {
                    if (TrackPositionSlider.this.isEnabled()) {
                        TrackPositionSlider.this.setEnabled(false);
                    }
                    TrackPositionSlider.this.setValue(0);
                } else {
                    int val = (int)Math.round(pos * (double)TrackPositionSlider.this.maximumValue);
                    TrackPositionSlider.this.setValue(val);
                    if (!TrackPositionSlider.this.isEnabled()) {
                        TrackPositionSlider.this.setEnabled(true);
                    }
                }
            }
            finally {
                TrackPositionSlider.this.refreshing = false;
            }
        }
    }

    protected class PlayerHandler
    implements PlayerListener {
        protected PlayerHandler() {
        }

        public void stateChanged(Player player) {
            TrackPositionSlider.this.handleStateChanged(player);
        }

        public void itemChanged(Player player) {
            TrackPositionSlider.this.handleItemChanged(player);
        }
    }
}

