/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockManager;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.sound.SoundSystem;
import com.spacekiller.util.sound.plugin.SoundPlugin;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.tooling.ToolProvider;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.WorkspacePlugin;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.editor.InterpolatorProvider;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.ScratchPatternManager;
import com.waxmonster.editor.ScratchPatternProvider;
import com.waxmonster.editor.impl.CubicSplineInterpolatorProvider;
import com.waxmonster.editor.impl.DefaultInterpolatorRegistry;
import com.waxmonster.editor.impl.HermiteSplineInterpolatorProvider;
import com.waxmonster.editor.impl.LinearInterpolatorProvider;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiPortType;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabDeviceInfo;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.impl.WaxLabPanel;
import com.waxmonster.waxlab.impl.WaxLabPluginContext;
import com.waxmonster.waxlab.plugin.WaxLabMidiActions;
import com.waxmonster.waxlab.plugin.WaxLabPlugin;
import com.waxmonster.waxlab.plugin.WaxLabPreferencesPage;
import com.waxmonster.waxlab.plugin.WaxLabToolContextImpl;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.DefaultWaxLabPanel;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class WaxLabDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "WaxLabDeviceProvider";
    private static final Logger logger = Platform.getLogger(WaxLabDeviceProvider.class);
    private MidiEngineConfig midiEngineConfig;
    private ToolGroup toolBarGroup;
    private ToolGroup titlePopupMenuGroup;
    private ToolGroup rulerPopupMenuGroup;
    private ToolGroup cornerPopupMenuGroup;
    private ToolGroup audioLinePopupMenuGroup;
    private ToolGroup timecodeLinePopupMenuGroup;
    private ToolGroup midiLinePopupMenuGroup;
    private ToolGroup faderLinePopupMenuGroup;
    private ToolGroup editorLinePopupMenuGroup;
    private ToolProvider editorMenuInsertToolProvider;

    public WaxLabDeviceProvider() {
        super(PROVIDER_NAME);
        this.initWaxLabDeviceProvider();
    }

    protected void initWaxLabDeviceProvider() {
        Icon iconColor16 = Tools.getIcon(WaxLabDeviceProvider.class, (String)"/com/waxmonster/waxlab/plugin/icons/wax_studio_icon16.png");
        String devName = "Wax Lab";
        WaxLabDeviceInfo waxLabInfo = new WaxLabDeviceInfo(devName, iconColor16);
        this.addDeviceInfo((DeviceInfo)waxLabInfo);
        this.midiEngineConfig = new MidiEngineConfig();
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        WaxLabDeviceInfo waxInfo = (WaxLabDeviceInfo)info;
        String devName = waxInfo.getDeviceName();
        try {
            JPopupMenu linePopupMenu;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createDevice: " + devName);
            }
            WorkspacePlugin wsPlugin = WorkbenchUtilities.getWorkspacePlugin();
            BeanDropSupport beanDropSupport = wsPlugin.getBeanDropSupport();
            ClipboardManager clipboardManager = wsPlugin.getClipboardManager();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Getting SoundSystem...");
            }
            SoundSystem soundSystem = this.lookupSoundSystem();
            DefaultInterpolatorRegistry interpolatorRegistry = new DefaultInterpolatorRegistry();
            interpolatorRegistry.registerInterpolatorProvider((InterpolatorProvider)new CubicSplineInterpolatorProvider());
            interpolatorRegistry.registerInterpolatorProvider((InterpolatorProvider)new LinearInterpolatorProvider());
            interpolatorRegistry.registerInterpolatorProvider((InterpolatorProvider)new HermiteSplineInterpolatorProvider());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Getting TimecodeManager...");
            }
            TimecodeManager timecodeManager = TimecodeManager.getInstance();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Getting ScratchPatternManager...");
            }
            ScratchPatternManager scratchPatternManager = ScratchPatternManager.getInstance();
            ScratchPatternProvider[] scratchPatternProviders = scratchPatternManager.getScratchPatternProviders();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Getting WaxLabPreferences...");
            }
            WaxLabPreferences waxLabPrefs = null;
            try {
                Preferences prefs = Platform.getInstance().getPreferencesRegistry().getPreferences("waxmonster.waxlab");
                waxLabPrefs = WaxLabPreferencesPage.getWaxLabPreferences(prefs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (waxLabPrefs == null) {
                try {
                    if (Platform.getInstance().getPreferencesRegistry().containsKey("waxmonster.waxlab")) {
                        Platform.getInstance().getPreferencesRegistry().removePreferences("waxmonster.waxlab");
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, e2.getMessage(), e2);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Lookup MediaLibrary...");
            }
            MediaLibrary mediaLibrary = this.lookupMediaLibrary();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MediaLibrary: " + mediaLibrary);
            }
            boolean unsafe = true;
            LockManager lockManager = LockManager.getInstance();
            LockSupport lockSupport = lockManager.createLockSupport(unsafe);
            LockFactory lockFactory = lockManager.createLockFactory();
            Heap mutationHeap = null;
            int mutationBlockSize = -1;
            try {
                mutationHeap = WaxLabPlugin.getInstance().getMutationHeap();
                mutationBlockSize = WaxLabPlugin.getInstance().getMutationBlockSize();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating WaxLab...");
            }
            WaxLabImpl waxLabImpl = new WaxLabImpl(soundSystem, timecodeManager, (InterpolatorRegistry)interpolatorRegistry, mediaLibrary, lockSupport, lockFactory, mutationHeap, mutationBlockSize);
            if (waxLabPrefs != null) {
                waxLabImpl.setWaxLabPreferences(waxLabPrefs);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Customizing WaxLab...");
            }
            WaxLabViewSettings viewSettings = null;
            try {
                Platform platform = Platform.getInstance();
                Preferences prefs = platform.getPreferencesRegistry().getPreferences("waxmonster.waxlab");
                viewSettings = WaxLabPreferencesPage.getWaxLabViewSettings(prefs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating WaxLab-Panel...");
            }
            DefaultWaxLabPanel waxLabPanel = new DefaultWaxLabPanel((WaxLab)waxLabImpl);
            waxLabPanel.setPreferredSize(new Dimension(800, 600));
            waxLabPanel.setBeanDropSupport(beanDropSupport);
            waxLabPanel.setClipboardManager(clipboardManager);
            waxLabPanel.setScratchPatternProviders(scratchPatternProviders);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading wizard resources...");
            }
            URL wizardAudioURL = ((Object)((Object)this)).getClass().getResource("/com/waxmonster/waxlab/plugin/sounds/waxmonster_wizard.mp3");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("wizardAudioURL: " + wizardAudioURL);
            }
            waxLabPanel.setWizardAudioURL(wizardAudioURL);
            WaxLabToolContextImpl toolContext = new WaxLabToolContextImpl((AbstractWaxLabPanel)waxLabPanel, (WaxLab)waxLabImpl, lockFactory);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Initializing WaxLab-Panel...");
            }
            if (this.toolBarGroup != null) {
                JToolBar toolBar = (JToolBar)this.toolBarGroup.createInstance((ToolContext)toolContext, JToolBar.class);
                waxLabPanel.setToolBar(toolBar);
            }
            if (this.titlePopupMenuGroup != null) {
                JPopupMenu titlePopupMenu = (JPopupMenu)this.titlePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setTitlePopupMenu(titlePopupMenu);
            }
            if (this.rulerPopupMenuGroup != null) {
                JPopupMenu rulerPopupMenu = (JPopupMenu)this.rulerPopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setRulerPopupMenu(rulerPopupMenu);
            }
            if (this.cornerPopupMenuGroup != null) {
                JPopupMenu cornerPopupMenu = (JPopupMenu)this.cornerPopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setCornerPopupMenu(cornerPopupMenu);
            }
            if (this.audioLinePopupMenuGroup != null) {
                linePopupMenu = (JPopupMenu)this.audioLinePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setAudioLinePopupMenu(linePopupMenu);
            }
            if (this.timecodeLinePopupMenuGroup != null) {
                linePopupMenu = (JPopupMenu)this.timecodeLinePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setTimecodeLinePopupMenu(linePopupMenu);
            }
            if (this.midiLinePopupMenuGroup != null) {
                linePopupMenu = (JPopupMenu)this.midiLinePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setMidiLinePopupMenu(linePopupMenu);
            }
            if (this.faderLinePopupMenuGroup != null) {
                linePopupMenu = (JPopupMenu)this.faderLinePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setFaderLinePopupMenu(linePopupMenu);
            }
            if (this.editorLinePopupMenuGroup != null) {
                linePopupMenu = (JPopupMenu)this.editorLinePopupMenuGroup.createInstance((ToolContext)toolContext, JPopupMenu.class);
                waxLabPanel.setEditorLinePopupMenu(linePopupMenu);
            }
            if (viewSettings != null) {
                waxLabPanel.setViewSettings(viewSettings);
            }
            MidiAction[] availableMidiActions = new MidiAction[]{new WaxLabMidiActions.StartAction((AbstractWaxLabPanel)waxLabPanel), new WaxLabMidiActions.PauseAction((AbstractWaxLabPanel)waxLabPanel), new WaxLabMidiActions.StopAction((AbstractWaxLabPanel)waxLabPanel), new WaxLabMidiActions.ToggleStartPauseAction((AbstractWaxLabPanel)waxLabPanel), new WaxLabMidiActions.ToggleStartStopAction((AbstractWaxLabPanel)waxLabPanel), new WaxLabMidiActions.RefreshMidiLightingAction((AbstractWaxLabPanel)waxLabPanel)};
            waxLabImpl.setMidiActions(availableMidiActions);
            JToolBar toolBar = waxLabPanel.getToolBar();
            if (toolBar != null) {
                ToolBarMidiMapper toolBarMidiMapper = new ToolBarMidiMapper((WaxLab)waxLabImpl);
                Component[] comps = toolBar.getComponents();
                Component comp = this.getComponent(comps, "MenuItem_WaxLab_Start");
                if (comp != null) {
                    toolBarMidiMapper.registerMidiAction(comp, "Start");
                }
                if ((comp = this.getComponent(comps, "MenuItem_WaxLab_Pause")) != null) {
                    toolBarMidiMapper.registerMidiAction(comp, "Pause");
                }
                if ((comp = this.getComponent(comps, "MenuItem_WaxLab_Stop")) != null) {
                    toolBarMidiMapper.registerMidiAction(comp, "Stop");
                }
                waxLabPanel.setMidiMapper((MidiMapper)toolBarMidiMapper);
            }
            WaxLabToolContextImpl pluginContext = toolContext;
            WaxLabDevice device = new WaxLabDevice((DeviceProvider)this, devName, waxInfo, waxLabImpl, (WaxLabPanel)waxLabPanel, (WaxLabPluginContext)pluginContext, this.midiEngineConfig);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createDevice: result=" + device);
            }
            return device;
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    protected Component getComponent(Component[] comps, String name) {
        int num = comps.length;
        for (int i = 0; i < num; ++i) {
            if (!name.equals(comps[i].getName())) continue;
            return comps[i];
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        AudioPortType apt = AudioPortType.getAudioPortType((String)typeName);
        if (apt != null) {
            return apt;
        }
        return MidiPortType.getMidiPortType((String)typeName);
    }

    protected SoundSystem lookupSoundSystem() {
        try {
            return SoundPlugin.getInstance().getSoundSystem();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    protected MediaLibrary lookupMediaLibrary() {
        try {
            return MediaManagerPlugin.getInstance().getMediaLibrary();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public MidiEngineConfig getMidiEngineConfig() {
        return this.midiEngineConfig;
    }

    public void setMidiEngineConfig(MidiEngineConfig midiEngineConfig) {
        this.midiEngineConfig = midiEngineConfig;
    }

    public ToolGroup getToolBarGroup() {
        return this.toolBarGroup;
    }

    public void setToolBarGroup(ToolGroup toolBarGroup) {
        this.toolBarGroup = toolBarGroup;
    }

    public ToolGroup getCornerPopupMenuGroup() {
        return this.cornerPopupMenuGroup;
    }

    public void setCornerPopupMenuGroup(ToolGroup cornerPopupMenuGroup) {
        this.cornerPopupMenuGroup = cornerPopupMenuGroup;
    }

    public ToolProvider getEditorMenuInsertToolProvider() {
        return this.editorMenuInsertToolProvider;
    }

    public void setEditorMenuInsertToolProvider(ToolProvider editorMenuInsertToolProvider) {
        this.editorMenuInsertToolProvider = editorMenuInsertToolProvider;
    }

    public ToolGroup getAudioLinePopupMenuGroup() {
        return this.audioLinePopupMenuGroup;
    }

    public void setAudioLinePopupMenuGroup(ToolGroup audioLinePopupMenuGroup) {
        this.audioLinePopupMenuGroup = audioLinePopupMenuGroup;
    }

    public ToolGroup getTimecodeLinePopupMenuGroup() {
        return this.timecodeLinePopupMenuGroup;
    }

    public void setTimecodeLinePopupMenuGroup(ToolGroup timecodeLinePopupMenuGroup) {
        this.timecodeLinePopupMenuGroup = timecodeLinePopupMenuGroup;
    }

    public ToolGroup getMidiLinePopupMenuGroup() {
        return this.midiLinePopupMenuGroup;
    }

    public void setMidiLinePopupMenuGroup(ToolGroup midiLinePopupMenuGroup) {
        this.midiLinePopupMenuGroup = midiLinePopupMenuGroup;
    }

    public ToolGroup getFaderLinePopupMenuGroup() {
        return this.faderLinePopupMenuGroup;
    }

    public void setFaderLinePopupMenuGroup(ToolGroup faderLinePopupMenuGroup) {
        this.faderLinePopupMenuGroup = faderLinePopupMenuGroup;
    }

    public ToolGroup getEditorLinePopupMenuGroup() {
        return this.editorLinePopupMenuGroup;
    }

    public void setEditorLinePopupMenuGroup(ToolGroup editorLinePopupMenuGroup) {
        this.editorLinePopupMenuGroup = editorLinePopupMenuGroup;
    }

    public ToolGroup getTitlePopupMenuGroup() {
        return this.titlePopupMenuGroup;
    }

    public void setTitlePopupMenuGroup(ToolGroup titlePopupMenuGroup) {
        this.titlePopupMenuGroup = titlePopupMenuGroup;
    }

    public ToolGroup getRulerPopupMenuGroup() {
        return this.rulerPopupMenuGroup;
    }

    public void setRulerPopupMenuGroup(ToolGroup rulerPopupMenuGroup) {
        this.rulerPopupMenuGroup = rulerPopupMenuGroup;
    }

    protected static class ToolBarMidiMapper
    extends AbstractMidiMapper {
        private WaxLab waxLab;

        public ToolBarMidiMapper(WaxLab waxLab) {
            this.waxLab = waxLab;
        }

        public MidiMapping[] getMidiMappings(Object component) {
            return this.waxLab.getMidiMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            this.waxLab.setMidiMappings(mappings);
        }
    }
}

