/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.plugin;

import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.plugin.WaxLabToolContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabExtensions {
    private static final Logger logger = Logger.getLogger(WaxLabExtensions.class.getName());

    private WaxLabExtensions() {
    }

    public static void showWaxLabView(Workbench wb) throws Exception {
        String viewProviderId = "WaxLabViewProvider";
        boolean newInstance = false;
        WorkbenchUtilities.openView((Workbench)wb, (String)viewProviderId, (boolean)newInstance);
    }

    protected static void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public static class DeselectAllAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.deselectAll();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class SelectAllAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.selectAll();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class MovieGeneratorAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.openMovieGeneratorDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class TimecodeGeneratorAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.openTimecodeGeneratorDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class ScratchAnalyzerAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.openScratchAnalyzerDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class TimecodeDecoderAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.openTimecodeDecoderDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EditorPropertiesAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.showProperties();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class InsertScratchPatternAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.showInsertScratchPatternDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class InsertTimecodePointAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.insertTimecodePoint();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class InsertFaderClickAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.insertFaderClick();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EditorPasteAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.pasteElements();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EditorCutAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.cutSelectedElements();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EditorCloneAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.cloneSelectedElements();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EditorCopyAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.copySelectedElements();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabInverseAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeInverseAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabReverseAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeReverseAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabInsertFileAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeInsertFileAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabPasteReplaceAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokePasteReplaceAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabPasteAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokePasteAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabDeleteAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeDeleteAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabCutAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeCutAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class WaxLabCopyAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.invokeCopyAction();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class EvalPeriodExpiredAction
    extends TAction {
        public EvalPeriodExpiredAction() {
            this.setText("Evaluation period expired!");
            this.setTooltip("Please purchase a product license");
        }

        public void invoke(Object instance) {
            logger.info("Evaluation period expired!");
        }
    }

    public static class RemoveSelectedElementsAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
                ctx.removeSelectedElements();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class LayoutTopDownAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.setOrientation(2);
        }
    }

    public static class LayoutLeftRightAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.setOrientation(0);
        }
    }

    public static class MaximizeSelectedLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            Line selLine = null;
            Line[] selLines = ctx.getSelectedLines();
            if (selLines != null && selLines.length > 0) {
                selLine = selLines[0];
            }
            if (selLine != null && ctx.getMaximizedLine() == selLine) {
                selLine = null;
            }
            ctx.setMaximizedLine(selLine);
        }
    }

    public static class MoveSelectedLinesDownAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.moveSelectedLines(1);
        }
    }

    public static class MoveSelectedLinesUpAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.moveSelectedLines(-1);
        }
    }

    public static class RemoveSelectedLinesAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.removeSelectedLines();
        }
    }

    public static class DvsViewToggleAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showDvsViewAction();
        }
    }

    public static class StopAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.stop();
        }
    }

    public static class PauseAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.pause();
        }
    }

    public static class StartAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.start();
        }
    }

    public static class ConfigureSelectedLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showConfigureSelectedLineDialog();
        }
    }

    public static class AddEditorLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showAddEditorLineDialog();
        }
    }

    public static class AddTimecodeLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showAddTimecodeLineDialog();
        }
    }

    public static class AddMidiLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showAddMidiLineDialog();
        }
    }

    public static class AddAudioLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showAddAudioLineDialog();
        }
    }

    public static class ExportSelectedLineAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            try {
                ctx.showExportSelectedLineDialog();
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }

    public static class OpenSettingsAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showSettingsDialog();
        }
    }

    public static class OpenWizardAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showWizardDialog();
        }
    }

    public static class SaveAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.save();
        }
    }

    public static class OpenFileAction
    extends TAction {
        public void invoke(Object instance) {
            WaxLabToolContext ctx = (WaxLabToolContext)this.getToolContext(instance);
            ctx.showOpenFileDialog();
        }
    }

    public static class ShowWaxLabAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                WaxLabExtensions.showWaxLabView(this.getWorkbench(instance));
            }
            catch (Exception e) {
                WaxLabExtensions.handleException(e);
            }
        }
    }
}

