/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.plugin;

import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.plugin.WaxLabMidiAction;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import javax.sound.midi.MidiMessage;

public class WaxLabMidiActions {
    private WaxLabMidiActions() {
    }

    protected static class RefreshMidiLightingAction
    extends AbstractMidiAction {
        private AbstractWaxLabPanel waxLabPanel;

        public RefreshMidiLightingAction(AbstractWaxLabPanel waxLabPanel) {
            super("RefreshLighting");
            this.setTitle("Refresh Lighting");
            this.waxLabPanel = waxLabPanel;
        }

        public void invoke(long time, int status, int data1, int data2) {
            WaxLab waxLab;
            if (data2 < 1) {
                return;
            }
            AbstractWaxLabPanel panel = this.waxLabPanel;
            if (panel != null && (waxLab = panel.getWaxLab()) != null) {
                waxLab.refreshMidiLightings();
            }
        }

        public void systemExclusive(long time, MidiMessage mm) {
            WaxLab waxLab;
            super.systemExclusive(time, mm);
            AbstractWaxLabPanel panel = this.waxLabPanel;
            if (panel != null && (waxLab = panel.getWaxLab()) != null) {
                waxLab.refreshMidiLightings();
            }
        }
    }

    protected static class ToggleStartStopAction
    extends AbstractWaxLabMidiAction {
        public ToggleStartStopAction(AbstractWaxLabPanel waxLabPanel) {
            super(waxLabPanel, "ToggleStartStop");
            this.setTitle("Toggle Start/Stop");
        }

        @Override
        protected void execute(long time) throws Exception {
            if (this.waxLabPanel.isActive()) {
                this.waxLabPanel.actionStop();
            } else {
                this.waxLabPanel.actionStart();
            }
        }
    }

    protected static class ToggleStartPauseAction
    extends AbstractWaxLabMidiAction {
        public ToggleStartPauseAction(AbstractWaxLabPanel waxLabPanel) {
            super(waxLabPanel, "ToggleStartPause");
            this.setTitle("Toggle Start/Pause");
        }

        @Override
        protected void execute(long time) throws Exception {
            if (this.waxLabPanel.isActive()) {
                this.waxLabPanel.actionPause();
            } else {
                this.waxLabPanel.actionStart();
            }
        }
    }

    protected static class StopAction
    extends AbstractWaxLabMidiAction {
        public StopAction(AbstractWaxLabPanel waxLabPanel) {
            super(waxLabPanel, "Stop");
            this.setTitle("Stop");
        }

        @Override
        protected void execute(long time) throws Exception {
            this.waxLabPanel.actionStop();
        }
    }

    protected static class PauseAction
    extends AbstractWaxLabMidiAction {
        public PauseAction(AbstractWaxLabPanel waxLabPanel) {
            super(waxLabPanel, "Pause");
            this.setTitle("Pause");
        }

        @Override
        protected void execute(long time) throws Exception {
            this.waxLabPanel.actionPause();
        }
    }

    protected static class StartAction
    extends AbstractWaxLabMidiAction {
        public StartAction(AbstractWaxLabPanel waxLabPanel) {
            super(waxLabPanel, "Start");
            this.setTitle("Start");
        }

        @Override
        protected void execute(long time) throws Exception {
            this.waxLabPanel.actionStart();
        }
    }

    protected static abstract class AbstractWaxLabMidiAction
    extends WaxLabMidiAction {
        protected final AbstractWaxLabPanel waxLabPanel;

        public AbstractWaxLabMidiAction(AbstractWaxLabPanel waxLabPanel, String name) {
            super(name);
            this.waxLabPanel = waxLabPanel;
        }
    }
}

