/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.plugin;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Injection;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.DefaultAreaConfig;
import com.spacekiller.util.heap.DefaultHeapConfig;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.heap.HeapManager;
import com.spacekiller.util.heap.ManagedHeap;
import com.spacekiller.util.heap.plugin.HeapManagerPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabPlugin
extends Plugin {
    public static final String WAXLAB_PLUGIN_ID = "com.waxmonster.waxlab.plugin.WaxLabPlugin";
    public static final String POINT_SCRATCH_PATTERN_PROVIDER = "com.waxmonster.editor.ScratchPatternProvider";
    public static final String POINT_TIMECODE_FORMAT = "com.waxmonster.timecode.TimecodeFormat";
    private static final int DEFAULT_HEAP_PAGE_SIZE = 0x100000;
    private static final long DEFAULT_SWAP_FILE_SIZE = -1L;
    private static final int DEFAULT_BLOCK_SIZE = 262144;
    private static final int DEFAULT_COPY_BUFFER_SIZE = 262144;
    private static final Logger logger = Platform.getLogger(WaxLabPlugin.class);
    private HeapManager heapManager;
    private Heap mutationHeap;
    private int mutationBlockSize = 262144;

    public static WaxLabPlugin getInstance() throws Exception {
        return (WaxLabPlugin)Platform.getInstance().getPlugin(WAXLAB_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
    }

    protected void shutdown() {
        super.shutdown();
    }

    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        super.extensionAvailable(point, x);
    }

    protected void extensionUnavailable(ExtensionPoint point, Extension x) {
        super.extensionUnavailable(point, x);
    }

    protected Injection getInjection() {
        return super.getInjection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HeapManager getHeapManager() throws Exception {
        if (this.heapManager == null) {
            WaxLabPlugin waxLabPlugin = this;
            synchronized (waxLabPlugin) {
                if (this.heapManager == null) {
                    this.setHeapManager(this.createHeapManager());
                }
            }
        }
        return this.heapManager;
    }

    protected void setHeapManager(HeapManager heapManager) {
        this.heapManager = heapManager;
    }

    protected HeapManager createHeapManager() throws Exception {
        return HeapManagerPlugin.getInstance().getHeapManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Heap getMutationHeap() throws Exception {
        if (this.mutationHeap == null) {
            WaxLabPlugin waxLabPlugin = this;
            synchronized (waxLabPlugin) {
                if (this.mutationHeap == null) {
                    this.setMutationHeap(this.createMutationHeap());
                }
            }
        }
        return this.mutationHeap;
    }

    protected void setMutationHeap(ManagedHeap mutationHeap) {
        this.mutationHeap = mutationHeap;
    }

    protected ManagedHeap createMutationHeap() throws Exception {
        DefaultHeapConfig config = null;
        if (config == null) {
            config = WaxLabPlugin.createMutationHeapConfig();
        }
        HeapManager manager = this.getHeapManager();
        ManagedHeap heap = manager.createHeap((HeapConfig)config);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Created mutation heap: " + heap);
        }
        return heap;
    }

    public static DefaultHeapConfig createMutationHeapConfig() {
        DefaultHeapConfig config = new DefaultHeapConfig();
        config.setName("WaxLabMutationHeap");
        config.setDefaultPageSize(0x100000);
        config.setCopyBufferSize(262144);
        config.setJavaHeapPreferred(true);
        DefaultAreaConfig javaHeapAreaConfig = new DefaultAreaConfig();
        javaHeapAreaConfig.setAreaEnabled(false);
        config.setJavaHeapAreaConfig((AreaConfig)javaHeapAreaConfig);
        DefaultAreaConfig directHeapAreaConfig = new DefaultAreaConfig();
        directHeapAreaConfig.setAreaEnabled(false);
        config.setDirectHeapAreaConfig((AreaConfig)directHeapAreaConfig);
        DefaultAreaConfig swapFileAreaConfig = new DefaultAreaConfig();
        swapFileAreaConfig.setAreaEnabled(true);
        swapFileAreaConfig.setMaxAreaSize(-1L);
        config.setSwapFileAreaConfig((AreaConfig)swapFileAreaConfig);
        return config;
    }

    public int getMutationBlockSize() {
        return this.mutationBlockSize;
    }

    protected void setMutationBlockSize(int mutationBlockSize) {
        this.mutationBlockSize = mutationBlockSize;
    }
}

