/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.plugin;

import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.workbench.DesktopView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewConstraints;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.waxmonster.studio.impl.StudioXmlUtil;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.dvs.WaxLabDvsPanel;
import com.waxmonster.waxlab.dvs.WaxLabDvsView;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabPluginContext;
import com.waxmonster.waxlab.plugin.WaxLabToolContext;
import com.waxmonster.waxlab.view.AbstractWaxLabPanel;
import com.waxmonster.waxlab.view.DefaultWaxLabPanel;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JOptionPane;

public class WaxLabToolContextImpl
extends AbstractToolContext
implements WaxLabToolContext,
WaxLabPluginContext {
    private static final String KEY_DVS_BOUNDS = "dvsBounds";
    private static final String KEY_DVS_DETACHED = "dvsDetached";
    private static final String KEY_DVS_DETACHED_BOUNDS = "dvsDetachedBounds";
    private static final String KEY_DVS_DECK_LAYOUT = "dvsDeckLayout";
    private WaxLab waxLab;
    private LockFactory lockFactory;
    private AbstractWaxLabPanel waxLabPanel;
    private WaxLabDvsView waxLabDvsView;
    private WaxLabDvsPanel waxLabDvsPanel;

    public WaxLabToolContextImpl(AbstractWaxLabPanel waxLabPanel, WaxLab waxLab, LockFactory lockFactory) {
        this.waxLabPanel = waxLabPanel;
        this.waxLab = waxLab;
        this.lockFactory = lockFactory;
        this.initWaxLabToolContextImpl();
    }

    protected void initWaxLabToolContextImpl() {
        try {
            this.setProperty("openEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"openEnabled"));
            this.setProperty("saveEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"saveEnabled"));
            this.setProperty("startEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"startEnabled"));
            this.setProperty("pauseEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"pauseEnabled"));
            this.setProperty("stopEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"stopEnabled"));
            this.setProperty("lineSelected", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"lineSelected"));
            this.setProperty("moveUpEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"moveUpEnabled"));
            this.setProperty("moveDownEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"moveDownEnabled"));
            this.setProperty("linePanelAreaSelected", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"linePanelAreaSelected"));
            this.setProperty("linePanelCopyEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"linePanelCopyEnabled"));
            this.setProperty("linePanelCutEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"linePanelCutEnabled"));
            this.setProperty("linePanelPasteEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"linePanelPasteEnabled"));
            this.setProperty("audioLineSelected", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"audioLineSelected"));
            this.setProperty("timecodeLineSelected", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"timecodeLineSelected"));
            this.setProperty("editorCopyEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorCopyEnabled"));
            this.setProperty("editorCloneEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorCloneEnabled"));
            this.setProperty("editorCutEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorCutEnabled"));
            this.setProperty("editorPasteEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorPasteEnabled"));
            this.setProperty("editorPropertiesEnabled", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorPropertiesEnabled"));
            this.setProperty("editorElementsSelected", (Property)BeanProperty.getBeanProperty((Object)this.waxLabPanel, (String)"editorElementsSelected"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WaxLab getStudio() {
        return this.waxLabPanel.getWaxLab();
    }

    @Override
    public void showOpenFileDialog() {
        this.waxLabPanel.actionOpen();
    }

    @Override
    public void save() {
        this.waxLabPanel.actionSave();
    }

    @Override
    public void showSettingsDialog() {
        this.waxLabPanel.showSettingsDialog();
    }

    @Override
    public void showWizardDialog() {
        this.waxLabPanel.showWizardDialog();
    }

    @Override
    public void showAddAudioLineDialog() {
        this.waxLabPanel.addAudioLine();
    }

    @Override
    public void showAddMidiLineDialog() {
        this.waxLabPanel.addMidiLine();
    }

    @Override
    public void showAddTimecodeLineDialog() {
        this.waxLabPanel.addTimecodeLine();
    }

    @Override
    public void showAddEditorLineDialog() {
        this.waxLabPanel.addEditorLine();
    }

    @Override
    public void showConfigureSelectedLineDialog() {
        this.waxLabPanel.showLineConfigDialog();
    }

    @Override
    public void showDvsViewAction() {
        int numDecks = 0;
        int numLines = this.waxLab.getLineCount();
        for (int i = 0; i < numLines; ++i) {
            AbstractScratchLine scratchLine;
            ScratchDeck scratchDeck;
            Line line = this.waxLab.getLineAt(i);
            if (line == null || !(line instanceof AbstractScratchLine) || (scratchDeck = (scratchLine = (AbstractScratchLine)line).getScratchDeck()) == null) continue;
            ++numDecks;
        }
        if (numDecks < 1) {
            String title = "Missing DVS-Decks";
            String message = "There are currently no DVS decks (lines) in this project to display.";
            int messageType = 2;
            JOptionPane.showMessageDialog((Component)this.waxLabPanel, message, title, messageType);
            return;
        }
        this.setDvsViewVisible(true);
    }

    @Override
    public void hideDvsViewAction() {
        this.setDvsViewVisible(false);
    }

    @Override
    public void start() {
        this.waxLabPanel.actionStart();
    }

    @Override
    public void pause() {
        this.waxLabPanel.actionPause();
    }

    @Override
    public void stop() {
        this.waxLabPanel.actionStop();
    }

    @Override
    public Line[] getSelectedLines() {
        return this.waxLabPanel.getSelectedStudioLines();
    }

    @Override
    public int getOrientation() {
        return this.waxLabPanel.getOrientation();
    }

    @Override
    public void setOrientation(int orientation) {
        this.waxLabPanel.setOrientation(orientation);
    }

    public void clearSelectedLines() {
        throw new UnsupportedOperationException("TODO");
    }

    public void clearAllLines() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void removeSelectedLines() {
        this.waxLabPanel.removeSelectedLines();
    }

    @Override
    public void removeAllLines() {
        this.waxLabPanel.removeAllLines();
    }

    @Override
    public void moveSelectedLines(int positions) {
        this.waxLabPanel.moveSelectedLines(positions);
    }

    @Override
    public Line getMaximizedLine() {
        return this.waxLabPanel.getMaximizedLine();
    }

    @Override
    public void setMaximizedLine(Line line) {
        this.waxLabPanel.setMaximizedLine(line);
    }

    @Override
    public void removeSelectedElements() throws Exception {
        this.waxLabPanel.removeSelectedElements();
    }

    @Override
    public void copySelectedElements() throws Exception {
        this.waxLabPanel.copySelectedElements();
    }

    @Override
    public void cloneSelectedElements() throws Exception {
        this.waxLabPanel.cloneSelectedElements();
    }

    @Override
    public void cutSelectedElements() throws Exception {
        this.waxLabPanel.cutSelectedElements();
    }

    @Override
    public void pasteElements() throws Exception {
        this.waxLabPanel.pasteElements();
    }

    @Override
    public void insertTimecodePoint() throws Exception {
        this.waxLabPanel.insertTimecodePoint();
    }

    @Override
    public void insertFaderClick() throws Exception {
        this.waxLabPanel.insertFaderClick();
    }

    @Override
    public void showInsertScratchPatternDialog() throws Exception {
        this.waxLabPanel.showInsertScratchPatternDialog();
    }

    @Override
    public void showProperties() throws Exception {
        this.waxLabPanel.showPropertiesDialog();
    }

    @Override
    public void openTimecodeGeneratorDialog() throws Exception {
        this.waxLabPanel.openTimecodeGeneratorDialog();
    }

    @Override
    public void openMovieGeneratorDialog() throws Exception {
        this.waxLabPanel.openMovieGeneratorDialog();
    }

    @Override
    public void openTimecodeDecoderDialog() throws Exception {
        this.waxLabPanel.openTimecodeDecoderDialog();
    }

    @Override
    public void openScratchAnalyzerDialog() throws Exception {
        this.waxLabPanel.openScratchAnalyzerDialog();
    }

    @Override
    public void showExportSelectedLineDialog() throws Exception {
        this.waxLabPanel.showExportSelectedLineDialog();
    }

    @Override
    public void selectAll() throws Exception {
        this.waxLabPanel.selectAll();
    }

    @Override
    public void deselectAll() throws Exception {
        this.waxLabPanel.deselectAll();
    }

    @Override
    public void invokeCopyAction() throws Exception {
        this.waxLabPanel.invokeCopyAction();
    }

    @Override
    public void invokeCutAction() throws Exception {
        this.waxLabPanel.invokeCutAction();
    }

    @Override
    public void invokeDeleteAction() throws Exception {
        this.waxLabPanel.invokeDeleteAction();
    }

    @Override
    public void invokePasteAction() throws Exception {
        this.waxLabPanel.invokePasteAction();
    }

    @Override
    public void invokePasteReplaceAction() throws Exception {
        this.waxLabPanel.invokePasteReplaceAction();
    }

    @Override
    public void invokeInsertFileAction() throws Exception {
        this.waxLabPanel.invokeInsertFileAction();
    }

    @Override
    public void invokeReverseAction() throws Exception {
        this.waxLabPanel.invokeReverseAction();
    }

    @Override
    public void invokeInverseAction() throws Exception {
        this.waxLabPanel.invokeInverseAction();
    }

    public void updateWaxLabDeviceProperties() {
        View dvsParent;
        WaxLabDevice device = this.waxLabPanel.getWaxLabDevice();
        if (device == null) {
            return;
        }
        WaxLabDvsView dvsView = this.waxLabDvsView;
        if (dvsView != null && (dvsParent = dvsView.getParent()) != null && dvsParent instanceof DesktopView) {
            Rectangle detachedBounds;
            DesktopView desktopView = (DesktopView)dvsParent;
            Rectangle bounds = desktopView.getViewNormalBounds((View)dvsView);
            if (bounds != null) {
                device.setProperty(KEY_DVS_BOUNDS, StudioXmlUtil.formatRectangle((Rectangle)bounds));
            }
            if ((detachedBounds = desktopView.getViewDetachedBounds((View)dvsView)) != null) {
                device.setProperty(KEY_DVS_DETACHED_BOUNDS, StudioXmlUtil.formatRectangle((Rectangle)detachedBounds));
            }
            boolean detached = desktopView.isViewDetached((View)dvsView);
            device.setProperty(KEY_DVS_DETACHED, String.valueOf(detached));
            WaxLabDvsPanel dvsPanel = this.waxLabDvsPanel;
            if (dvsPanel != null) {
                int deckLayout = dvsPanel.getDeckLayout();
                device.setProperty(KEY_DVS_DECK_LAYOUT, String.valueOf(deckLayout));
            }
        }
    }

    protected void setDvsViewVisible(boolean visible) {
        Workbench workbench = WorkbenchUtilities.getWorkbench((Component)this.waxLabPanel);
        if (workbench == null) {
            return;
        }
        Perspective perspective = workbench.getPerspective();
        if (perspective == null) {
            return;
        }
        if (this.waxLabDvsView == null && !visible) {
            return;
        }
        WaxLabDvsView dvsView = this.getWaxLabDvsView();
        if (dvsView == null) {
            return;
        }
        if (visible) {
            WaxLabDevice device;
            ViewConstraints constr = null;
            WaxLabDevice waxLabDevice = device = this.waxLabPanel == null ? null : this.waxLabPanel.getWaxLabDevice();
            if (device != null) {
                String dvsLayout;
                WaxLabDvsPanel dvsPanel;
                String dvsBounds = device.getProperty(KEY_DVS_BOUNDS);
                if (dvsBounds != null) {
                    String detached;
                    String detachedBounds;
                    constr = new ViewConstraints();
                    Rectangle rect = StudioXmlUtil.parseRectangle((String)dvsBounds);
                    if (rect != null) {
                        constr.setBounds(rect);
                    }
                    if ((rect = StudioXmlUtil.parseRectangle((String)(detachedBounds = device.getProperty(KEY_DVS_DETACHED_BOUNDS)))) != null) {
                        constr.setDetachedBounds(rect);
                    }
                    if ((detached = device.getProperty(KEY_DVS_DETACHED)) != null) {
                        constr.setDetached("true".equalsIgnoreCase(detached));
                    }
                    dvsView.setViewConstraints(constr);
                }
                if ((dvsPanel = this.getWaxLabDvsPanel()) != null && (dvsLayout = device.getProperty(KEY_DVS_DECK_LAYOUT)) != null && dvsLayout.length() > 0) {
                    try {
                        int deckLayout = Integer.parseInt(dvsLayout.trim());
                        dvsPanel.setDeckLayout(deckLayout);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            perspective.addView((View)dvsView);
            if (constr == null) {
                perspective.detachView((View)dvsView);
            }
            perspective.toFront((View)dvsView);
        } else {
            perspective.removeView((View)dvsView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaxLabDvsView getWaxLabDvsView() {
        if (this.waxLabDvsView == null) {
            WaxLabToolContextImpl waxLabToolContextImpl = this;
            synchronized (waxLabToolContextImpl) {
                if (this.waxLabDvsView == null) {
                    this.setWaxLabDvsView(this.createWaxLabDvsView());
                }
            }
        }
        return this.waxLabDvsView;
    }

    protected void setWaxLabDvsView(WaxLabDvsView waxLabDvsView) {
        this.waxLabDvsView = waxLabDvsView;
    }

    protected WaxLabDvsView createWaxLabDvsView() {
        WaxLabDvsPanel dvsPanel = this.getWaxLabDvsPanel();
        WaxLabDvsView dvsView = new WaxLabDvsView(dvsPanel);
        dvsView.setName("WaxLabDvsView");
        dvsView.setTitle("Wax Lab DVS");
        dvsView.setTooltip("Wax Lab (Digital Vinyl System)");
        dvsView.setIcon(Tools.getIcon(DefaultWaxLabPanel.class, (String)"/com/waxmonster/waxlab/view/icons/deck_icon.gif"));
        dvsPanel.setDvsView(dvsView);
        return dvsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaxLabDvsPanel getWaxLabDvsPanel() {
        if (this.waxLabDvsPanel == null) {
            WaxLabToolContextImpl waxLabToolContextImpl = this;
            synchronized (waxLabToolContextImpl) {
                if (this.waxLabDvsPanel == null) {
                    this.setWaxLabDvsPanel(this.createWaxLabDvsPanel());
                }
            }
        }
        return this.waxLabDvsPanel;
    }

    protected void setWaxLabDvsPanel(WaxLabDvsPanel waxLabDvsPanel) {
        this.waxLabDvsPanel = waxLabDvsPanel;
    }

    protected WaxLabDvsPanel createWaxLabDvsPanel() {
        WaxLabDvsPanel dvsPanel = new WaxLabDvsPanel(this.lockFactory);
        dvsPanel.setOpaque(true);
        dvsPanel.setPluginContext((WaxLabPluginContext)this);
        dvsPanel.setWaxLab(this.waxLab);
        WaxLabViewSettings viewSettings = this.waxLabPanel.getViewSettings();
        dvsPanel.setViewSettings(viewSettings);
        return dvsPanel;
    }
}

