/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.midi;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.midi.MidiMediaScanner;

public class MidiMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "MIDI";
    private static final String FILE_EXTENSION_MID = ".mid";
    private static final String DEFAULT_FILE_EXTENSION = ".mid";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".mid"};
    private static final String FILE_FORMAT_TITLE = "MIDI File";
    private MediaScanner mediaScanner;

    public MidiMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/midi/icons/midi_file_icon16.png"));
        this.setDefaultExtension(".mid");
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        SimpleFileFormatSignature midiFileSignature = new SimpleFileFormatSignature("MIDI Header", (FileFormat)this, 0, "MThd".getBytes());
        this.setSupportedSignatures(new FileFormatSignature[]{midiFileSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new MidiMediaScanner();
        }
        return this.mediaScanner;
    }
}

