/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.midi;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.midi.MidiMeta;
import com.spacekiller.util.midi.impl.DefaultMidiMeta;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiMediaScanner
implements MediaScanner {
    private static final Logger logger = Logger.getLogger(MidiMediaScanner.class.getName());
    public static final String FORMAT_MIDI = "MIDI";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        Sequence sequence = null;
        try {
            InputStream stream = resource.createInputStream();
            try {
                sequence = MidiSystem.getSequence(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (InvalidMidiDataException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            throw new StreamCorruptedException(e.getMessage());
        }
        if (sequence == null) {
            return null;
        }
        mme.setFormat(FORMAT_MIDI);
        long microLength = sequence.getMicrosecondLength();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Scanning MIDI resource: " + resource + ", microLength=" + microLength);
        }
        String title = null;
        String artist = null;
        double bpm = -1.0;
        boolean bpmAvail = false;
        Track[] tracks = sequence.getTracks();
        int trackCount = tracks == null ? 0 : tracks.length;
        for (int i = 0; i < trackCount; ++i) {
            Track track = tracks[i];
            if (track == null) continue;
            int eventCount = track.size();
            block12: for (int k = 0; k < eventCount; ++k) {
                MetaMessage metaMsg;
                MidiMeta meta;
                MidiEvent event = track.get(k);
                if (event == null) continue;
                long tick = event.getTick();
                MidiMessage message = event.getMessage();
                if (message == null || !(message instanceof MetaMessage) || (meta = DefaultMidiMeta.parseMidiMeta((MetaMessage)(metaMsg = (MetaMessage)message))) == null) continue;
                switch (meta.getType()) {
                    case 3: {
                        if (!(meta instanceof MidiMeta.SequenceName)) continue block12;
                        String sequenceName = ((MidiMeta.SequenceName)meta).getText();
                        sequenceName = sequenceName.trim();
                        if (i != 0) continue block12;
                        if (title == null) {
                            title = sequenceName;
                            continue block12;
                        }
                        if (artist == null) {
                            artist = sequenceName;
                            continue block12;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue block12;
                        logger.fine("Ignored: track=#" + i + ", tick=" + tick + ", sequenceName = " + sequenceName);
                        continue block12;
                    }
                    case 1: {
                        continue block12;
                    }
                    case 2: {
                        if (!(meta instanceof MidiMeta.CopyrightNotice)) continue block12;
                        String copyrightNotice = ((MidiMeta.CopyrightNotice)meta).getText();
                        if (i != 0 || !logger.isLoggable(Level.FINE)) continue block12;
                        logger.fine("Ignored: track=#" + i + ", tick=" + tick + ", copyrightNotice = " + copyrightNotice);
                        continue block12;
                    }
                    case 81: {
                        double beatsPerMinute;
                        if (!(meta instanceof MidiMeta.TempoSetting) || !((beatsPerMinute = ((MidiMeta.TempoSetting)meta).getBeatsPerMinute()) > 0.0)) continue block12;
                        if (bpmAvail) {
                            if (beatsPerMinute == bpm) continue block12;
                            bpm = -1.0;
                            continue block12;
                        }
                        bpmAvail = true;
                        bpm = beatsPerMinute;
                        continue block12;
                    }
                    default: {
                        if (!logger.isLoggable(Level.FINER) || !(meta instanceof MidiMeta.Text)) continue block12;
                        MidiMeta.Text text = (MidiMeta.Text)meta;
                        logger.finer("Unknown meta text: track=#" + i + ", tick=" + tick + ", text=" + text.getText() + ", meta=" + meta);
                    }
                }
            }
        }
        if (title != null && (title = title.trim()).length() > 0) {
            mme.setTitle(title);
        }
        if (artist != null && (artist = artist.trim()).length() > 0) {
            mme.setArtist(artist);
        }
        if (microLength >= 0L) {
            double durationSeconds = (double)microLength / 1000000.0;
            mme.setDuration(durationSeconds);
        }
        if (bpmAvail && bpm > 0.0) {
            mae.setBpmStored(bpm);
        }
        return mme;
    }
}

