/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import org.kc7bfi.jflac.Constants;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.apps.ExtensionFileFilter;
import org.kc7bfi.jflac.io.BitOutputStream;
import org.kc7bfi.jflac.metadata.SeekPoint;
import org.kc7bfi.jflac.metadata.SeekTable;
import org.kc7bfi.jflac.metadata.StreamInfo;

public class FlacPacker
extends JFrame {
    private JTextArea textArea = new JTextArea(16, 50);
    private JButton addButton = new JButton("Add Files");
    private JButton makeButton = new JButton("Pack FLAC");
    private ArrayList flacFiles = new ArrayList();
    private ArrayList albumFiles = new ArrayList();
    private StreamInfo masterStreamInfo = null;
    private byte[] buffer = new byte[65536];

    public FlacPacker(String title) {
        super(title);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea.setText("");
        this.textArea.setAutoscrolls(true);
        this.getContentPane().add((Component)this.textArea, "Center");
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.makeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FlacPacker.this.addFilesToList();
            }
        });
        this.makeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    FlacPacker.this.packFlac();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void appendMsg(String msg) {
        this.textArea.setText(this.textArea.getText() + msg + "\n");
        this.textArea.repaint();
    }

    private void addFilesToList() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension("flac");
        filter.setDescription("FLAC files");
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File("."));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            this.flacFiles.add(files[i]);
        }
    }

    private File getOutputFile() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension("flac");
        filter.setDescription("FLAC files");
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File("."));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    private SeekTable makeSeekTable() {
        long lastSampleNumber = 0L;
        long lastStreamOffset = 0L;
        for (int i = 0; i < this.flacFiles.size(); ++i) {
            File file = (File)this.flacFiles.get(i);
            try {
                FileInputStream is = new FileInputStream(file);
                FLACDecoder decoder = new FLACDecoder(is);
                decoder.readMetadata();
                StreamInfo info = decoder.getStreamInfo();
                if (this.masterStreamInfo == null) {
                    this.masterStreamInfo = info;
                    this.masterStreamInfo.setTotalSamples(0L);
                }
                if (!info.compatiable(this.masterStreamInfo)) {
                    this.appendMsg("Bad StreamInfo " + file + ": " + info);
                    continue;
                }
                this.masterStreamInfo.addTotalSamples(info.getTotalSamples());
                SeekPoint seekPoint = new SeekPoint(lastSampleNumber, lastStreamOffset, 0);
                long frameStartOffs = decoder.getTotalBytesRead();
                PackerFile aFile = new PackerFile(file, seekPoint, frameStartOffs);
                this.albumFiles.add(aFile);
                try {
                    decoder.decodeFrames();
                }
                catch (EOFException e) {
                    // empty catch block
                }
                long frameEndOffs = decoder.getTotalBytesRead();
                lastSampleNumber += decoder.getSamplesDecoded();
                lastStreamOffset += frameEndOffs - frameStartOffs;
                continue;
            }
            catch (FileNotFoundException e) {
                this.appendMsg("File " + file + ": " + e);
                continue;
            }
            catch (IOException e) {
                this.appendMsg("File " + file + ": " + e);
            }
        }
        SeekPoint[] points = new SeekPoint[this.albumFiles.size()];
        SeekTable seekTable = new SeekTable(points, true);
        int metadataHeader = 4;
        int metadataOffset = Constants.STREAM_SYNC_STRING.length + this.masterStreamInfo.calcLength() + seekTable.calcLength() + metadataHeader * 2;
        for (int i = 0; i < this.albumFiles.size(); ++i) {
            PackerFile aFile = (PackerFile)this.albumFiles.get(i);
            this.appendMsg("SeekTable build " + i + " Offset=" + aFile.seekPoint.getStreamOffset() + " header=" + metadataOffset);
            aFile.seekPoint.setStreamOffset(aFile.seekPoint.getStreamOffset() + (long)metadataOffset);
            points[i] = aFile.seekPoint;
        }
        return seekTable;
    }

    private void packFlac() throws IOException {
        FileOutputStream fos;
        File outFile = this.getOutputFile();
        if (outFile == null) {
            return;
        }
        BitOutputStream os = null;
        try {
            fos = new FileOutputStream(outFile);
            os = new BitOutputStream(fos);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        SeekTable seekTable = this.makeSeekTable();
        if (this.masterStreamInfo == null) {
            return;
        }
        os.writeByteBlock(Constants.STREAM_SYNC_STRING, Constants.STREAM_SYNC_STRING.length);
        this.masterStreamInfo.write(os, false);
        seekTable.write(os, true);
        for (int i = 0; i < this.albumFiles.size(); ++i) {
            PackerFile aFile = (PackerFile)this.albumFiles.get(i);
            this.appendMsg("Process file " + i + ": " + aFile.file);
            try {
                RandomAccessFile raf = new RandomAccessFile(aFile.file, "r");
                raf.seek(aFile.firstFrameOffset);
                int bytes = raf.read(this.buffer);
                while (bytes > 0) {
                    fos.write(this.buffer, 0, bytes);
                    bytes = raf.read(this.buffer);
                }
                fos.flush();
                continue;
            }
            catch (FileNotFoundException e) {
                this.appendMsg("File " + aFile.file + ": " + e);
                continue;
            }
            catch (EOFException e) {
                this.appendMsg("File " + aFile.file + ": Done!");
                continue;
            }
            catch (IOException e) {
                this.appendMsg("File " + aFile.file + ": " + e);
            }
        }
    }

    public static void main(String[] args) {
        FlacPacker app = new FlacPacker("FLAC Album Maker");
        app.show(true);
    }

    private class PackerFile {
        protected File file;
        protected SeekPoint seekPoint;
        protected long firstFrameOffset;

        public PackerFile(File file, SeekPoint seekPoint, long firstFrameOffset) {
            this.file = file;
            this.seekPoint = seekPoint;
            this.firstFrameOffset = firstFrameOffset;
        }
    }
}

