/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.metadata;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.metadata.Metadata;

public class Picture
extends Metadata {
    private PictureType pictureType;
    private int mimeTypeByteCount;
    private String mimeString;
    private int descStringByteCount;
    private String descString;
    private int picPixelWidth;
    private int picPixelHeight;
    private int picBitsPerPixel;
    private int picColorCount;
    private int picByteCount;
    protected byte[] image;

    public Picture(BitInputStream is, int length, boolean isLast) throws IOException {
        super(isLast, length);
        int usedBits = 0;
        int t = is.readRawUInt(32);
        for (PictureType pt : PictureType.values()) {
            if (pt.picType != t) continue;
            this.pictureType = pt;
        }
        usedBits += 32;
        this.mimeTypeByteCount = is.readRawUInt(32);
        usedBits += 32;
        byte[] data = new byte[this.mimeTypeByteCount];
        is.readByteBlockAlignedNoCRC(data, this.mimeTypeByteCount);
        usedBits += this.mimeTypeByteCount * 8;
        this.mimeString = new String(data);
        this.descStringByteCount = is.readRawUInt(32);
        usedBits += 32;
        if (this.descStringByteCount != 0) {
            data = new byte[this.descStringByteCount];
            is.readByteBlockAlignedNoCRC(data, this.descStringByteCount);
            usedBits += this.descStringByteCount * 8;
            try {
                this.descString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            this.descString = new String("");
        }
        this.picPixelWidth = is.readRawUInt(32);
        usedBits += 32;
        this.picPixelHeight = is.readRawUInt(32);
        usedBits += 32;
        this.picBitsPerPixel = is.readRawUInt(32);
        usedBits += 32;
        this.picColorCount = is.readRawUInt(32);
        usedBits += 32;
        this.picByteCount = is.readRawUInt(32);
        usedBits += 32;
        this.image = new byte[this.picByteCount];
        is.readByteBlockAlignedNoCRC(this.image, this.picByteCount);
        if ((length -= (usedBits += this.picByteCount * 8) / 8) > 0) {
            is.readByteBlockAlignedNoCRC(null, length);
        }
    }

    public PictureType getPictureType() {
        return this.pictureType;
    }

    public String getMimeString() {
        return this.mimeString;
    }

    public String getDescString() {
        return this.descString;
    }

    public int getPicPixelWidth() {
        return this.picPixelWidth;
    }

    public int getPicPixelHeight() {
        return this.picPixelHeight;
    }

    public byte[] getImage() {
        return this.image;
    }

    public String toString() {
        return "Picture:  Type=" + (Object)((Object)this.pictureType) + " MIME type=" + this.mimeString + " Description=\"" + this.descString + "\"" + " Pixels (WxH)=" + this.picPixelWidth + "x" + this.picPixelHeight + " Color Depth=" + this.picBitsPerPixel + " Color Count=" + this.picColorCount + " Picture Size (bytes)=" + this.picByteCount + " last =" + this.isLast;
    }

    public static enum PictureType {
        Other(0),
        file_icon_32x32_PNG(1),
        Other_file_icon(2),
        Cover_front(3),
        Cover_back(4),
        Leaflet_page(5),
        Media_label(6),
        Lead_artist(7),
        Artist(8),
        Conductor(9),
        Band(10),
        Composer(11),
        Lyricist(12),
        Recording_Location(13),
        During_recording(14),
        During_performance(15),
        Movie_screen_capture(16),
        Bright_coloured_fish(17),
        Illustration(18),
        Band_logotype(19),
        Publisher_logotype(20);

        final int picType;

        private PictureType(int t) {
            this.picType = t;
        }
    }
}

