/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.image;

import com.spacekiller.util.movie.AbstractMovieProducer;
import com.spacekiller.util.movie.MovieProducerType;
import com.spacekiller.util.movie.image.ImageMovieProducerPanel;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ImageMovieProducer
extends AbstractMovieProducer {
    public static final String DEFAULT_IMAGE_FORMAT_NAME = "png";
    public static final String PROPERTY_IMAGE_FORMAT_NAME = "imageFormatName";
    public static final String PROPERTY_IMAGE_OUTPUT_DIR = "imageOutputDirectory";
    public static final String PROPERTY_IMAGE_FILE_PREFIX = "imageOutputFilePrefix";
    public static final String PROPERTY_IMAGE_FILE_SUFFIX = "imageOutputFileSuffix";
    public static final String PROPERTY_OVERWRITE_FILES = "overwriteExistingFiles";
    private static final Logger logger = Logger.getLogger(ImageMovieProducer.class.getName());
    private String imageFormatName;
    private File imageOutputDirectory;
    private String imageOutputFilePrefix;
    private String imageOutputFileSuffix;
    private boolean overwriteExistingFiles;
    private long nextImageIndex;
    private long maxFramesTenPower;

    @Override
    protected void setType(MovieProducerType type) {
        super.setType(type);
    }

    @Override
    public boolean showConfigDialog(Component parentComponent) {
        ImageMovieProducerPanel panel = new ImageMovieProducerPanel();
        Properties props = this.getProperties();
        if (props == null) {
            props = new Properties();
        }
        panel.setProperties(props);
        ImageMovieProducerPanel message = panel;
        String title = "Image Movie Producer";
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
        if (rc != 0) {
            return false;
        }
        props = panel.getProperties();
        this.setProperties(props);
        return true;
    }

    @Override
    public synchronized void begin(double framesPerSecond, long maxFrames) throws Exception {
        String imageFileSuffix;
        String outputDir;
        String formatName;
        Properties props;
        long tenPower = 10L;
        while (tenPower < maxFrames) {
            if ((tenPower *= 10L) >= 10L) continue;
            tenPower = 0L;
            break;
        }
        if ((props = super.getProperties()) == null) {
            props = new Properties();
        }
        if ((formatName = props.getProperty(PROPERTY_IMAGE_FORMAT_NAME)) == null) {
            formatName = DEFAULT_IMAGE_FORMAT_NAME;
        }
        if ((outputDir = props.getProperty(PROPERTY_IMAGE_OUTPUT_DIR)) == null) {
            throw new RuntimeException("Output directory not specified: imageOutputDirectory");
        }
        String imageFilePrefix = props.getProperty(PROPERTY_IMAGE_FILE_PREFIX);
        if (imageFilePrefix == null) {
            imageFilePrefix = "";
        }
        if ((imageFileSuffix = props.getProperty(PROPERTY_IMAGE_FILE_SUFFIX)) == null) {
            imageFileSuffix = "";
        }
        boolean overwriteFiles = false;
        String strOverwriteFiles = props.getProperty(PROPERTY_OVERWRITE_FILES);
        if (strOverwriteFiles != null && strOverwriteFiles.length() > 0) {
            overwriteFiles = "true".equalsIgnoreCase(strOverwriteFiles);
        }
        this.imageFormatName = formatName;
        this.imageOutputDirectory = new File(outputDir);
        this.imageOutputFilePrefix = imageFilePrefix;
        this.imageOutputFileSuffix = imageFileSuffix;
        this.overwriteExistingFiles = overwriteFiles;
        this.nextImageIndex = 0L;
        this.maxFramesTenPower = tenPower;
    }

    @Override
    public synchronized void appendImage(RenderedImage image) throws Exception {
        boolean done;
        long imageIndex;
        long tenPower = this.maxFramesTenPower;
        String imageIndexString = (imageIndex = this.nextImageIndex++) < tenPower ? String.valueOf(tenPower + imageIndex).substring(1) : String.valueOf(imageIndex);
        String imageOutputFileName = this.imageOutputFilePrefix + imageIndexString + this.imageOutputFileSuffix;
        File targetFile = new File(this.imageOutputDirectory, imageOutputFileName);
        if (!this.overwriteExistingFiles && targetFile.exists()) {
            throw new IOException("Target file already exists: " + targetFile);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Writing image file: #" + imageIndex + ", format=" + this.imageFormatName + ", targetFile=" + targetFile);
        }
        if (!(done = ImageIO.write(image, this.imageFormatName, targetFile))) {
            String msg = "Failed to generate image file: #" + imageIndex + ", format=" + this.imageFormatName + ", targetFile=" + targetFile;
            throw new IOException(msg);
        }
    }

    @Override
    public synchronized void finish() throws Exception {
        this.imageFormatName = null;
        this.imageOutputDirectory = null;
        this.imageOutputFilePrefix = null;
        this.imageOutputFileSuffix = null;
        this.overwriteExistingFiles = false;
        this.nextImageIndex = 0L;
    }

    @Override
    public synchronized void close() throws Exception {
        this.finish();
    }
}

