/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.image;

import com.spacekiller.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ImageMovieProducerPanel
extends JPanel {
    private static final long serialVersionUID = 26942581596622800L;
    protected static final String DEFAULT_FILE_NAME_PREFIX = "ImageMovie";
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField jTextFieldFilePrefix = null;
    private JTextField jTextFieldOutputDir = null;
    private JLabel jLabel3 = null;
    private JComboBox jComboBoxImageFormat = null;
    private JCheckBox jCheckBoxOverwrite = null;
    private JButton jButtonBrowse = null;
    private JPanel panel_1;

    public ImageMovieProducerPanel() {
        this.initialize();
        this.initImageMovieProducerPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(572, 433));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 0, 0);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.add((Component)this.getPanel_1(), gbc_panel_1);
    }

    private JTextField getJTextFieldFilePrefix() {
        if (this.jTextFieldFilePrefix == null) {
            this.jTextFieldFilePrefix = new JTextField();
            this.jTextFieldFilePrefix.setOpaque(false);
        }
        return this.jTextFieldFilePrefix;
    }

    private JTextField getJTextFieldOutputDir() {
        if (this.jTextFieldOutputDir == null) {
            this.jTextFieldOutputDir = new JTextField();
            this.jTextFieldOutputDir.setOpaque(false);
        }
        return this.jTextFieldOutputDir;
    }

    private JComboBox getJComboBoxImageFormat() {
        if (this.jComboBoxImageFormat == null) {
            this.jComboBoxImageFormat = new JComboBox();
            this.jComboBoxImageFormat.setToolTipText("Image file format");
            this.jComboBoxImageFormat.setOpaque(false);
        }
        return this.jComboBoxImageFormat;
    }

    private JCheckBox getJCheckBoxOverwrite() {
        if (this.jCheckBoxOverwrite == null) {
            this.jCheckBoxOverwrite = new JCheckBox();
            this.jCheckBoxOverwrite.setOpaque(false);
            this.jCheckBoxOverwrite.setText("Overwrite existing files");
        }
        return this.jCheckBoxOverwrite;
    }

    private JButton getJButtonBrowse() {
        if (this.jButtonBrowse == null) {
            this.jButtonBrowse = new JButton();
            this.jButtonBrowse.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/movie/icons/movie_browse_icon16.gif")));
            this.jButtonBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageMovieProducerPanel.this.actionBrowseTargetDir();
                }
            });
        }
        return this.jButtonBrowse;
    }

    protected void initImageMovieProducerPanel() {
        this.getJTextFieldOutputDir().setColumns(30);
    }

    public String getTargetDir() {
        return this.jTextFieldOutputDir.getText();
    }

    protected void actionBrowseTargetDir() {
        int rc;
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setDialogTitle("Select Target Directory");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(1);
        String s = this.getTargetDir();
        if (s != null && s.length() > 0) {
            fc.setCurrentDirectory(new File(s));
        }
        if ((rc = fc.showDialog(this, "Select")) != 0) {
            return;
        }
        File dir = fc.getSelectedFile();
        if (dir != null) {
            this.getJTextFieldOutputDir().setText(dir.getPath());
        }
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Image Movie Producer", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0, 0.0};
            gbl_panel_1.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            this.jLabel3 = new JLabel();
            GridBagConstraints gbc_jLabel3 = new GridBagConstraints();
            gbc_jLabel3.anchor = 17;
            gbc_jLabel3.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel3.gridx = 0;
            gbc_jLabel3.gridy = 1;
            this.panel_1.add((Component)this.jLabel3, gbc_jLabel3);
            this.jLabel3.setText("Image Format:");
            GridBagConstraints gbc_jComboBoxImageFormat = new GridBagConstraints();
            gbc_jComboBoxImageFormat.anchor = 17;
            gbc_jComboBoxImageFormat.insets = new Insets(4, 4, 5, 5);
            gbc_jComboBoxImageFormat.gridx = 1;
            gbc_jComboBoxImageFormat.gridy = 1;
            this.panel_1.add((Component)this.getJComboBoxImageFormat(), gbc_jComboBoxImageFormat);
            this.jLabel = new JLabel();
            GridBagConstraints gbc_jLabel = new GridBagConstraints();
            gbc_jLabel.anchor = 17;
            gbc_jLabel.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel.gridx = 0;
            gbc_jLabel.gridy = 2;
            this.panel_1.add((Component)this.jLabel, gbc_jLabel);
            this.jLabel.setText("Output Directory:");
            GridBagConstraints gbc_jTextFieldOutputDir = new GridBagConstraints();
            gbc_jTextFieldOutputDir.insets = new Insets(4, 4, 5, 5);
            gbc_jTextFieldOutputDir.weightx = 1.0;
            gbc_jTextFieldOutputDir.fill = 1;
            gbc_jTextFieldOutputDir.gridx = 1;
            gbc_jTextFieldOutputDir.gridy = 2;
            this.panel_1.add((Component)this.getJTextFieldOutputDir(), gbc_jTextFieldOutputDir);
            GridBagConstraints gbc_jButtonBrowse = new GridBagConstraints();
            gbc_jButtonBrowse.insets = new Insets(4, 0, 5, 0);
            gbc_jButtonBrowse.gridx = 2;
            gbc_jButtonBrowse.gridy = 2;
            this.panel_1.add((Component)this.getJButtonBrowse(), gbc_jButtonBrowse);
            this.jLabel1 = new JLabel();
            GridBagConstraints gbc_jLabel1 = new GridBagConstraints();
            gbc_jLabel1.anchor = 17;
            gbc_jLabel1.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel1.gridx = 0;
            gbc_jLabel1.gridy = 3;
            this.panel_1.add((Component)this.jLabel1, gbc_jLabel1);
            this.jLabel1.setText("File Name Prefix:");
            GridBagConstraints gbc_jTextFieldFilePrefix = new GridBagConstraints();
            gbc_jTextFieldFilePrefix.gridwidth = 2;
            gbc_jTextFieldFilePrefix.fill = 1;
            gbc_jTextFieldFilePrefix.insets = new Insets(4, 4, 5, 0);
            gbc_jTextFieldFilePrefix.gridx = 1;
            gbc_jTextFieldFilePrefix.gridy = 3;
            this.panel_1.add((Component)this.getJTextFieldFilePrefix(), gbc_jTextFieldFilePrefix);
            GridBagConstraints gbc_jCheckBoxOverwrite = new GridBagConstraints();
            gbc_jCheckBoxOverwrite.anchor = 17;
            gbc_jCheckBoxOverwrite.gridwidth = 2;
            gbc_jCheckBoxOverwrite.insets = new Insets(4, 0, 4, 5);
            gbc_jCheckBoxOverwrite.gridx = 0;
            gbc_jCheckBoxOverwrite.gridy = 4;
            this.panel_1.add((Component)this.getJCheckBoxOverwrite(), gbc_jCheckBoxOverwrite);
        }
        return this.panel_1;
    }

    public Properties getProperties() {
        Object item = this.getJComboBoxImageFormat().getSelectedItem();
        String formatName = String.valueOf(item);
        String outputDir = this.getTargetDir();
        String filePrefix = this.getJTextFieldFilePrefix().getText();
        String fileSuffix = "." + formatName.toLowerCase();
        boolean overwriteFiles = this.getJCheckBoxOverwrite().isSelected();
        Properties props = new Properties();
        props.setProperty("imageFormatName", formatName);
        props.setProperty("imageOutputDirectory", outputDir);
        props.setProperty("imageOutputFilePrefix", filePrefix);
        props.setProperty("imageOutputFileSuffix", fileSuffix);
        props.setProperty("overwriteExistingFiles", String.valueOf(overwriteFiles));
        return props;
    }

    public void setProperties(Properties properties) {
        String outputDir;
        String formatName;
        Properties props = properties;
        if (props == null) {
            props = new Properties();
        }
        if ((formatName = props.getProperty("imageFormatName")) == null) {
            formatName = "png";
        }
        String[] formats = ImageIO.getWriterFormatNames();
        this.getJComboBoxImageFormat().removeAllItems();
        int sel = -1;
        for (int i = 0; i < formats.length; ++i) {
            this.getJComboBoxImageFormat().addItem(formats[i]);
            if (sel >= 0 || !formatName.equals(formats[i])) continue;
            sel = i;
        }
        if (sel >= 0) {
            this.getJComboBoxImageFormat().setSelectedIndex(sel);
        }
        if ((outputDir = props.getProperty("imageOutputDirectory")) == null) {
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                outputDir = dataDir.getPath();
            }
            if (outputDir == null) {
                outputDir = "";
            }
        }
        this.getJTextFieldOutputDir().setText(outputDir);
        String filePrefix = props.getProperty("imageOutputFilePrefix");
        if (filePrefix == null) {
            filePrefix = DEFAULT_FILE_NAME_PREFIX;
        }
        this.getJTextFieldFilePrefix().setText(filePrefix);
        boolean overwriteFiles = false;
        String strOverwriteFiles = props.getProperty("overwriteExistingFiles");
        if (strOverwriteFiles != null) {
            overwriteFiles = "true".equalsIgnoreCase(strOverwriteFiles);
        }
        this.getJCheckBoxOverwrite().setSelected(overwriteFiles);
    }
}

