/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.plugin;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.movie.MovieProducerType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MoviePlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(MoviePlugin.class.getName());
    public static final String MOVIE_PLUGIN_ID = "com.spacekiller.util.movie.plugin";
    public static final String POINT_MOVIE_PRODUCER_TYPE = "com.spacekiller.util.movie.MovieProducerType";
    private List movieProducerTypes = new ArrayList();

    public static MoviePlugin getInstance() throws Exception {
        return (MoviePlugin)Platform.getInstance().getPlugin(MOVIE_PLUGIN_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        super.startup();
        try {
            Iterator movieProducerTypeIter = Platform.getInstance().getServices(MovieProducerType.class);
            while (movieProducerTypeIter.hasNext()) {
                try {
                    Object obj = movieProducerTypeIter.next();
                    if (obj == null || !(obj instanceof MovieProducerType)) continue;
                    MovieProducerType movieProducerType = (MovieProducerType)obj;
                    List list = this.movieProducerTypes;
                    synchronized (list) {
                        this.movieProducerTypes.add(movieProducerType);
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("MovieProducerType: " + movieProducerType);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void shutdown() {
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        super.extensionAvailable(point, x);
        String pointId = point.getId();
        if (POINT_MOVIE_PRODUCER_TYPE.equals(pointId)) {
            block8: {
                try {
                    Object obj = this.getExtensionInstance(x);
                    if (obj instanceof MovieProducerType) {
                        MovieProducerType movieProducerType = (MovieProducerType)obj;
                        List list = this.movieProducerTypes;
                        synchronized (list) {
                            this.movieProducerTypes.add(movieProducerType);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("MovieProducerType: " + movieProducerType);
                        }
                        break block8;
                    }
                    logger.warning("Invalid MovieProducerType class: " + obj.getClass().getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return;
        }
        logger.info("extensionAvailable: " + x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MovieProducerType[] getMovieProducerTypes() {
        List list = this.movieProducerTypes;
        synchronized (list) {
            return this.movieProducerTypes.toArray(new MovieProducerType[this.movieProducerTypes.size()]);
        }
    }
}

