/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.plugin;

import com.spacekiller.util.movie.MovieProducerType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MovieProducerTypeChooser
extends JPanel {
    private static final long serialVersionUID = 5583297309608624808L;
    private MovieProducerType[] movieProducerTypes;
    private MovieProducerType movieProducerType;
    private EventListenerList changeListeners = new EventListenerList();
    private boolean refreshing;
    private JComboBox comboBoxMovieProducerType;

    public MovieProducerTypeChooser() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.comboBoxMovieProducerType = new JComboBox();
        this.comboBoxMovieProducerType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MovieProducerTypeChooser.this.refreshing) {
                    MovieProducerTypeChooser.this.apply();
                }
            }
        });
        this.comboBoxMovieProducerType.setToolTipText("Movie producer type");
        GridBagConstraints gbc_comboBoxMovieProducerType = new GridBagConstraints();
        gbc_comboBoxMovieProducerType.weightx = 1.0;
        gbc_comboBoxMovieProducerType.fill = 1;
        gbc_comboBoxMovieProducerType.gridx = 0;
        gbc_comboBoxMovieProducerType.gridy = 0;
        this.add((Component)this.comboBoxMovieProducerType, gbc_comboBoxMovieProducerType);
    }

    protected JComboBox getComboBoxMovieProducerType() {
        return this.comboBoxMovieProducerType;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged(ChangeEvent ev) {
        Object[] l = this.changeListeners.getListenerList();
        int n = l.length;
        for (int k = 1; k < n; k += 2) {
            ((ChangeListener)l[k]).stateChanged(ev);
        }
    }

    public MovieProducerType[] getMovieProducerTypes() {
        return this.movieProducerTypes;
    }

    public void setMovieProducerTypes(MovieProducerType[] movieProducerTypes) {
        this.movieProducerTypes = movieProducerTypes;
        this.refresh();
    }

    public MovieProducerType getMovieProducerType() {
        return this.movieProducerType;
    }

    public void setMovieProducerType(MovieProducerType movieProducerType) {
        this.movieProducerType = movieProducerType;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            MovieProducerType[] movieProducerTypes = this.getMovieProducerTypes();
            MovieProducerType movieProducerType = this.getMovieProducerType();
            this.comboBoxMovieProducerType.removeAllItems();
            int sel = -1;
            int num = movieProducerTypes == null ? 0 : movieProducerTypes.length;
            for (int i = 0; i < num; ++i) {
                MovieProducerType type = movieProducerTypes[i];
                String typeName = String.valueOf(type.getName());
                this.comboBoxMovieProducerType.addItem(typeName);
                if (type != movieProducerType) continue;
                sel = i;
            }
            if (sel >= 0) {
                this.comboBoxMovieProducerType.setSelectedIndex(sel);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        int index = this.comboBoxMovieProducerType.getSelectedIndex();
        MovieProducerType oldType = this.getMovieProducerType();
        MovieProducerType newType = null;
        MovieProducerType[] movieProducerTypes = this.getMovieProducerTypes();
        if (index >= 0 && movieProducerTypes != null && index < movieProducerTypes.length) {
            newType = movieProducerTypes[index];
        }
        if (newType == oldType) {
            return;
        }
        this.movieProducerType = newType;
        this.fireStateChanged(new ChangeEvent(this));
    }
}

