/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.spacekiller.util.Clock;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioContext;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AbstractAudioEngine;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.SourceBufferProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import com.waxmonster.audio.impl.WrapperPort;
import com.waxmonster.audio.jnajack.JackAudioInputPort;
import com.waxmonster.audio.jnajack.JackAudioOutputPort;
import com.waxmonster.audio.jnajack.JackAudioSupport;
import com.waxmonster.audio.jnajack.JackAudioSyncGroup;
import com.waxmonster.audio.jnajack.JackDevice;
import com.waxmonster.audio.jnajack.JackPortReader;
import com.waxmonster.audio.jnajack.JackPortWriter;
import com.waxmonster.audio.jnajack.JackProcessor;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackStatus;

public class JackAudioEngine
extends AbstractAudioEngine {
    private static final Logger logger = Logger.getLogger(JackAudioEngine.class.getName());
    private final Clock clock;
    private JackAudioSupport jackAudioSupport;
    private JackAudioSyncGroup jackSyncGroup;
    private AudioContextImpl audioContext;
    private Jack jack;
    private JackClient jackClient;
    private JackProcessor jackProcessor;
    private float frameRate;
    private int bufferSize;
    private Wrapper syncGroupWrapper;
    private List<JackSourceInfo> jackSourceList;
    private List<JackTargetInfo> jackTargetList;

    public JackAudioEngine(AudioEngineConfig config, Clock clock) {
        super(config);
        this.clock = clock;
    }

    public void prepare(AudioSyncGroup group, AudioContext context) throws AudioException {
        AudioContextImpl syncGroupContext = this.getAudioContextImpl(context);
        if (group == null || !(group instanceof JackAudioSyncGroup)) {
            throw new AudioException("Invalid AudioSyncGroup: " + group);
        }
        JackAudioSyncGroup jackGroup = (JackAudioSyncGroup)group;
        JackAudioSupport jackSupport = jackGroup.getJackAudioSupport();
        this.prepareJackClient(jackSupport, syncGroupContext);
    }

    public void start() throws AudioException {
        this.startJackClient();
    }

    final void activateJackAudioDevice(JackDevice device) throws StudioException {
        AudioContextImpl syncGroupContext;
        Studio studio = device.getStudio();
        if (studio == null) {
            throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
        }
        JackAudioSupport jackSupport = device.getJackAudioSupport();
        boolean prepared = this.prepareJackClient(jackSupport, syncGroupContext = this.createAudioContextImpl(studio));
        if (prepared) {
            this.startJackClient();
        }
    }

    final void deactivateJackAudioDevice(JackDevice device) throws StudioException {
        JackAudioSupport support = device.getJackAudioSupport();
        if (support == null) {
            return;
        }
        this.deactivateJackClient(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareJackClient(JackAudioSupport support, AudioContextImpl syncGroupContext) throws AudioException {
        JackAudioSyncGroup syncGroup;
        JackAudioEngine jackAudioEngine = this;
        synchronized (jackAudioEngine) {
            if (this.jackAudioSupport == support) {
                return false;
            }
            syncGroup = support.getJackAudioSyncGroup();
            if (syncGroup == null) {
                throw new AudioException("No JackAudioSyncGroup available: " + (Object)((Object)support));
            }
            if (this.jackSyncGroup == syncGroup) {
                return false;
            }
            if (this.jackAudioSupport != null) {
                throw new AudioException("JackAudioEngine is already activated: " + (Object)((Object)this));
            }
            JackAudioEngine engine = syncGroup.getJackAudioEngine();
            if (engine != this) {
                throw new AudioException("Invalid JackAudioEngine: " + (Object)((Object)engine) + " != " + (Object)((Object)this));
            }
            this.jackAudioSupport = support;
            this.jackSyncGroup = syncGroup;
            this.audioContext = syncGroupContext;
        }
        boolean success = false;
        try {
            int i;
            int sourceCount = syncGroup.getOutputPortCount();
            this.jackSourceList = new ArrayList<JackSourceInfo>(sourceCount);
            HashMap<JackAudioOutputPort, JackSourceInfo> jackSourceMap = new HashMap<JackAudioOutputPort, JackSourceInfo>();
            for (int i2 = 0; i2 < sourceCount; ++i2) {
                AudioOutputPort port = syncGroup.getOutputPortAt(i2);
                if (!(port instanceof JackAudioOutputPort)) continue;
                JackAudioOutputPort jackPort = (JackAudioOutputPort)port;
                LinkedList<AudioInputPort> targetPortList = new LinkedList<AudioInputPort>();
                LinkedList<AudioSyncGroup> targetGroupList = new LinkedList<AudioSyncGroup>();
                Connection[] conns = jackPort.getConnections();
                for (int k = 0; k < conns.length; ++k) {
                    Port partner = conns[k].getPartner((Port)jackPort);
                    if (partner == null) continue;
                    if (partner instanceof AudioInputPort) {
                        AudioSyncGroup destGroup;
                        AudioSupport destSupport;
                        AudioInputPort destPort = (AudioInputPort)partner;
                        Device device = destPort.getDevice();
                        if (!device.isEnabled() || (destSupport = destPort.getAudioSupport()) == null || (destGroup = destSupport.getAudioSyncGroup((AudioPort)destPort)) == null) continue;
                        targetPortList.add(destPort);
                        targetGroupList.add(destGroup);
                        continue;
                    }
                    throw new StudioException("Unsupported partner port: " + partner);
                }
                if (targetPortList.isEmpty()) continue;
                AudioInputPort[] targetPorts = targetPortList.toArray(new AudioInputPort[targetPortList.size()]);
                AudioSyncGroup[] targetGroups = targetGroupList.toArray(new AudioSyncGroup[targetGroupList.size()]);
                JackSourceInfo jackSourceInfo = new JackSourceInfo(jackPort, i2, targetPorts, targetGroups);
                this.jackSourceList.add(jackSourceInfo);
                jackSourceMap.put(jackPort, jackSourceInfo);
            }
            int destCount = syncGroup.getInputPortCount();
            this.jackTargetList = new ArrayList<JackTargetInfo>(destCount);
            HashMap<JackAudioInputPort, JackTargetInfo> jackTargetMap = new HashMap<JackAudioInputPort, JackTargetInfo>();
            for (i = 0; i < destCount; ++i) {
                AudioSyncGroup sourceGroup;
                AudioSupport sourceSupport;
                Device sourceDevice;
                AudioInputPort port = syncGroup.getInputPortAt(i);
                if (!(port instanceof JackAudioInputPort)) continue;
                JackAudioInputPort jackPort = (JackAudioInputPort)port;
                AudioOutputPort sourcePort = port.getSourcePort();
                if (sourcePort == null || !(sourceDevice = sourcePort.getDevice()).isEnabled() || (sourceSupport = sourcePort.getAudioSupport()) == null || (sourceGroup = sourceSupport.getAudioSyncGroup((AudioPort)sourcePort)) == null) continue;
                JackTargetInfo jackTargetInfo = new JackTargetInfo(sourcePort, sourceGroup, jackPort, i);
                this.jackTargetList.add(jackTargetInfo);
                jackTargetMap.put(jackPort, jackTargetInfo);
            }
            if (this.jackSourceList.isEmpty() && this.jackTargetList.isEmpty()) {
                success = true;
                i = 0;
                return i != 0;
            }
            this.jack = Jack.getInstance();
            String jackClientName = "waxmonster";
            EnumSet<JackOptions> jackOptions = EnumSet.of(JackOptions.JackNullOption);
            EnumSet<JackStatus> jackStatus = EnumSet.noneOf(JackStatus.class);
            this.jackClient = this.jack.openClient(jackClientName, jackOptions, jackStatus);
            float rate = this.jackClient.getSampleRate();
            int bufSize = this.jackClient.getBufferSize();
            Wrapper wrapper = syncGroupContext.getGroupWrapper((AudioSyncGroup)syncGroup);
            wrapper.setFrameRate(rate);
            wrapper.setBufferSize(bufSize);
            this.syncGroupWrapper = wrapper;
            this.frameRate = rate;
            this.bufferSize = bufSize;
            for (JackSourceInfo jackSourceInfo : this.jackSourceList) {
                int mono = 1;
                FloatArraySampleBuffer sb = new FloatArraySampleBuffer(mono, bufSize, rate, new float[bufSize]);
                WrapperOutputPort outputPort = wrapper.getOutputPortAt(jackSourceInfo.sourcePortIndex);
                SampleBufferProxy bufferProxy = new SampleBufferProxy((WrapperPort)outputPort, (SampleBuffer)sb);
                outputPort.setSampleBufferProxy(bufferProxy);
                jackSourceInfo.sampleBuffer = sb;
                String jackPortName = "input_" + String.valueOf(1 + jackSourceInfo.sourcePortIndex);
                jackSourceInfo.jackPort = this.jackClient.registerPort(jackPortName, JackPortType.AUDIO, JackPortFlags.JackPortIsInput);
            }
            for (JackTargetInfo jackTargetInfo : this.jackTargetList) {
                WrapperInputPort inputPort = wrapper.getInputPortAt(jackTargetInfo.targetPortIndex);
                WrapperOutputPort sourcePort = inputPort.getSourcePort();
                SourceBufferProxy bufferProxy = new SourceBufferProxy(inputPort, sourcePort);
                inputPort.setSampleBufferProxy((SampleBufferProxy)bufferProxy);
                String jackPortName = "output_" + String.valueOf(1 + jackTargetInfo.targetPortIndex);
                jackTargetInfo.jackPort = this.jackClient.registerPort(jackPortName, JackPortType.AUDIO, JackPortFlags.JackPortIsOutput);
            }
            this.prepareAudioSyncGroup(this.jackSyncGroup, syncGroupContext);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jack audio engine prepared: " + (Object)((Object)this));
            }
            boolean bl = true;
            return bl;
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateJackClient(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startJackClient() throws AudioException {
        JackAudioSupport support;
        JackAudioEngine jackAudioEngine = this;
        synchronized (jackAudioEngine) {
            support = this.jackAudioSupport;
            if (support == null) {
                throw new AudioException("JackAudioEngine is not prepared: " + (Object)((Object)this));
            }
        }
        boolean success = false;
        try {
            if (this.syncGroupWrapper.isStarted()) {
                throw new AudioException("JackAudioEngine is already started: " + (Object)((Object)this));
            }
            ArrayList<AudioProcessor> jackReaderList = new ArrayList<AudioProcessor>(this.jackSourceList.size());
            for (JackSourceInfo info : this.jackSourceList) {
                JackPort src = info.jackPort;
                SampleBuffer dst = info.sampleBuffer;
                JackPortReader jackReader = new JackPortReader(src, dst);
                jackReaderList.add(jackReader);
            }
            AudioProcessor[] postProcessors = this.syncGroupWrapper.createPostProcessors();
            for (int i = 0; i < postProcessors.length; ++i) {
                jackReaderList.add(postProcessors[i]);
            }
            AudioProcessor[] contextProcessors = this.createAudioProcessors(this.audioContext);
            ArrayList<AudioProcessor> jackWriterList = new ArrayList<AudioProcessor>(this.jackTargetList.size());
            AudioProcessor[] preProcessors = this.syncGroupWrapper.createPreProcessors();
            for (int i = 0; i < preProcessors.length; ++i) {
                jackWriterList.add(preProcessors[i]);
            }
            for (JackTargetInfo info : this.jackTargetList) {
                JackPort dst = info.jackPort;
                WrapperInputPort inputPort = this.syncGroupWrapper.getInputPortAt(info.targetPortIndex);
                SampleBufferProxy bufferProxy = inputPort.getSampleBufferProxy();
                if (bufferProxy == null) {
                    throw new AudioException("SampleBufferProxy not available for port: " + inputPort.getAudioInputPort());
                }
                SampleBuffer src = bufferProxy.getSampleBuffer();
                JackPortWriter jackWriter = new JackPortWriter(src, dst);
                if (jackWriter == null) continue;
                jackWriterList.add(jackWriter);
            }
            ArrayList<AudioProcessor> apList = new ArrayList<AudioProcessor>(jackReaderList.size() + contextProcessors.length + jackWriterList.size());
            apList.addAll(jackReaderList);
            for (AudioProcessor cp : contextProcessors) {
                apList.add(cp);
            }
            apList.addAll(jackWriterList);
            AudioProcessor[] audioProcessors = apList.toArray(new AudioProcessor[apList.size()]);
            this.jackProcessor = new JackProcessor(this.clock);
            this.jackProcessor.resetAudioProcessors(this.bufferSize, this.frameRate, audioProcessors);
            this.jackClient.setProcessCallback((JackProcessCallback)this.jackProcessor);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Activating Jack client: " + this.jackClient);
            }
            this.jackClient.activate();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jack client activated: " + this.jackClient);
            }
            for (JackSourceInfo info : this.jackSourceList) {
                JackAudioOutputPort jackSourcePort = info.sourcePort;
                String jackSourcePortName = jackSourcePort.getJackPortName();
                String jackDestPortName = info.jackPort.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Connecting Jack port: " + jackSourcePortName + " => " + jackDestPortName);
                }
                this.jack.connect(this.jackClient, jackSourcePortName, jackDestPortName);
            }
            for (JackTargetInfo info : this.jackTargetList) {
                JackAudioInputPort jackDestPort = info.targetPort;
                String jackDestPortName = jackDestPort.getJackPortName();
                String jackSourcePortName = info.jackPort.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Connecting Jack port: " + jackSourcePortName + " => " + jackDestPortName);
                }
                this.jack.connect(this.jackClient, jackSourcePortName, jackDestPortName);
            }
            this.syncGroupWrapper.setStarted(true);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jack client started: " + this.jackClient);
            }
            this.startAudioEngines(this.audioContext);
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException(e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateJackClient(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateJackClient(JackAudioSupport support) throws AudioException {
        JackProcessor handler;
        JackClient client;
        JackAudioEngine jackAudioEngine = this;
        synchronized (jackAudioEngine) {
            client = this.jackClient;
            if (client == null && this.jackSyncGroup == null && this.jackAudioSupport == null) {
                return;
            }
            if (support != this.jackAudioSupport) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Ignored invalid JackAudioSupport: " + (Object)((Object)support) + " != " + (Object)((Object)this.jackAudioSupport));
                }
                return;
            }
        }
        if (client != null) {
            String clientInfo = client.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deactivating Jack client: " + clientInfo);
            }
            client.deactivate();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jack client deactivated: " + clientInfo);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Closing Jack client: " + clientInfo);
            }
            client.close();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jack client closed: " + clientInfo);
            }
        }
        if ((handler = this.jackProcessor) != null) {
            handler.shutdownAudioProcessors();
        }
        JackAudioEngine jackAudioEngine2 = this;
        synchronized (jackAudioEngine2) {
            this.jack = null;
            this.jackClient = null;
            this.audioContext = null;
            this.jackSyncGroup = null;
            this.jackAudioSupport = null;
        }
        if (support != null) {
            support.reset();
        }
    }

    protected class JackTargetInfo {
        protected final AudioOutputPort sourcePort;
        protected final AudioSyncGroup sourceGroup;
        protected final JackAudioInputPort targetPort;
        protected final int targetPortIndex;
        protected JackPort jackPort;

        public JackTargetInfo(AudioOutputPort sourcePort, AudioSyncGroup sourceGroup, JackAudioInputPort targetPort, int targetPortIndex) {
            this.sourcePort = sourcePort;
            this.sourceGroup = sourceGroup;
            this.targetPort = targetPort;
            this.targetPortIndex = targetPortIndex;
        }
    }

    protected class JackSourceInfo {
        protected final JackAudioOutputPort sourcePort;
        protected final int sourcePortIndex;
        protected final AudioInputPort[] targetPorts;
        protected final AudioSyncGroup[] targetGroups;
        protected JackPort jackPort;
        protected SampleBuffer sampleBuffer;

        public JackSourceInfo(JackAudioOutputPort sourcePort, int sourcePortIndex, AudioInputPort[] targetPorts, AudioSyncGroup[] targetGroups) {
            this.sourcePort = sourcePort;
            this.sourcePortIndex = sourcePortIndex;
            this.targetPorts = targetPorts;
            this.targetGroups = targetGroups;
        }
    }
}

