/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.spacekiller.util.Clock;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jnajack.JackAudioEngine;
import com.waxmonster.audio.jnajack.JackAudioInputPort;
import com.waxmonster.audio.jnajack.JackAudioOutputPort;
import com.waxmonster.audio.jnajack.JackAudioSyncGroup;
import com.waxmonster.audio.jnajack.JackDevice;
import com.waxmonster.studio.Studio;
import java.util.LinkedList;

public class JackAudioSupport
extends AudioSupport {
    private final JackDevice jackDevice;
    private AudioEngineConfig config;
    private JackAudioSyncGroup syncGroup;

    public JackAudioSupport(JackDevice jackDevice, AudioEngineConfig config) {
        this.jackDevice = jackDevice;
        this.config = config;
    }

    public final JackDevice getJackDevice() {
        return this.jackDevice;
    }

    public synchronized void reset() {
        if (this.syncGroup != null) {
            this.syncGroup = null;
        }
    }

    public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
        return this.getJackAudioSyncGroup();
    }

    public synchronized JackAudioSyncGroup getJackAudioSyncGroup() {
        if (this.syncGroup != null) {
            return this.syncGroup;
        }
        JackDevice jackDev = this.jackDevice;
        if (jackDev == null) {
            return null;
        }
        Studio studio = jackDev.getStudio();
        if (studio == null) {
            return null;
        }
        JackDevice sourceDevice = jackDev;
        JackDevice targetDevice = jackDev;
        LinkedList<JackAudioOutputPort> outputPortList = new LinkedList<JackAudioOutputPort>();
        if (sourceDevice != null) {
            AudioPort[] ports;
            for (AudioPort p : ports = sourceDevice.getAudioPorts()) {
                if (p == null || !(p instanceof JackAudioOutputPort)) continue;
                outputPortList.add((JackAudioOutputPort)p);
            }
        }
        LinkedList<JackAudioInputPort> inputPortList = new LinkedList<JackAudioInputPort>();
        if (targetDevice != null) {
            AudioPort[] ports;
            for (AudioPort p : ports = targetDevice.getAudioPorts()) {
                if (p == null || !(p instanceof JackAudioInputPort)) continue;
                inputPortList.add((JackAudioInputPort)p);
            }
        }
        AudioOutputPort[] outputPorts = outputPortList.toArray(new AudioOutputPort[outputPortList.size()]);
        AudioInputPort[] inputPorts = inputPortList.toArray(new AudioInputPort[inputPortList.size()]);
        Clock clock = studio.getClock();
        JackAudioEngine engine = new JackAudioEngine(this.config, clock);
        String name = jackDev.getName();
        this.syncGroup = new JackAudioSyncGroup(name, inputPorts, outputPorts, engine, this);
        return this.syncGroup;
    }
}

