/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.device.AudioDevice;
import com.waxmonster.audio.jnajack.JackAudioInputPort;
import com.waxmonster.audio.jnajack.JackAudioOutputPort;
import com.waxmonster.audio.jnajack.JackAudioSupport;
import com.waxmonster.audio.jnajack.JackDeviceInfo;
import com.waxmonster.audio.jnajack.JackDevicePanel;
import com.waxmonster.audio.jnajack.JackDeviceProvider;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.EnumSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackStatus;

public class JackDevice
extends AudioDevice {
    private static final Logger logger = Logger.getLogger(JackDevice.class.getName());
    private final JackDeviceProvider provider;
    private final JackDeviceInfo info;
    private JackDevicePanel jackDevicePanel;
    private String errorMessage;

    public JackDevice(JackDeviceProvider provider, String name, Icon iconColor16, JackDeviceInfo info) {
        super((DeviceProvider)provider, name);
        this.setIconColor16(iconColor16);
        this.provider = provider;
        this.info = info;
        this.refreshAudioPorts();
    }

    public final JackDeviceProvider getJackDeviceProvider() {
        return this.provider;
    }

    public final JackDeviceInfo getJackDeviceInfo() {
        return this.info;
    }

    public synchronized Component getCustomizer() {
        if (this.jackDevicePanel == null) {
            this.jackDevicePanel = new JackDevicePanel();
            this.jackDevicePanel.setOpaque(false);
            this.jackDevicePanel.setDevice(this);
        }
        return this.jackDevicePanel;
    }

    protected void activate() throws StudioException {
        this.provider.activate(this);
        this.refreshPanel();
    }

    protected void deactivate() throws StudioException {
        this.provider.deactivate(this);
        this.refreshPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPanel() {
        JackDevicePanel panel;
        JackDevice jackDevice = this;
        synchronized (jackDevice) {
            panel = this.jackDevicePanel;
            if (panel == null) {
                return;
            }
        }
        final JackDevicePanel panelFinal = panel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                panelFinal.refresh();
            }
        });
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        return props;
    }

    protected void applyProperty(String key, String value) {
    }

    protected void setSubtitle(String subtitle) {
        super.setSubtitle(subtitle);
    }

    final JackAudioSupport getJackAudioSupport() {
        AudioPort[] ports = this.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            AudioPort port = ports[i];
            if (port == null) continue;
            if (port instanceof JackAudioInputPort) {
                JackAudioInputPort jackPort = (JackAudioInputPort)port;
                return jackPort.getJackAudioSupport();
            }
            if (!(port instanceof JackAudioOutputPort)) continue;
            JackAudioOutputPort jackPort = (JackAudioOutputPort)port;
            return jackPort.getJackAudioSupport();
        }
        return null;
    }

    protected synchronized AudioPort[] getAudioPorts() {
        return super.getAudioPorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refreshAudioPorts() {
        AudioPort[] oldPorts;
        int jackTargetPortCount;
        int jackSourcePortCount;
        int totalPortCount;
        if (this.isActive()) {
            this.errorMessage = "Cannot refresh ports while device is active!";
            return;
        }
        this.errorMessage = null;
        Jack jack = null;
        try {
            jack = Jack.getInstance();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        JackClient jackClient = null;
        if (jack != null) {
            String jackClientName = null;
            if (jackClientName == null || jackClientName.length() < 1) {
                jackClientName = this.getTitle();
            }
            if (jackClientName == null || jackClientName.length() < 1) {
                jackClientName = this.getName();
            }
            if (jackClientName == null || jackClientName.length() < 1) {
                jackClientName = ((Object)((Object)this)).getClass().getName();
            }
            EnumSet<JackOptions> jackOptions = EnumSet.of(JackOptions.JackNullOption);
            EnumSet<JackStatus> jackStatus = EnumSet.noneOf(JackStatus.class);
            try {
                jackClient = jack.openClient(jackClientName, jackOptions, jackStatus);
            }
            catch (Throwable e) {
                this.errorMessage = "Failed to create Jack client: " + jackStatus;
                logger.severe(this.errorMessage);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        String[] jackSourcePortNames = null;
        String[] jackTargetPortNames = null;
        if (jackClient != null) {
            try {
                String regex = null;
                JackPortType portType = JackPortType.AUDIO;
                EnumSet<JackPortFlags> flags = EnumSet.of(JackPortFlags.JackPortIsOutput);
                jackSourcePortNames = jack.getPorts(jackClient, regex, portType, flags);
                regex = null;
                portType = JackPortType.AUDIO;
                flags = EnumSet.of(JackPortFlags.JackPortIsInput);
                jackTargetPortNames = jack.getPorts(jackClient, regex, portType, flags);
            }
            catch (Throwable e) {
                this.errorMessage = e.getMessage();
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                jackClient.close();
            }
        }
        if ((totalPortCount = (jackSourcePortCount = jackSourcePortNames == null ? 0 : jackSourcePortNames.length) + (jackTargetPortCount = jackTargetPortNames == null ? 0 : jackTargetPortNames.length)) == (oldPorts = this.getAudioPorts()).length) {
            boolean changed = false;
            for (int i = 0; i < totalPortCount; ++i) {
                Object jackPort;
                String jackPortName = i < jackSourcePortCount ? jackSourcePortNames[i] : jackTargetPortNames[i - jackSourcePortCount];
                AudioPort oldPort = oldPorts[i];
                if (jackPortName != null && oldPort != null && (oldPort instanceof JackAudioOutputPort && jackPortName.equals(((JackAudioOutputPort)((Object)(jackPort = (JackAudioOutputPort)oldPort))).getJackPortName()) || oldPort instanceof JackAudioInputPort && jackPortName.equals(((JackAudioInputPort)((Object)(jackPort = (JackAudioInputPort)oldPort))).getJackPortName()))) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        AudioPort[] newPorts = new AudioPort[totalPortCount];
        if (totalPortCount > 0) {
            String tooltip;
            String portName;
            int channelIndex;
            String jackPortName;
            JackAudioSupport audioSupport = new JackAudioSupport(this, this.provider.getConfig());
            int portIndex = 0;
            int i = 0;
            while (i < jackSourcePortCount) {
                jackPortName = jackSourcePortNames[i];
                channelIndex = i++;
                portName = "Channel-" + (channelIndex + 1);
                tooltip = portName + ": " + jackPortName;
                JackAudioOutputPort sourcePort = new JackAudioOutputPort(portName, audioSupport, jackPortName);
                sourcePort.setTooltip(tooltip);
                newPorts[portIndex++] = sourcePort;
            }
            i = 0;
            while (i < jackTargetPortCount) {
                jackPortName = jackTargetPortNames[i];
                channelIndex = i++;
                portName = "Channel-" + (channelIndex + 1);
                tooltip = portName + ": " + jackPortName;
                JackAudioInputPort targetPort = new JackAudioInputPort(portName, audioSupport, jackPortName);
                targetPort.setTooltip(tooltip);
                newPorts[portIndex++] = targetPort;
            }
        }
        this.setAudioPorts(newPorts);
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }
}

