/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.jnajack.JackDevice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JackDevicePanel
extends JPanel {
    private static final long serialVersionUID = 6364307886106177546L;
    private static final Logger logger = Logger.getLogger(JackDevicePanel.class.getName());
    private JackDevice device;
    private Icon iconJackReady;
    private Icon iconJackError;
    private JButton btnRefresh;
    private JLabel lblInfo;

    public JackDevicePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.btnRefresh = new JButton("");
        this.btnRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.btnRefresh.setToolTipText("Refresh Jack Ports");
        this.btnRefresh.setIcon(new ImageIcon(JackDevicePanel.class.getResource("/com/waxmonster/audio/jnajack/icons/refresh_jnajack.gif")));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JackDevicePanel.this.actionRefreshJackPorts();
            }
        });
        this.lblInfo = new JLabel("Info");
        this.lblInfo.setPreferredSize(new Dimension(200, 16));
        GridBagConstraints gbc_lblInfo = new GridBagConstraints();
        gbc_lblInfo.weightx = 1.0;
        gbc_lblInfo.fill = 2;
        gbc_lblInfo.insets = new Insets(4, 4, 4, 4);
        gbc_lblInfo.gridx = 0;
        gbc_lblInfo.gridy = 0;
        this.add((Component)this.lblInfo, gbc_lblInfo);
        GridBagConstraints gbc_btnRefresh = new GridBagConstraints();
        gbc_btnRefresh.insets = new Insets(4, 4, 4, 4);
        gbc_btnRefresh.gridx = 1;
        gbc_btnRefresh.gridy = 0;
        this.add((Component)this.btnRefresh, gbc_btnRefresh);
        this.initJackDevicePanel();
    }

    protected void initJackDevicePanel() {
        this.iconJackReady = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/audio/jnajack/icons/jnajack_ready.gif");
        this.iconJackError = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/audio/jnajack/icons/jnajack_error.gif");
    }

    public JackDevice getDevice() {
        return this.device;
    }

    public void setDevice(JackDevice device) {
        this.device = device;
        this.refresh();
    }

    protected synchronized void refresh() {
        String text = null;
        Icon icon = null;
        boolean active = false;
        JackDevice dev = this.device;
        if (dev != null) {
            active = dev.isActive();
            String error = dev.getErrorMessage();
            if (error != null) {
                text = error;
                icon = this.iconJackError;
            } else {
                text = active ? "Active" : "Idle";
                icon = this.iconJackReady;
            }
        }
        if (text == null) {
            text = "N/A";
        }
        this.lblInfo.setIcon(icon);
        this.lblInfo.setText(text);
        this.btnRefresh.setEnabled(!active);
    }

    protected void actionRefreshJackPorts() {
        final JackDevice dev = this.device;
        if (dev == null) {
            return;
        }
        this.btnRefresh.setEnabled(false);
        this.lblInfo.setIcon(this.btnRefresh.getIcon());
        this.lblInfo.setText("Refreshing Jack Port(s)...");
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    dev.refreshAudioPorts();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JackDevicePanel.this.btnRefresh.setEnabled(true);
                        JackDevicePanel.this.refresh();
                    }
                });
            }
        };
        new Thread(target).start();
    }

    protected JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    protected JLabel getLblInfo() {
        return this.lblInfo;
    }
}

