/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jnajack.JackAudioInputPort;
import com.waxmonster.audio.jnajack.JackAudioOutputPort;
import com.waxmonster.audio.jnajack.JackAudioSupport;
import com.waxmonster.audio.jnajack.JackAudioSyncGroup;
import com.waxmonster.audio.jnajack.JackDevice;
import com.waxmonster.audio.jnajack.JackDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class JackDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "JNAJackDeviceProvider";
    public static final String JACK_DEVICE_NAME = "JNAJack-Audio";
    public static final String DEVICE_CATEGORY_NAME = "Audio Devices";
    private static final Logger logger = Logger.getLogger(JackDeviceProvider.class.getName());
    private static final String CLASS_NAME = JackDeviceProvider.class.getName();
    private AudioEngineConfig config = new AudioEngineConfig();

    public JackDeviceProvider() {
        super(PROVIDER_NAME);
        this.initJackDeviceProvider();
    }

    protected void initJackDeviceProvider() {
        String tooltip = "JNA-Jack Client";
        Icon icon = Tools.getIcon(JackDeviceProvider.class, (String)"/com/waxmonster/audio/jnajack/icons/jack_audio_icon16.png");
        JackDeviceInfo sourceInfo = new JackDeviceInfo(JACK_DEVICE_NAME, tooltip, icon);
        this.addDeviceInfo(sourceInfo);
    }

    public void refreshDeviceInfo() {
    }

    public synchronized Device createDevice(DeviceInfo info) throws StudioException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createDevice", info);
        }
        if (info == null || !(info instanceof JackDeviceInfo)) {
            throw new StudioException("Invalid DeviceInfo: " + info);
        }
        JackDeviceInfo jackInfo = (JackDeviceInfo)info;
        String devName = jackInfo.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        JackDevice dev = new JackDevice(this, devName, iconColor16, jackInfo);
        String title = JACK_DEVICE_NAME;
        String subtitle = null;
        dev.setTitle(title);
        dev.setSubtitle(subtitle);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createDevice", (Object)dev);
        }
        return dev;
    }

    protected synchronized void activate(JackDevice device) throws StudioException {
        HashSet<JackAudioSyncGroup> groups = new HashSet<JackAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            JackAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof JackAudioInputPort) {
                JackAudioInputPort inputPort = (JackAudioInputPort)port;
                support = inputPort.getJackAudioSupport();
                groups.add(support.getJackAudioSyncGroup());
                continue;
            }
            if (!(port instanceof JackAudioOutputPort)) continue;
            JackAudioOutputPort outputPort = (JackAudioOutputPort)port;
            support = outputPort.getJackAudioSupport();
            groups.add(support.getJackAudioSyncGroup());
        }
        for (JackAudioSyncGroup group : groups) {
            group.getJackAudioEngine().activateJackAudioDevice(device);
        }
    }

    protected synchronized void deactivate(JackDevice device) throws StudioException {
        HashSet<JackAudioSyncGroup> groups = new HashSet<JackAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            JackAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof JackAudioInputPort) {
                JackAudioInputPort inputPort = (JackAudioInputPort)port;
                support = inputPort.getJackAudioSupport();
                groups.add(support.getJackAudioSyncGroup());
                continue;
            }
            if (!(port instanceof JackAudioOutputPort)) continue;
            JackAudioOutputPort outputPort = (JackAudioOutputPort)port;
            support = outputPort.getJackAudioSupport();
            groups.add(support.getJackAudioSyncGroup());
        }
        for (JackAudioSyncGroup group : groups) {
            group.getJackAudioEngine().deactivateJackAudioDevice(device);
        }
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }

    public AudioEngineConfig getConfig() {
        return this.config;
    }

    public void setConfig(AudioEngineConfig config) {
        this.config = config;
    }
}

