/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jnajack;

import com.spacekiller.util.Clock;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.studio.StudioException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackProcessCallback;

public class JackProcessor
implements JackProcessCallback {
    private static final Logger logger = Logger.getLogger(JackProcessor.class.getName());
    private final Clock ck;
    private AudioProcessor[] prs;

    protected JackProcessor(Clock clock) {
        this.ck = clock;
        this.prs = null;
    }

    public boolean process(JackClient c, int n) {
        try {
            long t = this.ck.nanos();
            AudioProcessor[] pr = this.prs;
            int z = pr.length;
            int i = 0;
            while (i < z) {
                pr[i++].process(t, n);
            }
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected void resetAudioProcessors(int bufSize, float frameRate, AudioProcessor[] processors) throws StudioException {
        this.prs = processors;
    }

    protected void shutdownAudioProcessors() {
        for (int i = 0; i < this.prs.length; ++i) {
            try {
                this.prs[i].shutdown();
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

