/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.sound.plugin.AudioPreferencesConst;
import com.spacekiller.util.sound.plugin.AudioPreferencesPanel;
import com.spacekiller.util.sound.plugin.SoundPlugin;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.util.logging.Logger;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;

public class AudioPreferencesPage
extends AbstractPreferencesPage
implements AudioPreferencesConst {
    private static final Logger logger = Logger.getLogger(AudioPreferencesPage.class.getName());
    private PreferencesRegistry registry;

    public Component createComponent() {
        AudioPreferencesPanel panel = new AudioPreferencesPanel();
        return panel;
    }

    public void refreshPreferences(View view) throws Exception {
        AudioPreferencesPanel panel = this.getAudioPreferencesPanel(view);
        SoundPlugin soundPlugin = SoundPlugin.getInstance();
        AudioFileReader[] readers = soundPlugin.getDefaultAudioFileReaders();
        int num = readers == null ? 0 : readers.length;
        String[] defaultFileReaderClassNames = new String[num];
        for (int i = 0; i < num; ++i) {
            AudioFileReader reader = readers[i];
            if (reader == null) continue;
            defaultFileReaderClassNames[i] = reader.getClass().getName();
        }
        panel.setDefaultFileReaderClassNames(defaultFileReaderClassNames);
        FormatConversionProvider[] codecs = soundPlugin.getDefaultFormatConversionProviders();
        num = codecs == null ? 0 : codecs.length;
        String[] defaultFormatConverterClassNames = new String[num];
        for (int i = 0; i < num; ++i) {
            FormatConversionProvider codec = codecs[i];
            if (codec == null) continue;
            defaultFormatConverterClassNames[i] = codec.getClass().getName();
        }
        panel.setDefaultFormatConverterClassNames(defaultFormatConverterClassNames);
        boolean useCustomCodecs = false;
        String[] customFileReaderClassNames = null;
        String[] customFormatConverterClassNames = null;
        Preferences prefs = this.getPreferences();
        if (prefs != null) {
            Object value = prefs.getObject("audio.custom.codecs");
            if (value != null && "true".equalsIgnoreCase(value.toString())) {
                useCustomCodecs = true;
            }
            if ((value = prefs.getObject("audio.custom.file.readers")) != null && value instanceof String[]) {
                customFileReaderClassNames = (String[])value;
            }
            if ((value = prefs.getObject("audio.custom.format.converters")) != null && value instanceof String[]) {
                customFormatConverterClassNames = (String[])value;
            }
        }
        panel.setCustomFileReaderClassNames(customFileReaderClassNames);
        panel.setCustomFormatConverterClassNames(customFormatConverterClassNames);
        panel.setUseCustomCodecs(useCustomCodecs);
    }

    public void resetPreferences(View view) throws Exception {
        logger.fine("TODO: resetPreferences: " + view);
    }

    public void savePreferences(View view) throws Exception {
        AudioPreferencesPanel panel = this.getAudioPreferencesPanel(view);
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            prefs = this.getRegistry().createPreferences("platform.audio");
        }
        prefs.setObject("audio.custom.codecs", (Object)(panel.isUseCustomCodecs() ? Boolean.TRUE : Boolean.FALSE));
        prefs.setObject("audio.custom.file.readers", (Object)panel.getCustomFileReaderClassNames());
        prefs.setObject("audio.custom.format.converters", (Object)panel.getCustomFormatConverterClassNames());
        this.getRegistry().savePreferences(prefs);
        SoundPlugin.getInstance().applyPreferences();
    }

    protected AudioPreferencesPanel getAudioPreferencesPanel(View view) {
        Component comp = view.getComponent();
        if (comp != null && comp instanceof AudioPreferencesPanel) {
            return (AudioPreferencesPanel)comp;
        }
        return null;
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences("platform.audio");
    }
}

