/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.sound.plugin.AudioPreferencesConst;
import com.spacekiller.util.sound.plugin.CodecListPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AudioPreferencesPanel
extends JPanel
implements AudioPreferencesConst {
    private static final long serialVersionUID = -2434344749647887805L;
    private static final Logger logger = Logger.getLogger(AudioPreferencesPanel.class.getName());
    private boolean refreshing;
    private boolean useCustomCodecs;
    private String[] defaultFileReaderClassNames;
    private String[] customFileReaderClassNames;
    private String[] defaultFormatConverterClassNames;
    private String[] customFormatConverterClassNames;
    private JPanel jPanelFill = null;
    private JPanel panelCodecs;
    private JPanel panelReaders;
    private CodecListPanel readerCodecListPanel;
    private JPanel panelConverters;
    private CodecListPanel converterCodecListPanel;
    private JPanel panelCustom;
    private JCheckBox chckbxCustom;

    public AudioPreferencesPanel() {
        this.initialize();
        this.initAudioPreferencesPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(412, 484));
        GridBagConstraints gbc_panelCustom = new GridBagConstraints();
        gbc_panelCustom.insets = new Insets(0, 0, 5, 0);
        gbc_panelCustom.fill = 1;
        gbc_panelCustom.gridx = 0;
        gbc_panelCustom.gridy = 0;
        this.add((Component)this.getPanelCustom(), gbc_panelCustom);
        this.add((Component)this.getJPanelFill(), gridBagConstraints1);
        GridBagConstraints gbc_panelCodecs = new GridBagConstraints();
        gbc_panelCodecs.insets = new Insets(0, 0, 5, 0);
        gbc_panelCodecs.fill = 1;
        gbc_panelCodecs.gridx = 0;
        gbc_panelCodecs.gridy = 1;
        this.add((Component)this.getPanelCodecs(), gbc_panelCodecs);
    }

    private JPanel getJPanelFill() {
        if (this.jPanelFill == null) {
            this.jPanelFill = new JPanel();
            this.jPanelFill.setLayout(new GridBagLayout());
            this.jPanelFill.setOpaque(false);
        }
        return this.jPanelFill;
    }

    protected void initAudioPreferencesPanel() {
        this.readerCodecListPanel.setRootClassName(AudioFileReader.class.getName());
        this.converterCodecListPanel.setRootClassName(FormatConversionProvider.class.getName());
        this.setMinimumSize(new Dimension(50, 50));
        this.refresh();
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JPanel getPanelCodecs() {
        if (this.panelCodecs == null) {
            this.panelCodecs = new JPanel();
            GridBagLayout gbl_panelCodecs = new GridBagLayout();
            gbl_panelCodecs.columnWidths = new int[]{0, 0};
            gbl_panelCodecs.rowHeights = new int[]{0, 0, 0};
            gbl_panelCodecs.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_panelCodecs.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
            this.panelCodecs.setLayout(gbl_panelCodecs);
            GridBagConstraints gbc_panelReaders = new GridBagConstraints();
            gbc_panelReaders.insets = new Insets(4, 4, 4, 4);
            gbc_panelReaders.fill = 1;
            gbc_panelReaders.gridx = 0;
            gbc_panelReaders.gridy = 0;
            this.panelCodecs.add((Component)this.getPanelReaders(), gbc_panelReaders);
            GridBagConstraints gbc_panelConverters = new GridBagConstraints();
            gbc_panelConverters.insets = new Insets(0, 4, 4, 4);
            gbc_panelConverters.fill = 1;
            gbc_panelConverters.gridx = 0;
            gbc_panelConverters.gridy = 1;
            this.panelCodecs.add((Component)this.getPanelConverters(), gbc_panelConverters);
        }
        return this.panelCodecs;
    }

    private JPanel getPanelReaders() {
        if (this.panelReaders == null) {
            this.panelReaders = new JPanel();
            this.panelReaders.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio File Readers", 4, 2, null, null));
            this.panelReaders.setLayout(new GridLayout(1, 0, 0, 0));
            this.panelReaders.add(this.getReaderCodecListPanel());
        }
        return this.panelReaders;
    }

    private CodecListPanel getReaderCodecListPanel() {
        if (this.readerCodecListPanel == null) {
            this.readerCodecListPanel = new CodecListPanel();
            this.readerCodecListPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AudioPreferencesPanel.this.refreshing && AudioPreferencesPanel.this.chckbxCustom.isSelected()) {
                        AudioPreferencesPanel.this.customReadersChanged();
                    }
                }
            });
        }
        return this.readerCodecListPanel;
    }

    private JPanel getPanelConverters() {
        if (this.panelConverters == null) {
            this.panelConverters = new JPanel();
            this.panelConverters.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Format Converters", 4, 2, null, null));
            this.panelConverters.setLayout(new GridLayout(0, 1, 0, 0));
            this.panelConverters.add(this.getConverterCodecListPanel());
        }
        return this.panelConverters;
    }

    private CodecListPanel getConverterCodecListPanel() {
        if (this.converterCodecListPanel == null) {
            this.converterCodecListPanel = new CodecListPanel();
            this.converterCodecListPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!AudioPreferencesPanel.this.refreshing && AudioPreferencesPanel.this.chckbxCustom.isSelected()) {
                        AudioPreferencesPanel.this.customConvertersChanged();
                    }
                }
            });
        }
        return this.converterCodecListPanel;
    }

    private JPanel getPanelCustom() {
        if (this.panelCustom == null) {
            this.panelCustom = new JPanel();
            GridBagLayout gbl_panelCustom = new GridBagLayout();
            gbl_panelCustom.columnWidths = new int[]{0, 0};
            gbl_panelCustom.rowHeights = new int[]{0, 0};
            gbl_panelCustom.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelCustom.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelCustom.setLayout(gbl_panelCustom);
            GridBagConstraints gbc_chckbxCustom = new GridBagConstraints();
            gbc_chckbxCustom.insets = new Insets(4, 4, 4, 4);
            gbc_chckbxCustom.gridx = 0;
            gbc_chckbxCustom.gridy = 0;
            this.panelCustom.add((Component)this.getChckbxCustom(), gbc_chckbxCustom);
        }
        return this.panelCustom;
    }

    private JCheckBox getChckbxCustom() {
        if (this.chckbxCustom == null) {
            this.chckbxCustom = new JCheckBox("Use Custom Codecs:");
            this.chckbxCustom.setToolTipText("Use custom codec(s) ?");
            this.chckbxCustom.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!AudioPreferencesPanel.this.refreshing) {
                        AudioPreferencesPanel.this.useCustomCodecs = AudioPreferencesPanel.this.chckbxCustom.isSelected();
                        AudioPreferencesPanel.this.refresh();
                    }
                }
            });
        }
        return this.chckbxCustom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            String[] converterClassNames;
            String[] readerClassNames;
            this.refreshing = true;
            boolean custom = this.useCustomCodecs;
            this.chckbxCustom.setSelected(custom);
            this.panelReaders.setEnabled(custom);
            this.readerCodecListPanel.setEnabled(custom);
            this.panelConverters.setEnabled(custom);
            this.converterCodecListPanel.setEnabled(custom);
            String[] stringArray = readerClassNames = custom ? this.customFileReaderClassNames : this.defaultFileReaderClassNames;
            if (readerClassNames == null && custom) {
                readerClassNames = this.defaultFileReaderClassNames;
            }
            this.readerCodecListPanel.setCodecClassNames(readerClassNames);
            String[] stringArray2 = converterClassNames = custom ? this.customFormatConverterClassNames : this.defaultFormatConverterClassNames;
            if (converterClassNames == null && custom) {
                converterClassNames = this.defaultFormatConverterClassNames;
            }
            this.converterCodecListPanel.setCodecClassNames(converterClassNames);
        }
        finally {
            this.refreshing = false;
        }
    }

    public boolean isUseCustomCodecs() {
        return this.useCustomCodecs;
    }

    public void setUseCustomCodecs(boolean useCustomCodecs) {
        this.useCustomCodecs = useCustomCodecs;
        this.invalidate();
        this.refresh();
    }

    public String[] getDefaultFileReaderClassNames() {
        return this.defaultFileReaderClassNames;
    }

    public void setDefaultFileReaderClassNames(String[] defaultFileReaderClassNames) {
        this.defaultFileReaderClassNames = defaultFileReaderClassNames;
        this.invalidate();
    }

    public String[] getCustomFileReaderClassNames() {
        return this.customFileReaderClassNames;
    }

    public void setCustomFileReaderClassNames(String[] customFileReaderClassNames) {
        this.customFileReaderClassNames = customFileReaderClassNames;
        this.invalidate();
    }

    public String[] getDefaultFormatConverterClassNames() {
        return this.defaultFormatConverterClassNames;
    }

    public void setDefaultFormatConverterClassNames(String[] defaultFormatConverterClassNames) {
        this.defaultFormatConverterClassNames = defaultFormatConverterClassNames;
        this.invalidate();
    }

    public String[] getCustomFormatConverterClassNames() {
        return this.customFormatConverterClassNames;
    }

    public void setCustomFormatConverterClassNames(String[] customFormatConverterClassNames) {
        this.customFormatConverterClassNames = customFormatConverterClassNames;
        this.invalidate();
    }

    protected void customReadersChanged() {
        this.customFileReaderClassNames = this.readerCodecListPanel.getCodecClassNames();
    }

    protected void customConvertersChanged() {
        this.customFormatConverterClassNames = this.converterCodecListPanel.getCodecClassNames();
    }
}

