/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;

public class AudioServiceLoader {
    private static final Logger logger = Logger.getLogger(AudioServiceLoader.class.getName());
    private static final String SERVICE_LOADER_CLASS_NAME = "java.util.ServiceLoader";
    private static final String JDK13_SERVICES_CLASS_NAME = "com.sun.media.sound.JDK13Services";

    protected AudioServiceLoader() {
    }

    protected static AudioFileReader[] lookupAudioFileReaders() {
        return new AudioServiceLoader().getAudioFileReaders();
    }

    protected static FormatConversionProvider[] lookupFormatConversionProviders() {
        return new AudioServiceLoader().getFormatConversionProviders();
    }

    protected AudioFileReader[] getAudioFileReaders() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("lookupAudioFileReaders...");
        }
        ArrayList readers = new ArrayList();
        boolean success = false;
        if (!success) {
            success = this.getAudioFileReadersFromServiceLoader(readers);
        }
        if (!success) {
            success = this.getAudioFileReadersFromAudioSystem(readers);
        }
        if (!success) {
            success = this.getAudioFileReadersFromJDK13Services(readers);
        }
        int num = readers.size();
        AudioFileReader[] arr = readers.toArray(new AudioFileReader[num]);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("lookupAudioFileReaders: return " + num + " reader(s)");
            if (logger.isLoggable(Level.FINER)) {
                for (int i = 0; i < num; ++i) {
                    logger.finer("AudioFileReader #" + i + ": " + arr[i]);
                }
            }
        }
        return arr;
    }

    protected FormatConversionProvider[] getFormatConversionProviders() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("lookupFormatConversionProviders...");
        }
        ArrayList codecs = new ArrayList();
        boolean success = false;
        if (!success) {
            success = this.getFormatConversionProvidersFromServiceLoader(codecs);
        }
        if (!success) {
            success = this.getFormatConversionProvidersFromAudioSystem(codecs);
        }
        if (!success) {
            success = this.getFormatConversionProvidersFromJDK13Services(codecs);
        }
        int num = codecs.size();
        FormatConversionProvider[] arr = codecs.toArray(new FormatConversionProvider[num]);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("lookupFormatConversionProviders: return " + num + " codec(s)");
            if (logger.isLoggable(Level.FINER)) {
                for (int i = 0; i < num; ++i) {
                    logger.finer("FormatConversionProvider #" + i + ": " + arr[i]);
                }
            }
        }
        return arr;
    }

    protected final boolean getAudioFileReadersFromServiceLoader(List dstList) {
        return this.getProvidersFromServiceLoader(AudioFileReader.class, dstList);
    }

    protected final boolean getFormatConversionProvidersFromServiceLoader(List dstList) {
        return this.getProvidersFromServiceLoader(FormatConversionProvider.class, dstList);
    }

    private final boolean getProvidersFromServiceLoader(Class serviceType, List dstList) {
        if (serviceType == null) {
            throw new NullPointerException("serviceType");
        }
        if (dstList == null) {
            throw new NullPointerException("dstList");
        }
        Class<?> serviceLoaderClass = null;
        try {
            serviceLoaderClass = Class.forName(SERVICE_LOADER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        if (serviceLoaderClass == null) {
            return false;
        }
        try {
            ClassLoader classLoader = serviceLoaderClass.getClassLoader();
            Method staticLoadMethod = serviceLoaderClass.getMethod("load", Class.class, ClassLoader.class);
            Object serviceLoader = staticLoadMethod.invoke(null, serviceType, classLoader);
            if (serviceLoader == null || !serviceLoaderClass.isInstance(serviceLoader)) {
                throw new RuntimeException("Invalid ServiceLoader: " + serviceLoader);
            }
            Method dynamicIteratorMethod = serviceLoaderClass.getMethod("iterator", new Class[0]);
            Object iteratorObj = dynamicIteratorMethod.invoke(serviceLoader, new Object[0]);
            if (iteratorObj == null || !(iteratorObj instanceof Iterator)) {
                throw new RuntimeException("Invalid ServiceLoader-Iterator: " + iteratorObj);
            }
            Iterator iterator = (Iterator)iteratorObj;
            while (iterator.hasNext()) {
                Object provider = iterator.next();
                if (provider == null) continue;
                if (!serviceType.isInstance(provider)) {
                    logger.warning("Ignoring incompatible service provider: type=" + serviceType + ", provider=" + provider);
                    continue;
                }
                dstList.add(provider);
            }
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected final boolean getAudioFileReadersFromAudioSystem(List dstList) {
        try {
            Method getAudioFileReaders = AudioSystem.class.getDeclaredMethod("getAudioFileReaders", new Class[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupAudioFileReaders: using " + getAudioFileReaders);
            }
            getAudioFileReaders.setAccessible(true);
            Object result = getAudioFileReaders.invoke(null, new Object[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupAudioFileReaders: AudioSystem result " + result);
            }
            if (result != null && result instanceof List) {
                List resultList = (List)result;
                for (Object obj : resultList) {
                    if (obj == null || !(obj instanceof AudioFileReader)) continue;
                    dstList.add((AudioFileReader)obj);
                }
                return true;
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    protected final boolean getFormatConversionProvidersFromAudioSystem(List dstList) {
        try {
            Method getFormatConversionProviders = AudioSystem.class.getDeclaredMethod("getFormatConversionProviders", new Class[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupFormatConversionProviders: using " + getFormatConversionProviders);
            }
            getFormatConversionProviders.setAccessible(true);
            Object result = getFormatConversionProviders.invoke(null, new Object[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupFormatConversionProviders: AudioSystem result " + result);
            }
            if (result != null && result instanceof List) {
                List resultList = (List)result;
                for (Object obj : resultList) {
                    if (obj == null || !(obj instanceof FormatConversionProvider)) continue;
                    dstList.add((FormatConversionProvider)obj);
                }
                return true;
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    protected final boolean getAudioFileReadersFromJDK13Services(List dstList) {
        try {
            Class<?> jdk13Services = Class.forName(JDK13_SERVICES_CLASS_NAME);
            Method getProviders = jdk13Services.getDeclaredMethod("getProviders", Class.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupAudioFileReaders: using " + getProviders);
            }
            Object result = getProviders.invoke(null, AudioFileReader.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupAudioFileReaders: JDK13Services result " + result);
            }
            if (result != null && result instanceof List) {
                List resultList = (List)result;
                for (Object obj : resultList) {
                    if (obj == null || !(obj instanceof AudioFileReader)) continue;
                    dstList.add((AudioFileReader)obj);
                }
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    protected final boolean getFormatConversionProvidersFromJDK13Services(List dstList) {
        try {
            Class<?> jdk13Services = Class.forName(JDK13_SERVICES_CLASS_NAME);
            Method getProviders = jdk13Services.getDeclaredMethod("getProviders", Class.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupFormatConversionProviders: using " + getProviders);
            }
            Object result = getProviders.invoke(null, FormatConversionProvider.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("lookupFormatConversionProviders: JDK13Services result " + result);
            }
            if (result != null && result instanceof List) {
                List resultList = (List)result;
                for (Object obj : resultList) {
                    if (obj == null || !(obj instanceof FormatConversionProvider)) continue;
                    dstList.add((FormatConversionProvider)obj);
                }
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }
}

