/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.math.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BpmCalculatorPanel
extends JPanel {
    private static final long serialVersionUID = 4741728912068396211L;
    private boolean refreshing = false;
    private JTextField textFieldDuration;
    private JTextField textFieldBPM;
    private JTextField textFieldSourceBPM;
    private JTextField textFieldTargetBPM;
    private JTextField textFieldPercentBPM;

    public BpmCalculatorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "BPM / Duration", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblBeatsPerMinute = new JLabel("Beats per minute:");
        GridBagConstraints gbc_lblBeatsPerMinute = new GridBagConstraints();
        gbc_lblBeatsPerMinute.anchor = 17;
        gbc_lblBeatsPerMinute.insets = new Insets(4, 4, 5, 5);
        gbc_lblBeatsPerMinute.gridx = 0;
        gbc_lblBeatsPerMinute.gridy = 0;
        panel.add((Component)lblBeatsPerMinute, gbc_lblBeatsPerMinute);
        this.textFieldBPM = new JTextField();
        GridBagConstraints gbc_textFieldBPM = new GridBagConstraints();
        gbc_textFieldBPM.weightx = 1.0;
        gbc_textFieldBPM.fill = 2;
        gbc_textFieldBPM.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldBPM.gridx = 1;
        gbc_textFieldBPM.gridy = 0;
        panel.add((Component)this.textFieldBPM, gbc_textFieldBPM);
        this.textFieldBPM.setColumns(10);
        JLabel lblBpm = new JLabel("BPM");
        lblBpm.setToolTipText("Beats per minute");
        GridBagConstraints gbc_lblBpm = new GridBagConstraints();
        gbc_lblBpm.insets = new Insets(4, 0, 5, 5);
        gbc_lblBpm.anchor = 17;
        gbc_lblBpm.gridx = 2;
        gbc_lblBpm.gridy = 0;
        panel.add((Component)lblBpm, gbc_lblBpm);
        JLabel lblBeatDuration = new JLabel("Beat duration:");
        GridBagConstraints gbc_lblBeatDuration = new GridBagConstraints();
        gbc_lblBeatDuration.anchor = 17;
        gbc_lblBeatDuration.insets = new Insets(4, 4, 5, 5);
        gbc_lblBeatDuration.gridx = 0;
        gbc_lblBeatDuration.gridy = 1;
        panel.add((Component)lblBeatDuration, gbc_lblBeatDuration);
        this.textFieldDuration = new JTextField();
        GridBagConstraints gbc_textFieldDuration = new GridBagConstraints();
        gbc_textFieldDuration.fill = 2;
        gbc_textFieldDuration.weightx = 1.0;
        gbc_textFieldDuration.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldDuration.gridx = 1;
        gbc_textFieldDuration.gridy = 1;
        panel.add((Component)this.textFieldDuration, gbc_textFieldDuration);
        this.textFieldDuration.setColumns(10);
        JLabel lblMs = new JLabel("ms.");
        lblMs.setToolTipText("Milliseconds");
        GridBagConstraints gbc_lblMs = new GridBagConstraints();
        gbc_lblMs.anchor = 17;
        gbc_lblMs.insets = new Insets(4, 0, 5, 5);
        gbc_lblMs.gridx = 2;
        gbc_lblMs.gridy = 1;
        panel.add((Component)lblMs, gbc_lblMs);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "BPM / Pitch", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weighty = 1.0;
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(0, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblSourceBpm = new JLabel("Source BPM:");
        GridBagConstraints gbc_lblSourceBpm = new GridBagConstraints();
        gbc_lblSourceBpm.anchor = 17;
        gbc_lblSourceBpm.insets = new Insets(4, 4, 5, 5);
        gbc_lblSourceBpm.gridx = 0;
        gbc_lblSourceBpm.gridy = 0;
        panel_1.add((Component)lblSourceBpm, gbc_lblSourceBpm);
        this.textFieldSourceBPM = new JTextField();
        GridBagConstraints gbc_textFieldSourceBPM = new GridBagConstraints();
        gbc_textFieldSourceBPM.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldSourceBPM.fill = 2;
        gbc_textFieldSourceBPM.gridx = 1;
        gbc_textFieldSourceBPM.gridy = 0;
        panel_1.add((Component)this.textFieldSourceBPM, gbc_textFieldSourceBPM);
        this.textFieldSourceBPM.setColumns(10);
        JLabel label_1 = new JLabel("BPM");
        label_1.setToolTipText("Beats per minute");
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.insets = new Insets(4, 0, 5, 4);
        gbc_label_1.gridx = 2;
        gbc_label_1.gridy = 0;
        panel_1.add((Component)label_1, gbc_label_1);
        JLabel lblTargetBpm = new JLabel("Target BPM:");
        GridBagConstraints gbc_lblTargetBpm = new GridBagConstraints();
        gbc_lblTargetBpm.anchor = 17;
        gbc_lblTargetBpm.insets = new Insets(4, 4, 5, 5);
        gbc_lblTargetBpm.gridx = 0;
        gbc_lblTargetBpm.gridy = 1;
        panel_1.add((Component)lblTargetBpm, gbc_lblTargetBpm);
        this.textFieldTargetBPM = new JTextField();
        GridBagConstraints gbc_textFieldTargetBPM = new GridBagConstraints();
        gbc_textFieldTargetBPM.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldTargetBPM.fill = 2;
        gbc_textFieldTargetBPM.gridx = 1;
        gbc_textFieldTargetBPM.gridy = 1;
        panel_1.add((Component)this.textFieldTargetBPM, gbc_textFieldTargetBPM);
        this.textFieldTargetBPM.setColumns(10);
        JLabel label_2 = new JLabel("BPM");
        label_2.setToolTipText("Beats per minute");
        GridBagConstraints gbc_label_2 = new GridBagConstraints();
        gbc_label_2.insets = new Insets(4, 0, 5, 4);
        gbc_label_2.gridx = 2;
        gbc_label_2.gridy = 1;
        panel_1.add((Component)label_2, gbc_label_2);
        JLabel lblPercent = new JLabel("Pitch Percent:");
        GridBagConstraints gbc_lblPercent = new GridBagConstraints();
        gbc_lblPercent.anchor = 17;
        gbc_lblPercent.insets = new Insets(4, 4, 5, 5);
        gbc_lblPercent.gridx = 0;
        gbc_lblPercent.gridy = 2;
        panel_1.add((Component)lblPercent, gbc_lblPercent);
        this.textFieldPercentBPM = new JTextField();
        GridBagConstraints gbc_textFieldPercentBPM = new GridBagConstraints();
        gbc_textFieldPercentBPM.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldPercentBPM.fill = 2;
        gbc_textFieldPercentBPM.gridx = 1;
        gbc_textFieldPercentBPM.gridy = 2;
        panel_1.add((Component)this.textFieldPercentBPM, gbc_textFieldPercentBPM);
        this.textFieldPercentBPM.setColumns(10);
        JLabel label = new JLabel("%");
        label.setToolTipText("Percent");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 17;
        gbc_label.insets = new Insets(4, 0, 5, 4);
        gbc_label.gridx = 2;
        gbc_label.gridy = 2;
        panel_1.add((Component)label, gbc_label);
        this.initBpmCalculatorPanel();
    }

    protected JTextField getTextFieldDuration() {
        return this.textFieldDuration;
    }

    protected JTextField getTextFieldBPM() {
        return this.textFieldBPM;
    }

    protected void initBpmCalculatorPanel() {
        this.textFieldDuration.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleDurationChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleDurationChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleDurationChanged();
            }
        });
        this.textFieldBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleBPMChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleBPMChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleBPMChanged();
            }
        });
        this.textFieldSourceBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleSourceBPMChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleSourceBPMChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleSourceBPMChanged();
            }
        });
        this.textFieldTargetBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleTargetBPMChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleTargetBPMChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handleTargetBPMChanged();
            }
        });
        this.textFieldPercentBPM.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handlePercentBPMChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handlePercentBPMChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BpmCalculatorPanel.this.handlePercentBPMChanged();
            }
        });
    }

    protected void handleDurationChanged() {
        if (this.refreshing) {
            return;
        }
        this.computeBPM();
    }

    protected void handleBPMChanged() {
        if (this.refreshing) {
            return;
        }
        this.computeDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeBPM() {
        double bpm = 0.0;
        String durationText = this.textFieldDuration.getText().trim();
        try {
            double millisPerBeat = Double.parseDouble(durationText);
            bpm = MathUtil.getBeatsPerMinute((double)millisPerBeat);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String bpmText = bpm != 0.0 ? String.valueOf(bpm) : "";
        try {
            this.refreshing = true;
            this.textFieldBPM.setText(bpmText);
            this.textFieldBPM.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeDuration() {
        double duration = 0.0;
        String bpmText = this.textFieldBPM.getText().trim();
        try {
            double millisPerBeat;
            double bpm = Double.parseDouble(bpmText);
            duration = millisPerBeat = MathUtil.getMillisPerBeat((double)bpm);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String durationText = duration != 0.0 ? String.valueOf(duration) : "";
        try {
            this.refreshing = true;
            this.textFieldDuration.setText(durationText);
            this.textFieldDuration.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JTextField getTextFieldSourceBPM() {
        return this.textFieldSourceBPM;
    }

    protected JTextField getTextFieldTargetBPM() {
        return this.textFieldTargetBPM;
    }

    protected JTextField getTextFieldPercentBPM() {
        return this.textFieldPercentBPM;
    }

    protected void handleSourceBPMChanged() {
        if (this.refreshing) {
            return;
        }
        this.computePercentBPM();
    }

    protected void handleTargetBPMChanged() {
        if (this.refreshing) {
            return;
        }
        this.computePercentBPM();
    }

    protected void handlePercentBPMChanged() {
        if (this.refreshing) {
            return;
        }
        this.computeTargetBPM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computePercentBPM() {
        String pitchText;
        double pitchPercent = Double.NaN;
        String sourceBPMText = this.textFieldSourceBPM.getText().trim();
        String targetBPMText = this.textFieldTargetBPM.getText().trim();
        try {
            double sourceBPM = Double.parseDouble(sourceBPMText);
            double targetBPM = Double.parseDouble(targetBPMText);
            pitchPercent = targetBPM * 100.0 / sourceBPM - 100.0;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String string = pitchText = Double.isNaN(pitchPercent) ? "" : String.valueOf(pitchPercent);
        if (pitchPercent > 0.0) {
            pitchText = "+" + pitchText;
        }
        try {
            this.refreshing = true;
            this.textFieldPercentBPM.setText(pitchText);
            this.textFieldPercentBPM.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeTargetBPM() {
        double targetBPM = 0.0;
        String sourceBPMText = this.textFieldSourceBPM.getText().trim();
        String percentBPMText = this.textFieldPercentBPM.getText().trim();
        try {
            double sourceBPM = Double.parseDouble(sourceBPMText);
            double percentBPM = Double.parseDouble(percentBPMText);
            targetBPM = sourceBPM * (100.0 + percentBPM) / 100.0;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String targetBPMText = targetBPM != 0.0 ? String.valueOf(targetBPM) : "";
        try {
            this.refreshing = true;
            this.textFieldTargetBPM.setText(targetBPMText);
            this.textFieldTargetBPM.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    public double getBpm() {
        String bpmText = this.textFieldBPM.getText().trim();
        double bpm = Double.parseDouble(bpmText);
        return bpm;
    }

    public void setBpm(double value) {
        this.textFieldBPM.setText(String.valueOf(value));
        this.textFieldBPM.setCaretPosition(0);
    }

    public double getBeatDuration() {
        String beatDurationText = this.textFieldDuration.getText().trim();
        double beatDuration = Double.parseDouble(beatDurationText);
        return beatDuration;
    }

    public void setBeatDuration(double value) {
        this.textFieldDuration.setText(String.valueOf(value));
        this.textFieldDuration.setCaretPosition(0);
    }

    public double getSourceBpm() {
        String sourceBPMText = this.textFieldSourceBPM.getText().trim();
        double sourceBPM = Double.parseDouble(sourceBPMText);
        return sourceBPM;
    }

    public void setSourceBpm(double value) {
        this.textFieldSourceBPM.setText(String.valueOf(value));
        this.textFieldSourceBPM.setCaretPosition(0);
    }

    public double getTargetBpm() {
        String targetBPMText = this.textFieldTargetBPM.getText().trim();
        double targetBPM = Double.parseDouble(targetBPMText);
        return targetBPM;
    }

    public void setTargetBpm(double value) {
        this.textFieldTargetBPM.setText(String.valueOf(value));
        this.textFieldTargetBPM.setCaretPosition(0);
    }

    public double getPercentBpm() {
        String percentBPMText = this.textFieldPercentBPM.getText().trim();
        double percentBPM = Double.parseDouble(percentBPMText);
        return percentBPM;
    }

    public void setPercentBpm(double value) {
        this.textFieldPercentBPM.setText(String.valueOf(value));
        this.textFieldPercentBPM.setCaretPosition(0);
    }
}

