/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.math.MathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BpmCounterPanel
extends JPanel {
    private static final long serialVersionUID = -600183221090824927L;
    private static long MAX_TAP_MILLIS = 1500L;
    private long firstTapMillis = 0L;
    private long lastTapMillis = 0L;
    private int tapCount = 0;
    private JButton jButtonTap = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldBPM = null;

    public BpmCounterPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(266, 101));
        this.add((Component)this.getJPanel(), gridBagConstraints1);
    }

    private JButton getJButtonTap() {
        if (this.jButtonTap == null) {
            this.jButtonTap = new JButton();
            this.jButtonTap.setText("");
            this.jButtonTap.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/sound/plugin/icons/beat_icon24.gif")));
            this.jButtonTap.setMargin(new Insets(4, 4, 4, 4));
            this.jButtonTap.setToolTipText("Press the button to the beat for BPM calculation");
            this.jButtonTap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BpmCounterPanel.this.tap();
                }
            });
        }
        return this.jButtonTap;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints3.gridx = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("bpm");
            this.jLabel.setFont(new Font("Dialog", 0, 12));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getJTextFieldBPM(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJButtonTap(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JTextField getJTextFieldBPM() {
        if (this.jTextFieldBPM == null) {
            this.jTextFieldBPM = new JTextField();
            this.jTextFieldBPM.setEditable(false);
            this.jTextFieldBPM.setHorizontalAlignment(4);
            this.jTextFieldBPM.setColumns(8);
        }
        return this.jTextFieldBPM;
    }

    protected void tap() {
        long ms = System.currentTimeMillis();
        if (this.tapCount == 0) {
            this.firstTapMillis = ms;
        } else {
            long delta = ms - this.lastTapMillis;
            if (delta > MAX_TAP_MILLIS) {
                this.tapCount = 0;
                this.firstTapMillis = ms;
            }
        }
        this.lastTapMillis = ms;
        ++this.tapCount;
        this.refresh();
    }

    protected void refresh() {
        double bpm = -1.0;
        if (this.tapCount > 1) {
            double totalMillis = this.lastTapMillis - this.firstTapMillis;
            double beats = this.tapCount - 1;
            double millisPerBeat = totalMillis / beats;
            bpm = MathUtil.getBeatsPerMinute((double)millisPerBeat);
        }
        String bpmString = null;
        if (bpm > 0.0) {
            bpmString = String.valueOf((double)Math.round(bpm * 100.0) / 100.0);
            int pos = bpmString.lastIndexOf(".");
            for (int len = bpmString.length(); pos + 3 > len; ++len) {
                bpmString = bpmString + "0";
            }
        }
        if (bpmString == null) {
            bpmString = "";
        }
        this.getJTextFieldBPM().setText(bpmString);
    }
}

