/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.ClassDescriptor;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.components.ClassChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CodecListPanel
extends JPanel {
    private static final long serialVersionUID = 5390353522176503018L;
    private static final Logger logger = Logger.getLogger(CodecListPanel.class.getName());
    private String rootClassName;
    private String[] codecClassNames;
    private JList listCodecs;
    private JButton btnAdd;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private JButton btnRemove;

    public CodecListPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(20, 20));
        scrollPane.setPreferredSize(new Dimension(40, 40));
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.insets = new Insets(0, 0, 0, 5);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panel.add((Component)scrollPane, gbc_scrollPane);
        this.listCodecs = new JList();
        this.listCodecs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodecListPanel.this.checkEnable();
            }
        });
        this.listCodecs.setOpaque(false);
        scrollPane.setViewportView(this.listCodecs);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 0;
        panel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.btnAdd = new JButton("Add...");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodecListPanel.this.actionAdd();
            }
        });
        this.btnAdd.setMargin(new Insets(2, 4, 2, 4));
        this.btnAdd.setToolTipText("Add codec...");
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.fill = 2;
        gbc_btnAdd.weightx = 1.0;
        gbc_btnAdd.insets = new Insets(0, 0, 5, 0);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 0;
        panel_1.add((Component)this.btnAdd, gbc_btnAdd);
        this.btnMoveUp = new JButton("Move Up");
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodecListPanel.this.actionMoveUp();
            }
        });
        this.btnMoveUp.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnMoveUp = new GridBagConstraints();
        gbc_btnMoveUp.fill = 2;
        gbc_btnMoveUp.insets = new Insets(0, 0, 5, 0);
        gbc_btnMoveUp.gridx = 0;
        gbc_btnMoveUp.gridy = 1;
        panel_1.add((Component)this.btnMoveUp, gbc_btnMoveUp);
        this.btnMoveDown = new JButton("Move Down");
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodecListPanel.this.actionMoveDown();
            }
        });
        this.btnMoveDown.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnMoveDown = new GridBagConstraints();
        gbc_btnMoveDown.fill = 2;
        gbc_btnMoveDown.insets = new Insets(0, 0, 5, 0);
        gbc_btnMoveDown.gridx = 0;
        gbc_btnMoveDown.gridy = 2;
        panel_1.add((Component)this.btnMoveDown, gbc_btnMoveDown);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodecListPanel.this.actionRemove();
            }
        });
        this.btnRemove.setMargin(new Insets(2, 4, 2, 4));
        this.btnRemove.setToolTipText("Remove selected codec(s)");
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.fill = 2;
        gbc_btnRemove.gridx = 0;
        gbc_btnRemove.gridy = 3;
        panel_1.add((Component)this.btnRemove, gbc_btnRemove);
    }

    protected void refresh() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        if (this.codecClassNames != null) {
            int num = this.codecClassNames.length;
            for (int i = 0; i < num; ++i) {
                listModel.addElement(this.codecClassNames[i]);
            }
        }
        this.listCodecs.setModel(listModel);
        this.checkEnable();
    }

    protected JList getListCodecs() {
        return this.listCodecs;
    }

    public String[] getCodecClassNames() {
        return this.codecClassNames;
    }

    public void setCodecClassNames(String[] codecClassNames) {
        String[] oldValue = this.codecClassNames;
        this.codecClassNames = codecClassNames;
        this.refresh();
        this.firePropertyChange("codecClassNames", oldValue, codecClassNames);
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public void setRootClassName(String rootClassName) {
        this.rootClassName = rootClassName;
    }

    protected void actionAdd() {
        try {
            ClassRegistry classRegistry = Platform.getInstance().getClassRegistry();
            ClassChooser classChooser = new ClassChooser();
            classChooser.setClassRegistry(classRegistry);
            ClassChooser.AssignableFromClassFilter assignableFromClassFilter = new ClassChooser.AssignableFromClassFilter(classRegistry, this.rootClassName);
            ClassChooser.DefaultConstructorClassFilter defaultConstructorClassFilter = new ClassChooser.DefaultConstructorClassFilter();
            ClassChooser.PublicConstructorClassFilter publicConstructorClassFilter = new ClassChooser.PublicConstructorClassFilter();
            ClassChooser.MultiClassFilter multiClassFilter = new ClassChooser.MultiClassFilter(new Filter[]{assignableFromClassFilter, defaultConstructorClassFilter, publicConstructorClassFilter});
            classChooser.setClassFilter((Filter)multiClassFilter);
            classChooser.setEmptySearchAction(ClassChooser.EMPTY_SEARCH_ALL);
            classChooser.refresh();
            ClassChooser message = classChooser;
            String title = "Add Codec Class";
            int optionType = 2;
            int messageType = -1;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            ClassDescriptor classDescriptor = classChooser.getSelectedClassDescriptor();
            if (classDescriptor == null) {
                return;
            }
            String className = classDescriptor.getClassName();
            String[] oldArray = this.getCodecClassNames();
            int oldCount = oldArray == null ? 0 : oldArray.length;
            String[] newArray = new String[oldCount + 1];
            if (oldCount > 0) {
                System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            }
            newArray[oldCount] = className;
            this.setCodecClassNames(newArray);
            this.listCodecs.setSelectedIndex(oldCount);
            Rectangle rect = this.listCodecs.getCellBounds(oldCount, oldCount);
            if (rect != null) {
                this.listCodecs.scrollRectToVisible(rect);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void checkEnable() {
        int[] sel = this.listCodecs.getSelectedIndices();
        boolean enabled = this.isEnabled();
        this.btnAdd.setEnabled(enabled);
        this.btnRemove.setEnabled(enabled && sel.length > 0);
        this.btnMoveUp.setEnabled(enabled && sel.length > 0 && sel[0] > 0);
        int codecCount = this.listCodecs.getModel().getSize();
        this.btnMoveDown.setEnabled(enabled && sel.length > 0 && sel[sel.length - 1] < codecCount - 1);
    }

    protected JButton getBtnAdd() {
        return this.btnAdd;
    }

    protected JButton getBtnMoveUp() {
        return this.btnMoveUp;
    }

    protected JButton getBtnMoveDown() {
        return this.btnMoveDown;
    }

    protected JButton getBtnRemove() {
        return this.btnRemove;
    }

    protected void actionRemove() {
        ArrayList<String> newClassNames = new ArrayList<String>();
        if (this.codecClassNames != null) {
            for (int i = 0; i < this.codecClassNames.length; ++i) {
                newClassNames.add(this.codecClassNames[i]);
            }
        }
        int[] sel = this.listCodecs.getSelectedIndices();
        for (int i = 0; i < sel.length; ++i) {
            int index = sel[i];
            String className = (String)this.listCodecs.getModel().getElementAt(index);
            newClassNames.remove(className);
        }
        String[] newArray = newClassNames.toArray(new String[newClassNames.size()]);
        this.setCodecClassNames(newArray);
    }

    protected void actionMoveUp() {
        ArrayList<String> newClassNames = new ArrayList<String>();
        if (this.codecClassNames != null) {
            for (int i = 0; i < this.codecClassNames.length; ++i) {
                newClassNames.add(this.codecClassNames[i]);
            }
        }
        int[] sel = this.listCodecs.getSelectedIndices();
        for (int i = 0; i < sel.length; ++i) {
            int index = sel[i];
            if (index < 1) {
                return;
            }
            String name = (String)newClassNames.remove(index);
            newClassNames.add(index - 1, name);
            sel[i] = index - 1;
        }
        String[] newArray = newClassNames.toArray(new String[newClassNames.size()]);
        this.setCodecClassNames(newArray);
        this.listCodecs.setSelectedIndices(sel);
    }

    protected void actionMoveDown() {
        ArrayList<String> newClassNames = new ArrayList<String>();
        if (this.codecClassNames != null) {
            for (int i = 0; i < this.codecClassNames.length; ++i) {
                newClassNames.add(this.codecClassNames[i]);
            }
        }
        int[] sel = this.listCodecs.getSelectedIndices();
        for (int i = sel.length - 1; i >= 0; --i) {
            int index = sel[i];
            if (index >= newClassNames.size()) {
                return;
            }
            String name = (String)newClassNames.remove(index);
            newClassNames.add(index + 1, name);
            sel[i] = index + 1;
        }
        String[] newArray = newClassNames.toArray(new String[newClassNames.size()]);
        this.setCodecClassNames(newArray);
        this.listCodecs.setSelectedIndices(sel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkEnable();
    }
}

