/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.sound.SoundSystem;
import com.spacekiller.util.sound.SoundUtil;
import com.spacekiller.util.sound.plugin.AudioServiceLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;

public class DefaultSoundSystem
implements SoundSystem {
    private static final String CLASS_NAME = DefaultSoundSystem.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String JDK13_SERVICES_PACKAGE_NAME = "com.sun.media.sound.";
    private static final boolean DEFAULT_AUDIO_SYSTEM_FALLBACK = true;
    private static final boolean DEFAULT_PREFER_NATIVE_READERS = true;
    private static final boolean DEFAULT_PREFER_NATIVE_CODECS = true;
    private static final AudioFormat.Encoding DEFAULT_ENCODING = AudioFormat.Encoding.PCM_SIGNED;
    private static final int DEFAULT_CHANNELS = 2;
    private static final int DEFAULT_BIT_DEPTH = 16;
    private static final float DEFAULT_SAMPLE_RATE = 44100.0f;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private AudioFileReader[] audioFileReaders;
    private FormatConversionProvider[] formatConversionProviders;
    private boolean audioSystemFallback;

    public DefaultSoundSystem() {
        this(true, true, true);
    }

    public DefaultSoundSystem(boolean audioSystemFallback, boolean preferNativeReaders, boolean preferNativeCodecs) {
        this(audioSystemFallback, AudioServiceLoader.lookupAudioFileReaders(), AudioServiceLoader.lookupFormatConversionProviders());
        this.reorderNativeProviders(preferNativeReaders, preferNativeCodecs);
    }

    public DefaultSoundSystem(boolean audioSystemFallback, AudioFileReader[] audioFileReaders, FormatConversionProvider[] formatConversionProviders) {
        this.audioSystemFallback = audioSystemFallback;
        this.audioFileReaders = audioFileReaders;
        this.formatConversionProviders = formatConversionProviders;
    }

    protected boolean isAudioSystemFallback() {
        return this.audioSystemFallback;
    }

    protected void setAudioSystemFallback(boolean audioSystemFallback) {
        this.audioSystemFallback = audioSystemFallback;
    }

    public AudioFileReader[] getAudioFileReaders() {
        AudioFileReader[] orig = this.audioFileReaders;
        AudioFileReader[] copy = new AudioFileReader[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    protected void setAudioFileReaders(AudioFileReader[] audioFileReaders) {
        this.audioFileReaders = audioFileReaders;
    }

    public FormatConversionProvider[] getFormatConversionProviders() {
        FormatConversionProvider[] orig = this.formatConversionProviders;
        FormatConversionProvider[] copy = new FormatConversionProvider[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    protected void setFormatConversionProviders(FormatConversionProvider[] formatConversionProviders) {
        this.formatConversionProviders = formatConversionProviders;
    }

    protected void reorderNativeProviders(boolean preferNativeReaders, boolean preferNativeCodecs) {
        int i;
        int nextNativeIndex;
        ArrayList<Object> newOrder;
        int num;
        if (preferNativeReaders) {
            AudioFileReader[] readers = this.audioFileReaders;
            num = readers.length;
            newOrder = new ArrayList<Object>(num);
            nextNativeIndex = 0;
            for (i = 0; i < num; ++i) {
                AudioFileReader reader = readers[i];
                if (reader != null && this.isNativeProvider(reader.getClass())) {
                    newOrder.add(nextNativeIndex++, reader);
                    continue;
                }
                newOrder.add(reader);
            }
            this.audioFileReaders = newOrder.toArray(new AudioFileReader[num]);
        }
        if (preferNativeCodecs) {
            FormatConversionProvider[] codecs = this.formatConversionProviders;
            num = codecs.length;
            newOrder = new ArrayList(num);
            nextNativeIndex = 0;
            for (i = 0; i < num; ++i) {
                FormatConversionProvider codec = codecs[i];
                if (codec != null && this.isNativeProvider(codec.getClass())) {
                    newOrder.add(nextNativeIndex++, codec);
                    continue;
                }
                newOrder.add(codec);
            }
            this.formatConversionProviders = newOrder.toArray(new FormatConversionProvider[num]);
        }
    }

    protected boolean isNativeProvider(Class clazz) {
        return clazz.getName().startsWith(JDK13_SERVICES_PACKAGE_NAME);
    }

    public String toString() {
        AudioFileReader[] readers = this.audioFileReaders;
        int readerCount = readers == null ? 0 : readers.length;
        FormatConversionProvider[] codecs = this.formatConversionProviders;
        int codecCount = codecs == null ? 0 : codecs.length;
        return super.toString() + "[audioSystemFallback=" + this.audioSystemFallback + ", audioFileReaders=" + readerCount + ", formatConversionProviders=" + codecCount + "]";
    }

    protected void handleException(Throwable e, Object o) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Audio provider '" + o + "' failed: " + e);
        }
        if (e instanceof UnsupportedAudioFileException) {
            return;
        }
        if (e instanceof IllegalArgumentException) {
            return;
        }
        if (e instanceof Error) {
            Error err = (Error)e;
            if (err instanceof OutOfMemoryError) {
                throw err;
            }
            if (err instanceof VirtualMachineError) {
                throw err;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Audio provider '" + o + "' failed with message: " + e.getMessage());
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioFileFormat", file);
        }
        if (file == null) {
            throw new NullPointerException();
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((format = reader.getAudioFileFormat(file)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
                }
                return format;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        try {
            if (this.audioSystemFallback) {
                logger.info("Trying AudioSystem: file=" + file + ", thread=" + Thread.currentThread() + ", context=" + Thread.currentThread().getContextClassLoader());
                if (finer) {
                    logger.finer("Trying AudioSystem...");
                }
                format = AudioSystem.getAudioFileFormat(file);
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
                }
                return format;
            }
            throw new UnsupportedAudioFileException(String.valueOf(file));
        }
        catch (Throwable e) {
            logger.log(Level.INFO, e.getMessage(), e);
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            try {
                AudioFileFormat audioFileFormat = this.getAudioFileFormat(stream);
                return audioFileFormat;
            }
            finally {
                stream.close();
            }
        }
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioFileFormat", url);
        }
        if (url == null) {
            throw new NullPointerException();
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((format = reader.getAudioFileFormat(url)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
                }
                return format;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            format = AudioSystem.getAudioFileFormat(url);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
            }
            return format;
        }
        throw new UnsupportedAudioFileException(String.valueOf(url));
    }

    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat format;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioFileFormat", in);
        }
        if (in == null) {
            throw new NullPointerException();
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((format = reader.getAudioFileFormat(in)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
                }
                return format;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            format = AudioSystem.getAudioFileFormat(in);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioFileFormat", format);
            }
            return format;
        }
        throw new UnsupportedAudioFileException(String.valueOf(in));
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioInputStream", file);
        }
        if (file == null) {
            throw new NullPointerException();
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((stream = reader.getAudioInputStream(file)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
                }
                return stream;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            stream = AudioSystem.getAudioInputStream(file);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        throw new UnsupportedAudioFileException(String.valueOf(file));
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioInputStream", url);
        }
        if (url == null) {
            throw new NullPointerException();
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((stream = reader.getAudioInputStream(url)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
                }
                return stream;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            stream = AudioSystem.getAudioInputStream(url);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        throw new UnsupportedAudioFileException(String.valueOf(url));
    }

    public AudioInputStream getAudioInputStream(InputStream in) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioInputStream", in);
        }
        if (in == null) {
            throw new NullPointerException();
        }
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 32768);
        }
        for (AudioFileReader reader : this.audioFileReaders) {
            try {
                if (finer) {
                    logger.finer("Trying AudioFileReader: " + reader);
                }
                if ((stream = reader.getAudioInputStream(in)) == null) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
                }
                return stream;
            }
            catch (Throwable e) {
                this.handleException(e, reader);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            stream = AudioSystem.getAudioInputStream(in);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        throw new UnsupportedAudioFileException(String.valueOf(in));
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "isConversionSupported", new Object[]{targetFormat, sourceFormat});
        }
        if ((targetFormat = this.prepareAudioFormat(null, targetFormat, sourceFormat)) == sourceFormat) {
            return true;
        }
        for (FormatConversionProvider codec : this.formatConversionProviders) {
            try {
                if (finer) {
                    logger.finer("Trying FormatConversionProvider: " + codec);
                }
                if (!codec.isConversionSupported(targetFormat, sourceFormat)) continue;
                if (finer) {
                    logger.exiting(CLASS_NAME, "isConversionSupported", Boolean.TRUE);
                }
                return true;
            }
            catch (Throwable e) {
                this.handleException(e, codec);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            boolean result = AudioSystem.isConversionSupported(targetFormat, sourceFormat);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", result ? Boolean.TRUE : Boolean.FALSE);
            }
            return result;
        }
        return false;
    }

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "isConversionSupported", new Object[]{targetEncoding, sourceFormat});
        }
        AudioFormat targetFormat = null;
        if (this.isConversionSupported(targetFormat = this.prepareAudioFormat(targetEncoding, targetFormat, sourceFormat), sourceFormat)) {
            if (finer) {
                logger.exiting(CLASS_NAME, "isConversionSupported", Boolean.TRUE);
            }
            return true;
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            boolean result = AudioSystem.isConversionSupported(targetEncoding, sourceFormat);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", result ? Boolean.TRUE : Boolean.FALSE);
            }
            return result;
        }
        return false;
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        float targetRate;
        AudioFormat sourceFormat;
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioInputStream", new Object[]{targetFormat, sourceStream});
        }
        if ((targetFormat = this.prepareAudioFormat(null, targetFormat, sourceFormat = sourceStream.getFormat())) == sourceFormat) {
            return sourceStream;
        }
        boolean finest = logger.isLoggable(Level.FINEST);
        AudioFormat viaFormat = targetFormat;
        float sourceRate = sourceFormat.getSampleRate();
        if (sourceRate != (targetRate = targetFormat.getSampleRate()) && sourceRate > 0.0f && targetRate > 0.0f) {
            AudioFormat.Encoding sourceEncoding = sourceFormat.getEncoding();
            AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
            if (targetEncoding != null && targetEncoding != sourceEncoding && !targetEncoding.equals(sourceEncoding)) {
                float viaRate;
                AudioFormat.Encoding viaEncoding = targetEncoding;
                if (SoundUtil.PCM_FLOAT.equals(viaEncoding)) {
                    viaEncoding = SoundUtil.PCM_SIGNED;
                }
                float viaFrameRate = viaRate = sourceRate;
                int viaChannels = sourceFormat.getChannels();
                int viaBitDepth = sourceFormat.getSampleSizeInBits();
                if (viaBitDepth < 1) {
                    viaBitDepth = 16;
                }
                int viaFrameSize = viaChannels * viaBitDepth / 8;
                boolean viaEndian = targetFormat.isBigEndian();
                viaFormat = new AudioFormat(viaEncoding, viaRate, viaBitDepth, viaChannels, viaFrameSize, viaFrameRate, viaEndian);
                if (finer) {
                    logger.finer("Convert audio format: " + sourceFormat + " => " + targetFormat + " => via " + viaFormat);
                }
            }
        }
        FormatConversionProvider[] codecs = this.formatConversionProviders;
        int num = codecs.length;
        FormatConversionProvider viaCodec = null;
        for (int i = 0; i < num; ++i) {
            FormatConversionProvider codec = codecs[i];
            if (codec == viaCodec) continue;
            try {
                AudioInputStream stream;
                if (!codec.isConversionSupported(viaFormat, sourceFormat)) {
                    if (!finest) continue;
                    logger.finest("Ignored FormatConversionProvider: " + codec);
                    continue;
                }
                if (finer) {
                    logger.finer("Trying FormatConversionProvider: " + codec);
                }
                if ((stream = codec.getAudioInputStream(viaFormat, sourceStream)) == null) continue;
                if (viaFormat == targetFormat) {
                    if (finer) {
                        logger.exiting(CLASS_NAME, "getAudioInputStream codec=" + codec + ", format=" + stream.getFormat(), stream);
                    }
                    return stream;
                }
                if (finer) {
                    logger.finer("getAudioInputStream: via codec=" + codec + ", format=" + stream.getFormat());
                }
                viaCodec = codec;
                sourceFormat = viaFormat = targetFormat;
                sourceStream = stream;
                i = -1;
                continue;
            }
            catch (Throwable e) {
                this.handleException(e, codec);
            }
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            AudioInputStream stream = AudioSystem.getAudioInputStream(targetFormat, sourceStream);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetFormat + " from " + sourceStream.getFormat());
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.entering(CLASS_NAME, "getAudioInputStream", new Object[]{targetEncoding, sourceStream});
        }
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat targetFormat = null;
        AudioInputStream stream = this.getAudioInputStream(targetFormat = this.prepareAudioFormat(targetEncoding, targetFormat, sourceFormat), sourceStream);
        if (stream != null) {
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        if (this.audioSystemFallback) {
            if (finer) {
                logger.finer("Trying AudioSystem...");
            }
            stream = AudioSystem.getAudioInputStream(targetEncoding, sourceStream);
            if (finer) {
                logger.exiting(CLASS_NAME, "getAudioInputStream", stream);
            }
            return stream;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + targetEncoding + " from " + sourceStream.getFormat());
    }

    protected AudioFormat prepareAudioFormat(AudioFormat.Encoding targetEncoding, AudioFormat targetFormat, AudioFormat sourceFormat) {
        boolean bigEndian;
        int targetChannels = -1;
        int targetBits = -1;
        int targetBig = -1;
        float targetRate = -1.0f;
        boolean targetValid = false;
        if (targetFormat != null) {
            targetEncoding = targetFormat.getEncoding();
            targetChannels = targetFormat.getChannels();
            targetBits = targetFormat.getSampleSizeInBits();
            targetRate = targetFormat.getSampleRate();
            targetBig = targetFormat.isBigEndian() ? 1 : 0;
            targetValid = true;
        }
        if (targetEncoding == null) {
            targetValid = false;
            targetEncoding = sourceFormat.getEncoding();
            if (targetEncoding == null) {
                targetEncoding = DEFAULT_ENCODING;
            }
        }
        if (targetChannels < 1) {
            targetValid = false;
            targetChannels = sourceFormat.getChannels();
            if (targetChannels < 1) {
                targetChannels = 2;
            }
        }
        if (targetBits < 1) {
            targetValid = false;
            targetBits = sourceFormat.getSampleSizeInBits();
            if (targetBits != 16 && targetBits != 24 && targetBits != 32 && targetBits != 64) {
                targetBits = 16;
            }
        }
        if (targetBig < 0) {
            targetValid = false;
            int n = targetBig = sourceFormat.isBigEndian() ? 1 : 0;
        }
        if (targetRate < 1.0f) {
            targetValid = false;
            targetRate = sourceFormat.getSampleRate();
            if (targetRate < 1.0f) {
                targetRate = 44100.0f;
            }
        }
        int frameSize = targetBits / 8 * targetChannels;
        boolean bl = bigEndian = targetBig > 0;
        if (targetEncoding.equals(sourceFormat.getEncoding()) && targetChannels == sourceFormat.getChannels() && targetRate == sourceFormat.getSampleRate() && targetRate == sourceFormat.getFrameRate() && targetBits == sourceFormat.getSampleSizeInBits() && frameSize == sourceFormat.getFrameSize() && bigEndian == sourceFormat.isBigEndian()) {
            return sourceFormat;
        }
        if (targetValid && targetFormat.getFrameSize() == frameSize && targetFormat.isBigEndian() == bigEndian) {
            return targetFormat;
        }
        return new AudioFormat(targetEncoding, targetRate, targetBits, targetChannels, frameSize, targetRate, bigEndian);
    }
}

