/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound.plugin;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.Tools;
import com.spacekiller.util.sound.SoundSystem;
import com.spacekiller.util.sound.plugin.DefaultSoundSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;

public class SoundPlugin
extends Plugin {
    public static final String SOUND_PLUGIN_ID = "com.spacekiller.util.sound.plugin";
    public static final String POINT_AUDIO_FILE_READER = "javax.sound.sampled.spi.AudioFileReader";
    public static final String POINT_FORMAT_CONVERSION_PROVIDER = "javax.sound.sampled.spi.FormatConversionProvider";
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private SoundSystem soundSystem;
    private List defaultAudioFileReaders;
    private List injectedAudioFileReaders = new LinkedList();
    private List defaultFormatConversionProviders;
    private List injectedFormatConversionProviders = new LinkedList();

    protected void startup() {
        super.startup();
        if (this.logger.isLoggable(Level.FINE)) {
            SoundPlugin.dumpAudioSystem(this.logger, Level.FINE);
        }
    }

    protected void shutdown() {
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultSoundSystem createSoundSystem() {
        LinkedList<AudioFileReader> defAudioFileReaders = new LinkedList<AudioFileReader>();
        LinkedList<FormatConversionProvider> defFormatConversionProviders = new LinkedList<FormatConversionProvider>();
        DefaultSoundSystem defSystem = new DefaultSoundSystem();
        if (defSystem != null) {
            AudioFileReader[] readers = defSystem.getAudioFileReaders();
            int numReaders = readers == null ? 0 : readers.length;
            for (int i = 0; i < numReaders; ++i) {
                AudioFileReader reader = readers[i];
                if (reader == null) continue;
                defAudioFileReaders.add(reader);
            }
            FormatConversionProvider[] converters = defSystem.getFormatConversionProviders();
            int numConverters = converters == null ? 0 : converters.length;
            for (int i = 0; i < numConverters; ++i) {
                FormatConversionProvider converter = converters[i];
                if (converter == null) continue;
                defFormatConversionProviders.add(converter);
            }
        }
        List list = this.injectedAudioFileReaders;
        synchronized (list) {
            defAudioFileReaders.addAll(this.injectedAudioFileReaders);
            this.defaultAudioFileReaders = defAudioFileReaders;
        }
        list = this.injectedFormatConversionProviders;
        synchronized (list) {
            defFormatConversionProviders.addAll(this.injectedFormatConversionProviders);
            this.defaultFormatConversionProviders = defFormatConversionProviders;
        }
        return defSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundSystem getSoundSystem() {
        if (this.soundSystem == null) {
            SoundPlugin soundPlugin = this;
            synchronized (soundPlugin) {
                if (this.soundSystem == null) {
                    this.setSoundSystem(this.createSoundSystem());
                    this.applyPreferences();
                }
            }
        }
        return this.soundSystem;
    }

    protected synchronized void setSoundSystem(SoundSystem soundSystem) {
        this.soundSystem = soundSystem;
    }

    public static SoundPlugin getInstance() throws Exception {
        return (SoundPlugin)Platform.getInstance().getPlugin(SOUND_PLUGIN_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        block18: {
            try {
                String pointId = point.getId();
                if (POINT_AUDIO_FILE_READER.equals(pointId)) {
                    Object inst = this.getExtensionInstance(x);
                    if (inst == null) {
                        return;
                    }
                    if (inst instanceof AudioFileReader) {
                        AudioFileReader reader = (AudioFileReader)inst;
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("extensionAvailable: " + pointId + " = " + reader);
                        }
                        List list = this.injectedAudioFileReaders;
                        synchronized (list) {
                            this.injectedAudioFileReaders.add(reader);
                            if (this.defaultAudioFileReaders != null) {
                                this.defaultAudioFileReaders.add(reader);
                            }
                        }
                        this.applyPreferences();
                    }
                    return;
                }
                if (!POINT_FORMAT_CONVERSION_PROVIDER.equals(pointId)) break block18;
                Object inst = this.getExtensionInstance(x);
                if (inst == null) {
                    return;
                }
                if (inst instanceof FormatConversionProvider) {
                    FormatConversionProvider fcp = (FormatConversionProvider)inst;
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("extensionAvailable: " + pointId + " = " + fcp);
                    }
                    List list = this.injectedFormatConversionProviders;
                    synchronized (list) {
                        this.injectedFormatConversionProviders.add(fcp);
                        if (this.defaultFormatConversionProviders != null) {
                            this.defaultFormatConversionProviders.add(fcp);
                        }
                    }
                    this.applyPreferences();
                }
                return;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("extensionAvailable: point=" + point + ", extension=" + x);
        }
    }

    protected static void dumpAudioSystem(Logger logger, Level level) {
        try {
            logger.log(level, "============= AudioSystem =============");
            Mixer.Info[] mixers = AudioSystem.getMixerInfo();
            if (mixers != null) {
                logger.log(level, "Number of Mixers: " + mixers.length);
                for (int c = 0; c < mixers.length; ++c) {
                    int k;
                    Mixer mixer = AudioSystem.getMixer(mixers[c]);
                    Line.Info[] sourceLines = mixer.getSourceLineInfo();
                    int sourceLineCount = sourceLines.length;
                    Line.Info[] targetLines = mixer.getTargetLineInfo();
                    int targetLineCount = targetLines.length;
                    logger.log(level, " - Mixer #" + c + ": " + mixer + " / sourceLines=" + sourceLineCount + ", targetLines=" + targetLineCount);
                    Control[] mixerControls = mixer.getControls();
                    if (mixerControls != null) {
                        for (k = 0; k < mixerControls.length; ++k) {
                            logger.log(level, "   - Mixer-Control: " + mixerControls[k]);
                        }
                    }
                    for (k = 0; k < sourceLineCount; ++k) {
                        Line line = mixer.getLine(sourceLines[k]);
                        Control[] controls = line.getControls();
                        logger.log(level, "   - SourceDataLine: " + sourceLines[k] + " >> " + line + " >> Controls: " + controls.length);
                        for (int l = 0; l < controls.length; ++l) {
                            logger.log(level, "     - Control: " + controls[l].getClass().getName() + " >> " + controls[l]);
                        }
                    }
                }
            }
            logger.log(level, "=======================================");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected static void dumpSoundSystem(DefaultSoundSystem provider, Logger logger, Level level) {
        logger.log(level, "============= AudioProvider =============");
        logger.log(level, "Provider: " + provider);
        if (provider != null) {
            logger.log(level, "Provider class: " + provider.getClass().getName());
            AudioFileReader[] readers = provider.getAudioFileReaders();
            int num = readers == null ? 0 : readers.length;
            logger.log(level, "AudioFileReader(s): " + num);
            for (int i = 0; i < num; ++i) {
                AudioFileReader reader = readers[i];
                logger.log(level, " - Reader #" + i + ": " + reader);
            }
            FormatConversionProvider[] codecs = provider.getFormatConversionProviders();
            num = codecs == null ? 0 : codecs.length;
            logger.log(level, "FormatConversionProvider(s): " + num);
            for (int i = 0; i < num; ++i) {
                FormatConversionProvider codec = codecs[i];
                logger.log(level, " - Codec #" + i + ": " + codec);
            }
        }
        logger.log(level, "=======================================");
    }

    protected void applyPreferences() {
        boolean useCustomCodecs = false;
        String[] customReaderClassNames = null;
        String[] customConverterClassNames = null;
        try {
            PreferencesRegistry registry = this.getPlatform().getPreferencesRegistry();
            Preferences prefs = registry.getPreferences("platform.audio");
            if (prefs != null) {
                Object useCustom = prefs.getObject("audio.custom.codecs");
                if (useCustom != null) {
                    useCustomCodecs = "true".equalsIgnoreCase(String.valueOf(useCustom));
                }
                if (useCustomCodecs) {
                    Object converterNames;
                    Object readerNames = prefs.getObject("audio.custom.file.readers");
                    if (readerNames != null && readerNames instanceof String[]) {
                        customReaderClassNames = (String[])readerNames;
                    }
                    if ((converterNames = prefs.getObject("audio.custom.format.converters")) != null && converterNames instanceof String[]) {
                        customConverterClassNames = (String[])converterNames;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        SoundSystem system = this.soundSystem;
        if (system != null && system instanceof DefaultSoundSystem) {
            DefaultSoundSystem def = (DefaultSoundSystem)system;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Applying audio codec(s)...");
            }
            LinkedList<AudioFileReader> readerList = new LinkedList<AudioFileReader>();
            LinkedList<FormatConversionProvider> converterList = new LinkedList<FormatConversionProvider>();
            if (useCustomCodecs) {
                int numReaders = customReaderClassNames == null ? 0 : customReaderClassNames.length;
                for (int i = 0; i < numReaders; ++i) {
                    String className = customReaderClassNames[i];
                    try {
                        AudioFileReader reader = this.getAudioFileReader(className);
                        if (reader != null) {
                            readerList.add(reader);
                            continue;
                        }
                        this.logger.log(Level.WARNING, "Invalid AudioFileReader class: " + className);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                int numConverters = customConverterClassNames == null ? 0 : customConverterClassNames.length;
                for (int i = 0; i < numConverters; ++i) {
                    String className = customConverterClassNames[i];
                    try {
                        FormatConversionProvider converter = this.getFormatConversionProvider(className);
                        if (converter != null) {
                            converterList.add(converter);
                            continue;
                        }
                        this.logger.log(Level.WARNING, "Invalid FormatConversionProvider class: " + className);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            } else {
                AudioFileReader[] defReaders = this.getDefaultAudioFileReaders();
                int numReaders = defReaders == null ? 0 : defReaders.length;
                for (int i = 0; i < numReaders; ++i) {
                    AudioFileReader reader = defReaders[i];
                    if (reader == null) continue;
                    readerList.add(reader);
                }
                FormatConversionProvider[] defConverters = this.getDefaultFormatConversionProviders();
                int numConverters = defConverters == null ? 0 : defConverters.length;
                for (int i = 0; i < numConverters; ++i) {
                    FormatConversionProvider converter = defConverters[i];
                    if (converter == null) continue;
                    converterList.add(converter);
                }
            }
            AudioFileReader[] audioFileReaders = readerList.toArray(new AudioFileReader[readerList.size()]);
            FormatConversionProvider[] formatConversionProviders = converterList.toArray(new FormatConversionProvider[converterList.size()]);
            def.setAudioFileReaders(audioFileReaders);
            def.setFormatConversionProviders(formatConversionProviders);
            if (this.logger.isLoggable(Level.FINER)) {
                SoundPlugin.dumpSoundSystem(def, this.logger, Level.FINER);
            }
        }
    }

    protected AudioFileReader getAudioFileReader(String className) throws Exception {
        Object instance;
        Class<?> clazz;
        List list = this.defaultAudioFileReaders;
        if (list != null) {
            for (AudioFileReader reader : list) {
                Class<?> clazz2;
                if (reader == null || (clazz2 = reader.getClass()) == null || !className.equals(clazz2.getName())) continue;
                return reader;
            }
        }
        if (AudioFileReader.class.isAssignableFrom(clazz = Class.forName(className)) && (instance = Tools.newInstance(clazz)) instanceof AudioFileReader) {
            return (AudioFileReader)instance;
        }
        return null;
    }

    protected FormatConversionProvider getFormatConversionProvider(String className) throws Exception {
        Object instance;
        Class<?> clazz;
        List list = this.defaultFormatConversionProviders;
        if (list != null) {
            for (FormatConversionProvider provider : list) {
                Class<?> clazz2;
                if (provider == null || (clazz2 = provider.getClass()) == null || !className.equals(clazz2.getName())) continue;
                return provider;
            }
        }
        if (FormatConversionProvider.class.isAssignableFrom(clazz = Class.forName(className)) && (instance = Tools.newInstance(clazz)) instanceof FormatConversionProvider) {
            return (FormatConversionProvider)instance;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioFileReader[] getDefaultAudioFileReaders() {
        List list = this.injectedAudioFileReaders;
        synchronized (list) {
            List list2 = this.defaultAudioFileReaders;
            return list2 == null ? null : list2.toArray(new AudioFileReader[list2.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FormatConversionProvider[] getDefaultFormatConversionProviders() {
        List list = this.injectedFormatConversionProviders;
        synchronized (list) {
            List list2 = this.defaultFormatConversionProviders;
            return list2 == null ? null : list2.toArray(new FormatConversionProvider[list2.size()]);
        }
    }
}

