/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.visual;

import com.spacekiller.util.visual.ArrowStyle;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;

public abstract class AbstractArrowStyle
implements ArrowStyle {
    private Color arrowLineColor = Color.black;
    private Color arrowFill = Color.lightGray;
    private Color selectedArrowLineColor = Color.yellow;
    private Color selectedArrowFill = Color.white;
    private double arrowRadius = 20.0;
    private double arrowSquare = 0.39269908169872414;

    @Override
    public Rectangle getArrowBounds(Polygon poly) {
        Rectangle rc = new Rectangle();
        this.getArrowBounds(poly, rc);
        return rc;
    }

    @Override
    public void getArrowBounds(Polygon poly, Rectangle dst) {
        int count = poly.npoints;
        if (count < 1) {
            return;
        }
        int minX = poly.xpoints[0];
        int minY = poly.ypoints[0];
        int maxX = poly.xpoints[0];
        int maxY = poly.ypoints[0];
        for (int c = 1; c < count; ++c) {
            int y;
            int x = poly.xpoints[c];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if ((y = poly.ypoints[c]) < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        dst.x = minX;
        dst.y = minY;
        dst.width = maxX - minX + 1;
        dst.height = maxY - minY + 1;
    }

    public Color getArrowFill() {
        return this.arrowFill;
    }

    public Color getArrowLineColor() {
        return this.arrowLineColor;
    }

    @Override
    public Polygon getArrowPolygon(int x0, int y0, int x1, int y1) {
        double atan;
        double deltaX = Math.abs(x1 - x0);
        double deltaY = Math.abs(y1 - y0);
        double d = atan = deltaY == 0.0 ? 1.5707963267948966 : Math.atan(deltaX / deltaY);
        if (x1 < x0) {
            if (y1 > y0) {
                atan = Math.PI - atan;
            }
        } else {
            atan = y1 > y0 ? (atan += Math.PI) : Math.PI * 2 - atan;
        }
        int px = x1 + (int)Math.round(Math.sin(atan + this.arrowSquare) * this.arrowRadius);
        int py = y1 + (int)Math.round(Math.cos(atan + this.arrowSquare) * this.arrowRadius);
        int qx = x1 + (int)Math.round(Math.sin(atan - this.arrowSquare) * this.arrowRadius);
        int qy = y1 + (int)Math.round(Math.cos(atan - this.arrowSquare) * this.arrowRadius);
        return new Polygon(new int[]{x1, px, qx}, new int[]{y1, py, qy}, 3);
    }

    public double getArrowRadius() {
        return this.arrowRadius;
    }

    public double getArrowSquare() {
        return this.arrowSquare;
    }

    public Color getSelectedArrowFill() {
        return this.selectedArrowFill;
    }

    public Color getSelectedArrowLineColor() {
        return this.selectedArrowLineColor;
    }

    public void setArrowFill(Color newArrowFill) {
        this.arrowFill = newArrowFill;
    }

    public void setArrowLineColor(Color newArrowLineColor) {
        this.arrowLineColor = newArrowLineColor;
    }

    public void setArrowRadius(double newArrowRadius) {
        this.arrowRadius = newArrowRadius;
    }

    public void setArrowSquare(double newArrowSquare) {
        this.arrowSquare = newArrowSquare;
    }

    public void setSelectedArrowFill(Color newSelectedArrowFill) {
        this.selectedArrowFill = newSelectedArrowFill;
    }

    public void setSelectedArrowLineColor(Color newSelectedArrowLineColor) {
        this.selectedArrowLineColor = newSelectedArrowLineColor;
    }
}

