/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.visual;

import com.spacekiller.util.visual.ArrowStyle;
import com.spacekiller.util.visual.LineStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class DefaultLineStyle
implements LineStyle {
    private Color lineColor = Color.black;
    private Color selectedLineColor = Color.yellow;
    private ArrowStyle sourceArrow;
    private ArrowStyle destinationArrow;

    @Override
    public void drawLine(Graphics g, int x0, int y0, int x1, int y1, boolean selected, int lineIndex, int lineCount) {
        Polygon poly;
        ArrowStyle arrow;
        g.setColor(selected ? this.getSelectedLineColor() : this.getLineColor());
        g.drawLine(x0, y0, x1, y1);
        if (lineIndex == 0 && (arrow = this.getSourceArrow()) != null) {
            poly = arrow.getArrowPolygon(x1, y1, x0, y0);
            arrow.drawArrow(g, poly, selected);
        }
        if (lineIndex == lineCount - 1 && (arrow = this.getDestinationArrow()) != null) {
            poly = arrow.getArrowPolygon(x0, y0, x1, y1);
            arrow.drawArrow(g, poly, selected);
        }
    }

    public ArrowStyle getDestinationArrow() {
        return this.destinationArrow;
    }

    @Override
    public void getLineBounds(int x0, int y0, int x1, int y1, boolean selected, int lineIndex, int lineCount, Rectangle dst) {
        Polygon poly;
        ArrowStyle arrow;
        int minX = Math.min(x0, x1);
        int maxX = Math.max(x0, x1);
        int minY = Math.min(y0, y1);
        int maxY = Math.max(y0, y1);
        dst.x = minX;
        dst.y = minY;
        dst.width = maxX - minX + 1;
        dst.height = maxY - minY + 1;
        if (lineIndex == 0 && (arrow = this.getSourceArrow()) != null) {
            poly = arrow.getArrowPolygon(x1, y1, x0, y0);
            dst.add(arrow.getArrowBounds(poly));
        }
        if (lineIndex == lineCount - 1 && (arrow = this.getDestinationArrow()) != null) {
            poly = arrow.getArrowPolygon(x0, y0, x1, y1);
            dst.add(arrow.getArrowBounds(poly));
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getSelectedLineColor() {
        return this.selectedLineColor;
    }

    public ArrowStyle getSourceArrow() {
        return this.sourceArrow;
    }

    public void setDestinationArrow(ArrowStyle newDestinationArrow) {
        this.destinationArrow = newDestinationArrow;
    }

    public void setLineColor(Color newLineColor) {
        this.lineColor = newLineColor;
    }

    public void setSelectedLineColor(Color newSelectedLineColor) {
        this.selectedLineColor = newSelectedLineColor;
    }

    public void setSourceArrow(ArrowStyle newSourceArrow) {
        this.sourceArrow = newSourceArrow;
    }
}

