/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.visual;

import com.spacekiller.util.visual.PointStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class RectPointStyle
implements PointStyle {
    private Color background = Color.lightGray;
    private Color foreground = Color.black;
    private Color selectedBackground = Color.white;
    private Color selectedForeground = Color.black;
    private int width = 2;
    private int height = 2;

    @Override
    public void drawPoint(Graphics g, Point point, boolean selected) {
        Color col;
        Rectangle rect = this.getPointBounds(point);
        Color color = col = selected ? this.getSelectedBackground() : this.getBackground();
        if (col != null) {
            g.setColor(col);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        Color color2 = col = selected ? this.getSelectedForeground() : this.getForeground();
        if (col != null) {
            g.setColor(col);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Rectangle getPointBounds(Point point) {
        Rectangle rect = new Rectangle();
        this.getPointBounds(point, rect);
        return rect;
    }

    @Override
    public void getPointBounds(Point point, Rectangle dst) {
        dst.x = point.x - this.width;
        dst.y = point.y - this.height;
        dst.width = 1 + this.width * 2;
        dst.height = 1 + this.height * 2;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBackground(Color newBackground) {
        this.background = newBackground;
    }

    public void setForeground(Color newForeground) {
        this.foreground = newForeground;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public void setSelectedBackground(Color newSelectedBackground) {
        this.selectedBackground = newSelectedBackground;
    }

    public void setSelectedForeground(Color newSelectedForeground) {
        this.selectedForeground = newSelectedForeground;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }
}

