/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.visual;

public class VisualUtil {
    private VisualUtil() {
    }

    public static double distance(double ax, double ay, double bx, double by) {
        double gw = Math.abs(bx - ax);
        double gh = Math.abs(by - ay);
        return Math.sqrt(gw * gw + gh * gh);
    }

    public static double distance(double ax, double ay, double bx, double by, double px, double py) {
        double cy;
        double cx;
        if (ay == by) {
            cx = px;
            cy = ay;
        } else if (ax == bx) {
            cx = ax;
            cy = py;
        } else {
            double dAP = VisualUtil.distance(ax, ay, px, py);
            double dBP = VisualUtil.distance(bx, by, px, py);
            cx = ax + dAP * (bx - ax) / (dAP + dBP);
            cy = ay + dAP * (by - ay) / (dAP + dBP);
        }
        if (ax < bx) {
            if (cx < ax) {
                cx = ax;
                cy = ay;
            } else if (cx > bx) {
                cx = bx;
                cy = by;
            }
        } else if (cx < bx) {
            cx = bx;
            cy = by;
        } else if (cx > ax) {
            cx = ax;
            cy = ay;
        }
        if (ay < by) {
            if (cy < ay) {
                cx = ax;
                cy = ay;
            } else if (cy > by) {
                cx = bx;
                cy = by;
            }
        } else if (cy < by) {
            cx = bx;
            cy = by;
        } else if (cy > ay) {
            cx = ax;
            cy = ay;
        }
        return VisualUtil.distance(px, py, cx, cy);
    }
}

