/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.ScratchpadView;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusEvent;
import com.spacekiller.util.workbench.ViewFocusListener;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import java.util.logging.Logger;

public abstract class AbstractConstructorView
extends View {
    private Perspective perspective;
    private ViewFocusHandler viewFocusHandler = new ViewFocusHandler();
    private BeanObserver selectedBeanObserver;
    private static final Logger logger = Logger.getLogger(AbstractConstructorView.class.getName());

    @Override
    public synchronized void close() {
        super.close();
        this.selectedBeanObserver = null;
    }

    public BeanObserver getSelectedBeanObserver() {
        return this.selectedBeanObserver;
    }

    public void setSelectedBeanObserver(BeanObserver selectedBeanObserver) {
        this.selectedBeanObserver = selectedBeanObserver;
    }

    protected void handleViewFocusChanged(ViewFocusEvent e) {
        View view = e.getView();
        if (view == null || view == this) {
            return;
        }
        if (view instanceof BeanObserver) {
            this.setSelectedBeanObserver((BeanObserver)view);
            return;
        }
    }

    @Override
    protected synchronized void parentChanged(View oldParent, View newParent) {
        super.parentChanged(oldParent, newParent);
        Perspective newPers = this.getPerspective();
        if (newPers == this.perspective) {
            return;
        }
        if (this.perspective != null) {
            this.perspective.removeViewFocusListener(this.viewFocusHandler);
        }
        this.perspective = newPers;
        if (this.perspective != null) {
            this.perspective.addViewFocusListener(this.viewFocusHandler);
        }
    }

    protected synchronized boolean publish(Object obj) throws Exception {
        BeanObserver observer = this.selectedBeanObserver;
        logger.fine("Target: " + observer);
        if (observer != null) {
            try {
                if (observer instanceof View) {
                    ((View)observer).toFront();
                }
                if (observer.addBean(obj)) {
                    return true;
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
        ScratchpadView sv = WorkbenchExtensions.getDefaultScratchpadView(this.perspective);
        observer = sv;
        try {
            if (observer instanceof View) {
                ((View)observer).toFront();
            }
            if (observer.addBean(obj)) {
                return true;
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        logger.fine("DEBUG: failed to publish: object=" + obj + ", observer=" + observer);
        return false;
    }

    protected class ViewFocusHandler
    implements ViewFocusListener {
        protected ViewFocusHandler() {
        }

        @Override
        public void viewFocusChanged(ViewFocusEvent e) {
            AbstractConstructorView.this.handleViewFocusChanged(e);
        }
    }
}

