/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.workbench.AbstractAnimationEffect;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimationEffects {
    private AnimationEffects() {
    }

    public static class CloseFrameAnimationEffect
    extends AbstractAnimationEffect {
        private int millis = 500;
        private int delay = 1;

        public CloseFrameAnimationEffect(int millis, int delay) {
            this.millis = millis;
            this.delay = delay;
        }

        @Override
        public void animate(JComponent component) {
            Container parent = component.getParent();
            if (parent == null) {
                return;
            }
            Rectangle bounds = component.getBounds();
            parent.remove(component);
            Window window = SwingUtilities.getWindowAncestor(parent);
            if (window == null) {
                return;
            }
            RootPaneContainer rootPane = null;
            if (window instanceof RootPaneContainer) {
                rootPane = (RootPaneContainer)((Object)window);
            }
            if (rootPane == null) {
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(parent, bounds.x, bounds.y, layeredPane);
            BufferedImage image = this.createImageOfComponent(component);
            component.setBounds(bounds);
            Rectangle srcBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
            Rectangle dstBounds = new Rectangle(point.x + bounds.width / 2, point.y + bounds.height / 2, 0, 0);
            ZoomAnimation zoom = new ZoomAnimation(layeredPane, srcBounds, dstBounds, image, this.millis, this.delay);
            zoom.start();
        }
    }

    public static class DeiconifyFrameAnimationEffect
    extends AbstractAnimationEffect {
        private int millis = 500;
        private int delay = 1;

        public DeiconifyFrameAnimationEffect(int millis, int delay) {
            this.millis = millis;
            this.delay = delay;
        }

        @Override
        public void animate(JComponent component) {
            System.out.println("" + this + ".animate: " + component);
            JDesktopPane parent = null;
            JInternalFrame internalFrame = null;
            if (component instanceof JInternalFrame) {
                internalFrame = (JInternalFrame)component;
                parent = internalFrame.getDesktopPane();
            }
            if (parent == null) {
                return;
            }
            Rectangle bounds = component.getBounds();
            JInternalFrame.JDesktopIcon desktopIcon = internalFrame.getDesktopIcon();
            parent.remove(component);
            Window window = SwingUtilities.getWindowAncestor(parent);
            if (window == null) {
                return;
            }
            RootPaneContainer rootPane = null;
            if (window instanceof RootPaneContainer) {
                rootPane = (RootPaneContainer)((Object)window);
            }
            if (rootPane == null) {
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(parent, bounds.x, bounds.y, layeredPane);
            BufferedImage image = this.createImageOfComponent(component);
            component.setBounds(bounds);
            Rectangle dstBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
            Rectangle srcBounds = null;
            if (desktopIcon != null) {
                Rectangle r = desktopIcon.getBounds();
                srcBounds = new Rectangle(point.x - bounds.x + r.x + r.width / 2, point.y - bounds.y + r.y + r.height / 2, 0, 0);
            }
            if (dstBounds == null) {
                srcBounds = new Rectangle(point.x + bounds.width / 2, point.y + bounds.height / 2, 0, 0);
            }
            if (desktopIcon != null) {
                parent.remove(desktopIcon);
                parent.repaint(desktopIcon.getBounds());
            }
            final JInternalFrame finalFrame = internalFrame;
            final JDesktopPane finalDesktop = parent;
            ZoomAnimation zoom = new ZoomAnimation(layeredPane, srcBounds, dstBounds, image, this.millis, this.delay){

                @Override
                protected void finish() {
                    super.finish();
                    finalDesktop.add(finalFrame);
                    try {
                        finalFrame.setSelected(true);
                        finalFrame.toFront();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            zoom.start();
        }
    }

    public static class IconifyFrameAnimationEffect
    extends AbstractAnimationEffect {
        private int millis = 500;
        private int delay = 1;

        public IconifyFrameAnimationEffect(int millis, int delay) {
            this.millis = millis;
            this.delay = delay;
        }

        @Override
        public void animate(JComponent component) {
            Container parent = component.getParent();
            if (parent == null) {
                return;
            }
            Rectangle bounds = component.getBounds();
            JInternalFrame.JDesktopIcon desktopIcon = null;
            if (component instanceof JInternalFrame) {
                JInternalFrame internalFrame = (JInternalFrame)component;
                desktopIcon = internalFrame.getDesktopIcon();
            }
            parent.remove(component);
            Window window = SwingUtilities.getWindowAncestor(parent);
            if (window == null) {
                return;
            }
            RootPaneContainer rootPane = null;
            if (window instanceof RootPaneContainer) {
                rootPane = (RootPaneContainer)((Object)window);
            }
            if (rootPane == null) {
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(parent, bounds.x, bounds.y, layeredPane);
            BufferedImage image = this.createImageOfComponent(component);
            component.setBounds(bounds);
            Rectangle srcBounds = new Rectangle(point.x, point.y, bounds.width, bounds.height);
            Rectangle dstBounds = null;
            if (desktopIcon != null) {
                Rectangle r = desktopIcon.getBounds();
                dstBounds = new Rectangle(point.x - bounds.x + r.x + r.width / 2, point.y - bounds.y + r.y + r.height / 2, 0, 0);
            }
            if (dstBounds == null) {
                dstBounds = new Rectangle(point.x + bounds.width / 2, point.y + bounds.height / 2, 0, 0);
            }
            ZoomAnimation zoom = new ZoomAnimation(layeredPane, srcBounds, dstBounds, image, this.millis, this.delay);
            zoom.start();
        }
    }

    protected static class AnimationComponent
    extends JComponent {
        private static final long serialVersionUID = -5522381397296826887L;
        private Image image;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.image != null) {
                int imageWidth = this.image.getWidth(null);
                int imageHeight = this.image.getHeight(null);
                int sx1 = 0;
                int sy1 = 0;
                int sx2 = imageWidth;
                int sy2 = imageHeight;
                int dx1 = 0;
                int dy1 = 0;
                int dx2 = width;
                int dy2 = height;
                g.drawImage(this.image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
            }
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }
    }

    protected static class ZoomAnimation
    implements ActionListener {
        private JLayeredPane layeredPane;
        private long startMillis;
        private long totalMillis;
        private Rectangle startBounds;
        private Rectangle endBounds;
        private Image image;
        private AnimationComponent animationComponent;
        private Timer timer;
        private double prevFactor;

        public ZoomAnimation(JLayeredPane layeredPane, Rectangle srcBounds, Rectangle dstBounds, Image image, int millis, int delay) {
            this.layeredPane = layeredPane;
            this.image = image;
            this.startBounds = srcBounds;
            this.endBounds = dstBounds;
            this.totalMillis = millis;
            this.timer = new Timer(delay, this);
        }

        public void start() {
            this.animationComponent = new AnimationComponent();
            this.animationComponent.setBounds(this.startBounds);
            this.animationComponent.setImage(this.image);
            this.layeredPane.add(this.animationComponent);
            this.layeredPane.setLayer(this.animationComponent, JLayeredPane.POPUP_LAYER);
            this.layeredPane.validate();
            this.layeredPane.repaint(this.startBounds);
            this.startMillis = 0L;
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long ms;
            if (this.startMillis == 0L) {
                this.startMillis = System.currentTimeMillis();
                ms = 0L;
            } else {
                ms = System.currentTimeMillis() - this.startMillis;
                if (ms < 0L) {
                    ms = 0L;
                }
            }
            double msFactor = (double)ms / (double)this.totalMillis;
            if (msFactor >= 1.0) {
                msFactor = 1.0;
                if (this.prevFactor >= 1.0) {
                    this.timer.stop();
                    this.layeredPane.remove(this.animationComponent);
                    this.layeredPane.repaint(this.animationComponent.getBounds());
                    this.animationComponent.setImage(null);
                    this.finish();
                    return;
                }
            }
            this.prevFactor = msFactor;
            double endFactor = msFactor;
            double startFactor = 1.0 - endFactor;
            int newX = (int)Math.round((double)this.startBounds.x * startFactor + (double)this.endBounds.x * endFactor);
            int newY = (int)Math.round((double)this.startBounds.y * startFactor + (double)this.endBounds.y * endFactor);
            int newW = (int)Math.round((double)this.startBounds.width * startFactor + (double)this.endBounds.width * endFactor);
            int newH = (int)Math.round((double)this.startBounds.height * startFactor + (double)this.endBounds.height * endFactor);
            this.animationComponent.setBounds(newX, newY, newW, newH);
        }

        protected void finish() {
        }
    }
}

