/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.NewArrayPanel;
import com.spacekiller.util.workbench.AbstractConstructorView;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayConstructorView
extends AbstractConstructorView {
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private NewArrayPanel newArrayPanel;
    private Filter classFilter;
    private int emptySearchAction = ClassChooser.EMPTY_DO_NOTHING;
    private Filter internalFilter;
    private static final Logger logger = Logger.getLogger(ArrayConstructorView.class.getName());

    @Override
    protected Component createComponent() {
        return this.getNewArrayPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected NewArrayPanel createNewArrayPanel() {
        NewArrayPanel panel = new NewArrayPanel();
        panel.setBeansToolkit(this.beansToolkit);
        panel.setClassRegistry(this.classRegistry);
        Object newFilter = this.internalFilter = panel.getClassFilter();
        if (this.classFilter != null) {
            newFilter = newFilter == null ? this.classFilter : new ClassChooser.MultiClassFilter(new Filter[]{this.internalFilter, this.classFilter});
        }
        panel.setClassFilter(newFilter);
        panel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayConstructorView.this.actionCreate();
            }
        });
        return panel;
    }

    public NewArrayPanel getNewArrayPanel() {
        if (this.newArrayPanel == null) {
            this.setNewArrayPanel(this.createNewArrayPanel());
        }
        return this.newArrayPanel;
    }

    protected void setNewArrayPanel(NewArrayPanel newObjectPanel) {
        this.newArrayPanel = newObjectPanel;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    protected void actionCreate() {
        try {
            NewArrayPanel panel = this.getNewArrayPanel();
            Class compType = panel.getArrayComponentType();
            int length = panel.getArrayLength();
            int dimensions = panel.getArrayDimensions();
            Object obj = null;
            if (dimensions < 2) {
                obj = Array.newInstance(compType, length);
            } else {
                int[] dims = new int[dimensions];
                dims[0] = length;
                obj = Array.newInstance(compType, dims);
            }
            logger.fine("Insert array object: " + obj);
            if (obj != null) {
                this.publish(obj);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
    }

    public int getEmptySearchAction() {
        return this.emptySearchAction;
    }

    public void setEmptySearchAction(int emptySearchAction) {
        this.emptySearchAction = emptySearchAction;
    }
}

