/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.AbstractSelection;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.beans.ClipSource;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultBeanContext;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.components.BeanTree;
import com.spacekiller.util.beans.components.BeanTreeCellRenderer;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.beans.model.DefaultBeanTreeModel;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.AbstractSelectionManager;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.SelectionToolContext;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusCondition;
import com.spacekiller.util.workbench.ViewToolContext;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.beancontext.BeanContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class BeanTreeView
extends View
implements BeanObserver,
Selectable {
    private BeansToolkit beansToolkit;
    private FeatureDescriptorFilter featureDescriptorFilter;
    private BeanContext rootContext;
    private DefaultBeanTreeModel defaultBeanTreeModel;
    private BeanTree beanTree;
    private BeanTreeSelection beanContextTreeSelection;
    private BeanTreeComparator beanTreeComparator;
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private BeanDropSupport beanDropSupport;
    private ToolGroup popupMenuToolGroup;
    private TreeWillExpandHandler treeWillExpandHandler = new TreeWillExpandHandler();
    private TreeExpansionHandler treeExpansionHandler = new TreeExpansionHandler();
    private TreeSelectionHandler treeSelectionHandler = new TreeSelectionHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private BeanTreeToolContextImpl beanTreeToolContext = new BeanTreeToolContextImpl();
    private SelectionManager selectionManager;
    private static final Logger logger = Logger.getLogger(BeanTreeView.class.getName());

    public BeanTreeView() {
        this.initBeanTreeView();
    }

    public void addTreeMouseListener(MouseListener l) {
        this.getBeanTree().addMouseListener(l);
    }

    protected BeanTreeSelection createBeanContextTreeSelection() {
        return new BeanTreeSelection();
    }

    protected BeanTree createBeanTree() {
        BeanTree beanTree = new BeanTree();
        beanTree.setOpaque(false);
        beanTree.setEditable(false);
        beanTree.setRootVisible(false);
        beanTree.setShowsRootHandles(true);
        beanTree.setCellRenderer((TreeCellRenderer)new BeanTreeCellRenderer(this.getBeansToolkit(), beanTree, this.getRootContext()));
        ToolTipManager.sharedInstance().registerComponent((JComponent)beanTree);
        beanTree.addMouseListener((MouseListener)this.mouseHandler);
        beanTree.addTreeSelectionListener((TreeSelectionListener)this.treeSelectionHandler);
        try {
            beanTree.addTreeWillExpandListener((TreeWillExpandListener)this.treeWillExpandHandler);
            beanTree.addTreeExpansionListener((TreeExpansionListener)this.treeExpansionHandler);
        }
        catch (Exception e) {
            logger.fine("" + e);
        }
        DropTarget dt = new DropTarget((Component)beanTree, this.dropTargetHandler);
        beanTree.setDropTarget(dt);
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer((Component)beanTree, actions, this.dragGestureHandler);
        dgr.getComponent();
        return beanTree;
    }

    @Override
    protected Component createComponent() {
        this.getBeanTree().setModel((TreeModel)this.getDefaultBeanTreeModel());
        JScrollPane scrollPane = new JScrollPane((Component)this.getBeanTree());
        scrollPane.setOpaque(false);
        scrollPane.setMinimumSize(new Dimension(100, 100));
        scrollPane.setPreferredSize(new Dimension(150, 150));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.add(scrollPane);
        return panel;
    }

    protected DefaultBeanTreeModel createDefaultBeanTreeModel() {
        BeanContext ctx = this.getRootContext();
        BeansToolkit btk = this.getBeansToolkit();
        FeatureDescriptorFilter filter = this.getFeatureDescriptorFilter();
        BeanTreeComparator comp = this.getBeanTreeComparator();
        DefaultBeanTreeModel model = new DefaultBeanTreeModel(btk, filter);
        model.setBeanTreeComparator(comp);
        model.setRootBean((Object)ctx);
        return model;
    }

    public Object getBeanAt(TreePath path) {
        BeansToolkit btk = this.getBeansToolkit();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof BeanTreeNode) {
            BeanTreeNode beanNode = (BeanTreeNode)node;
            FeatureDescriptor feature = beanNode.getFeatureDescriptor();
            Object bean = beanNode.getBean();
            if (feature != null && bean != null) {
                if (feature instanceof BeanDescriptor) {
                    return bean;
                }
                if (feature instanceof PropertyDescriptor) {
                    try {
                        return btk.getValue((PropertyDescriptor)feature, bean);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
        }
        return null;
    }

    protected BeanTreeSelection getBeanContextTreeSelection() {
        if (this.beanContextTreeSelection == null) {
            this.setBeanContextTreeSelection(this.createBeanContextTreeSelection());
        }
        return this.beanContextTreeSelection;
    }

    public Selection getBeanSelection() {
        return this.getBeanContextTreeSelection();
    }

    public Selection getSelection() {
        return this.getBeanContextTreeSelection();
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    protected BeanTree getBeanTree() {
        if (this.beanTree == null) {
            this.setBeanTree(this.createBeanTree());
        }
        return this.beanTree;
    }

    public BeanTreeComparator getBeanTreeComparator() {
        return this.beanTreeComparator;
    }

    protected DefaultBeanTreeModel getDefaultBeanTreeModel() {
        if (this.defaultBeanTreeModel == null) {
            this.setDefaultBeanTreeModel(this.createDefaultBeanTreeModel());
        }
        return this.defaultBeanTreeModel;
    }

    public FeatureDescriptorFilter getFeatureDescriptorFilter() {
        return this.featureDescriptorFilter;
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.getBeanTree().getPathForLocation(x, y);
    }

    public BeanContext getRootContext() {
        return this.rootContext;
    }

    protected TreePath getTreePath(Object bean) {
        BeanTreeNode node = this.getDefaultBeanTreeModel().findNode(bean);
        if (node != null) {
            return new TreePath(this.getDefaultBeanTreeModel().getPathToRoot((TreeNode)node));
        }
        return null;
    }

    protected void handleMouseClick(MouseEvent ev) {
        TreePath path;
        if (ev.getClickCount() == 2 && (path = this.getBeanTree().getPathForLocation(ev.getX(), ev.getY())) != null) {
            logger.fine("OPEN properties: expanded=" + this.getBeanTree().isExpanded(path));
            ev.consume();
        }
    }

    protected void initBeanTreeView() {
        this.setName("BeanTreeView");
        this.setTitle("Beans");
        this.setTooltip("Bean tree");
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    public void removeTreeMouseListener(MouseListener l) {
        this.getBeanTree().removeMouseListener(l);
    }

    protected void setBeanContextTreeSelection(BeanTreeSelection newBeanContextTreeSelection) {
        this.beanContextTreeSelection = newBeanContextTreeSelection;
    }

    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    protected void setBeanTree(BeanTree newBeanTree) {
        this.beanTree = newBeanTree;
    }

    public void setBeanTreeComparator(BeanTreeComparator newBeanTreeComparator) {
        this.beanTreeComparator = newBeanTreeComparator;
    }

    protected void setDefaultBeanTreeModel(DefaultBeanTreeModel newDefaultBeanTreeModel) {
        this.defaultBeanTreeModel = newDefaultBeanTreeModel;
    }

    public void setFeatureDescriptorFilter(FeatureDescriptorFilter newFeatureDescriptorFilter) {
        this.featureDescriptorFilter = newFeatureDescriptorFilter;
    }

    public void setRootContext(BeanContext newRootContext) {
        this.rootContext = newRootContext;
        this.getDefaultBeanTreeModel().setRootBean((Object)newRootContext);
    }

    protected void showContextPopupMenu(int x, int y) {
        this.getComponent().requestFocus();
        TreePath path = this.getBeanTree().getPathForLocation(x, y);
        if (path != null) {
            if (!this.getBeanTree().isPathSelected(path)) {
                this.getBeanTree().setSelectionPath(path);
            }
        } else {
            this.getBeanTree().clearSelection();
        }
        ToolGroup group = this.getPopupMenuToolGroup();
        logger.fine("PopupMenuToolGroup: " + group);
        if (group != null) {
            BeanTreeToolContextImpl ctx;
            Object instance;
            int num = group.getChildCount();
            logger.fine("PopupMenu-Tools: " + num);
            if (num > 0 && (instance = group.createInstance((ToolContext)(ctx = this.beanTreeToolContext), JPopupMenu.class)) != null && instance instanceof JPopupMenu) {
                JPopupMenu menu = (JPopupMenu)instance;
                menu.show((Component)this.getBeanTree(), x, y);
            }
        }
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    @Override
    public void refresh() {
        if (this.beanTree != null) {
            this.beanTree.refresh();
        }
        super.refresh();
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        TreePath treePath = this.getBeanTree().getPathForLocation(x, y);
        if (treePath != null) {
            BeanTreeNode btn;
            Object bean;
            Object treeNode = treePath.getLastPathComponent();
            if (treeNode != null && treeNode instanceof BeanTreeNode && (bean = (btn = (BeanTreeNode)treeNode).getBean()) != null && bean instanceof BeanContext) {
                return (BeanContext)bean;
            }
            return null;
        }
        return this.rootContext;
    }

    private String getDragActionString(int action) {
        String s = "";
        if ((action & 1) != 0) {
            s = s + "copy ";
        }
        if ((action & 2) != 0) {
            s = s + "move ";
        }
        if ((action & 0x40000000) != 0) {
            s = s + "link ";
        }
        return s;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public ToolGroup getPopupMenuToolGroup() {
        return this.popupMenuToolGroup;
    }

    public void setPopupMenuToolGroup(ToolGroup popupMenuToolGroup) {
        this.popupMenuToolGroup = popupMenuToolGroup;
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.beanTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.beanTree);
            this.beanTree.removeMouseListener((MouseListener)this.mouseHandler);
            this.beanTree.removeTreeSelectionListener((TreeSelectionListener)this.treeSelectionHandler);
            try {
                this.beanTree.removeTreeWillExpandListener((TreeWillExpandListener)this.treeWillExpandHandler);
                this.beanTree.removeTreeExpansionListener((TreeExpansionListener)this.treeExpansionHandler);
            }
            catch (Exception e) {
                logger.fine("" + e);
            }
            this.setRootContext((BeanContext)new DefaultBeanContext());
            this.beanTree = null;
        }
        if (this.defaultBeanTreeModel != null) {
            this.defaultBeanTreeModel.removeAllBeans();
            this.defaultBeanTreeModel = null;
        }
        logger.fine("close: " + this);
    }

    @Override
    protected void finalize() throws Throwable {
        logger.fine("finalize: " + this);
        super.finalize();
    }

    public boolean addBean(Object o) throws Exception {
        if (o != null) {
            BeanContext root;
            Selection sel = this.getBeanSelection();
            if (sel != null) {
                int num = sel.getSelectedObjectCount();
                if (num == 1) {
                    Object target = sel.getSelectedObjectAt(0);
                    if (target != null && target instanceof Collection) {
                        Collection coll = (Collection)target;
                        return this.addBean(o, coll);
                    }
                    return false;
                }
                if (num > 1) {
                    return false;
                }
            }
            if ((root = this.getRootContext()) != null) {
                return this.addBean(o, root);
            }
        }
        return false;
    }

    protected boolean addBean(Object o, Collection target) throws Exception {
        if (target.add(o)) {
            UndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                undoManager.addEdit(new AddObjectEdit(target, o));
            }
            return true;
        }
        return false;
    }

    protected void openSelectedObjects() {
        try {
            Perspective pers = this.getPerspective();
            if (pers == null) {
                return;
            }
            Workbench wb = pers.getWorkbench();
            if (wb == null) {
                return;
            }
            Selection sel = this.getSelection();
            if (sel == null) {
                return;
            }
            ArrayList array = new ArrayList();
            sel.getSelectedObjects(array);
            if (array.isEmpty()) {
                return;
            }
            WorkbenchExtensions.actionObjectOpen(wb, array);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected RemoveEdit removeBeanAtPath(TreePath path) {
        int pathCount = path.getPathCount();
        if (pathCount < 2) {
            return null;
        }
        Object child = path.getLastPathComponent();
        if (child == null) {
            return null;
        }
        if (!(child instanceof BeanTreeNode)) {
            return null;
        }
        BeanTreeNode childNode = (BeanTreeNode)child;
        Object bean = childNode.getBean();
        if (bean == null) {
            return null;
        }
        Object parent = path.getPathComponent(pathCount - 2);
        if (parent == null) {
            return null;
        }
        if (parent instanceof BeanTreeNode) {
            BeanTreeNode parentNode = (BeanTreeNode)parent;
            Object parentBean = parentNode.getBean();
            if (parentBean == null) {
                return null;
            }
            if (parentBean instanceof FileContext) {
                throw new UnsupportedOperationException("TODO remove file: " + bean);
            }
            if (parentBean instanceof BeanContext) {
                BeanContext bc = (BeanContext)parentBean;
                if (bc.remove(bean)) {
                    return new RemoveEdit(bc, bean);
                }
                return null;
            }
            if (parentBean instanceof Collection) {
                Collection coll = (Collection)parentBean;
                if (coll.remove(bean)) {
                    return new RemoveEdit(coll, bean);
                }
                return null;
            }
            logger.fine("DEBUG: unsupported parent object: " + parent + " >> " + parent.getClass());
        }
        return null;
    }

    protected SelectionManager createSelectionManager() {
        SelectionManagerImpl impl = new SelectionManagerImpl();
        impl.setSelection(this.getSelection());
        return impl;
    }

    public SelectionManager getSelectionManager() {
        if (this.selectionManager == null) {
            this.setSelectionManager(this.createSelectionManager());
        }
        return this.selectionManager;
    }

    private void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public void setSelectedObject(Object object) throws Exception {
        BeanTree tree = this.getBeanTree();
        TreePath path = null;
        if (object != null) {
            path = this.getTreePath(object);
        }
        logger.fine("DEBUG: setSelectedObject: object=" + object + " => path=" + path);
        tree.setSelectionPath(path);
    }

    public void setSelectedObjects(Object[] objects) throws Exception {
        BeanTree tree = this.getBeanTree();
        TreePath[] paths = new TreePath[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            paths[i] = this.getTreePath(obj);
        }
        tree.setSelectionPaths(paths);
    }

    protected class RemoveEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -9042306443792891805L;
        private Collection target;
        private Object bean;

        public RemoveEdit(Collection target, Object bean) {
            this.target = target;
            this.bean = bean;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.target.add(this.bean);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.target.remove(this.bean);
        }
    }

    protected class PasteEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -7653548876674319412L;
        private BeanContext target;
        private Collection beans;

        public PasteEdit(BeanContext target, Collection beans) {
            this.target = target;
            this.beans = beans;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            for (Object o : this.beans) {
                if (o == null) continue;
                this.target.remove(o);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (Object o : this.beans) {
                if (o == null) continue;
                this.target.add(o);
            }
        }
    }

    protected class AddObjectEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -4147761927095136004L;
        private Collection target;
        private Object bean;

        public AddObjectEdit(Collection target, Object bean) {
            this.target = target;
            this.bean = bean;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.target.remove(this.bean);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.target.add(this.bean);
        }
    }

    protected class SelectionManagerImpl
    extends AbstractSelectionManager {
        protected SelectionManagerImpl() {
        }

        @Override
        public View getView() {
            return BeanTreeView.this;
        }

        @Override
        public Perspective getPerspective() {
            return BeanTreeView.this.getPerspective();
        }

        @Override
        public Workbench getWorkbench() {
            return this.getPerspective().getWorkbench();
        }

        @Override
        public void addViewFocusCondition(ViewFocusCondition condition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeViewFocusCondition(ViewFocusCondition condition) {
        }
    }

    protected class BeanTreeToolContextImpl
    extends AbstractToolContext
    implements ViewToolContext,
    SelectionToolContext {
        protected BeanTreeToolContextImpl() {
        }

        @Override
        public View getView() {
            return BeanTreeView.this;
        }

        @Override
        public Perspective getPerspective() {
            return BeanTreeView.this.getPerspective();
        }

        @Override
        public Workbench getWorkbench() {
            return this.getPerspective().getWorkbench();
        }

        @Override
        public SelectionManager getSelectionManager() {
            return BeanTreeView.this.getSelectionManager();
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clicks = e.getClickCount();
            if (clicks == 2) {
                BeanTreeView.this.openSelectedObjects();
            }
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                BeanTreeView.this.showContextPopupMenu(ev.getX(), ev.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                BeanTreeView.this.showContextPopupMenu(ev.getX(), ev.getY());
            }
        }
    }

    protected class TreeSelectionHandler
    implements TreeSelectionListener {
        protected TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            BeanTreeView.this.getBeanContextTreeSelection().handleSelectionModelValueChanged(e);
        }
    }

    protected class TreeExpansionHandler
    implements TreeExpansionListener {
        protected TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (BeanTreeView.this.beanTree != null) {
                BeanTreeView.this.beanTree.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    protected class TreeWillExpandHandler
    implements TreeWillExpandListener {
        protected TreeWillExpandHandler() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            Cursor wait;
            if (BeanTreeView.this.beanTree != null && (wait = Cursor.getPredefinedCursor(3)) != null) {
                BeanTreeView.this.beanTree.setCursor(wait);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath[] paths = BeanTreeView.this.getBeanTree().getSelectionPaths();
            if (paths == null) {
                return;
            }
            if (paths.length < 1) {
                return;
            }
            ArrayList<Object> beans = new ArrayList<Object>();
            for (int c = 0; c < paths.length; ++c) {
                BeanTreeNode beanNode;
                Object bean;
                Object node = paths[c].getLastPathComponent();
                if (node == null || !(node instanceof BeanTreeNode) || (bean = (beanNode = (BeanTreeNode)node).getBean()) == null) continue;
                beans.add(bean);
            }
            if (beans.isEmpty()) {
                return;
            }
            BeanTreeView.this.dragSourceHandler.setBeanDropSupport(BeanTreeView.this.getBeanDropSupport());
            BeanTreeView.this.dragSourceHandler.startDrag(dge, beans);
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (BeanTreeView.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = BeanTreeView.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            BeanTreeView.this.beanDropSupport.enumerateDropBeans(target, dtde, this.dropBeans);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (BeanTreeView.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = BeanTreeView.this.getTargetBeanContext(pos.x, pos.y);
            ArrayList temp = new ArrayList();
            boolean searchSuccess = BeanTreeView.this.beanDropSupport.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !BeanTreeView.this.beanDropSupport.acceptDropBean(target, o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (BeanTreeView.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Sys.println((String)(" - Drop action: " + BeanTreeView.this.getDragActionString(dropAction)));
            Point pos = dtde.getLocation();
            BeanContext target = BeanTreeView.this.getTargetBeanContext(pos.x, pos.y);
            Sys.println((String)(" - Drop target context: " + target));
            ArrayList temp = new ArrayList();
            boolean enumSuccess = BeanTreeView.this.beanDropSupport.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        BeanTreeView.this.beanDropSupport.dropBeans(this.dropBeans, target, dropAction);
                        BeanTreeView.this.getUndoManager().addEdit(new PasteEdit(target, this.dropBeans));
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        BeanTreeView.this.handleException(e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }

    protected class ClipSourceImpl
    implements ClipSource {
        private int clipAction;
        private Map map;

        public ClipSourceImpl(int clipAction, Map mapBean2Path) {
            this.clipAction = clipAction;
            this.map = mapBean2Path;
        }

        public int getClipAction() {
            return this.clipAction;
        }

        public boolean isClipActionSupported(int action) {
            return action == this.clipAction;
        }

        public void objectTransferred(Object object, int action) {
            if (this.clipAction == 1 && action == 1) {
                TreePath path = (TreePath)this.map.get(object);
                if (path == null) {
                    return;
                }
                RemoveEdit edit = BeanTreeView.this.removeBeanAtPath(path);
                if (edit != null) {
                    BeanTreeView.this.getUndoManager().addEdit(edit);
                }
                this.map.remove(object);
            }
        }
    }

    public class BeanTreeSelection
    extends AbstractSelection {
        private List selectionPaths;

        public BeanTreeSelection() {
            super((Object)BeanTreeView.this);
            this.selectionPaths = new ArrayList();
        }

        public TreePath getSelectionPathAt(int i) {
            return (TreePath)this.selectionPaths.get(i);
        }

        protected synchronized void handleSelectionModelValueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            if (paths != null) {
                int count = paths.length;
                for (int c = 0; c < count; ++c) {
                    int x;
                    Object bean = BeanTreeView.this.getBeanAt(paths[c]);
                    if (bean == null) continue;
                    if (e.isAddedPath(paths[c])) {
                        x = this.getSelectedObjectCount();
                        this.selectionPaths.add(x, paths[c]);
                        this.insertSelectedObjectAt(bean, x);
                        continue;
                    }
                    x = this.getSelectedObjectIndex(bean);
                    if (x < 0) continue;
                    this.selectionPaths.remove(x);
                    this.removeSelectedObjectAt(x);
                }
            }
        }

        public int removeSelectedObjects() {
            int num = this.getSelectionCount();
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            for (int c = 0; c < num; ++c) {
                TreePath path = this.getSelectionPathAt(c);
                if (path == null) continue;
                list.add(path);
            }
            CompoundEdit edits = new CompoundEdit();
            int rc = 0;
            for (TreePath path : list) {
                RemoveEdit edit = BeanTreeView.this.removeBeanAtPath(path);
                if (edit == null) continue;
                ++rc;
                edits.addEdit(edit);
            }
            edits.end();
            BeanTreeView.this.getUndoManager().addEdit(edits);
            return rc;
        }

        public int copySelectedObjects() {
            return this.clipSelectedObjects(2);
        }

        public int cutSelectedObjects() {
            int num = this.clipSelectedObjects(1);
            BeanTreeView.this.refresh();
            return num;
        }

        protected int clipSelectedObjects(int action) {
            Perspective pers = BeanTreeView.this.getPerspective();
            if (pers == null) {
                return 0;
            }
            Workbench wb = pers.getWorkbench();
            if (wb == null) {
                return 0;
            }
            ClipboardManager cm = wb.getClipboardManager();
            if (cm == null) {
                return 0;
            }
            ArrayList<Object> beans = new ArrayList<Object>();
            IdentityHashMap<Object, TreePath> mapBean2Path = new IdentityHashMap<Object, TreePath>();
            int num = this.getSelectionCount();
            for (int c = 0; c < num; ++c) {
                BeanTreeNode childNode;
                Object bean;
                Object child;
                int pathCount;
                TreePath path = this.getSelectionPathAt(c);
                if (path == null || (pathCount = path.getPathCount()) < 2 || (child = path.getLastPathComponent()) == null || !(child instanceof BeanTreeNode) || (bean = (childNode = (BeanTreeNode)child).getBean()) == null) continue;
                beans.add(bean);
                mapBean2Path.put(bean, path);
            }
            if (beans.isEmpty()) {
                return 0;
            }
            ClipboardOwner owner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    BeanTreeView.this.refresh();
                }
            };
            int clipAction = action;
            ClipSourceImpl source = new ClipSourceImpl(clipAction, mapBean2Path);
            int rc = beans.size();
            cm.setContents(beans, owner, (ClipSource)source);
            return rc;
        }

        public boolean isPasteSupported() {
            return true;
        }

        public int pasteObjects() {
            int rc = 0;
            try {
                Sys.println((String)"paste objects..");
                Sys.println((String)("View: " + BeanTreeView.this));
                Sys.println((String)("Parent: " + BeanTreeView.this.getParent()));
                Perspective pers = BeanTreeView.this.getPerspective();
                if (pers == null) {
                    return rc;
                }
                Workbench wb = pers.getWorkbench();
                if (wb == null) {
                    return rc;
                }
                ClipboardManager cm = wb.getClipboardManager();
                if (cm == null) {
                    return rc;
                }
                Collection beans = cm.getObjects();
                if (beans == null) {
                    return rc;
                }
                int action = cm.getClipAction();
                for (Object o : beans) {
                    if (o == null) continue;
                    if (BeanTreeView.this.addBean(o)) {
                        cm.objectTransferred(o, action);
                        ++rc;
                        continue;
                    }
                    Sys.println((String)("DEBUG: bean rejected: " + o));
                }
                return rc;
            }
            catch (Exception e) {
                BeanTreeView.this.handleException(e);
                return rc;
            }
        }
    }
}

