/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.beans.ClipboardListener;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.workbench.ClipboardPanel;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;

public class ClipboardView
extends View {
    private ClipboardPanel panel;
    private ClipboardManager manager;
    private BeansToolkit beansToolkit;
    private ClipboardHandler clipboardHandler = new ClipboardHandler();

    @Override
    protected Component createComponent() {
        return this.getPanel();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected ClipboardPanel createPanel() {
        ClipboardPanel cp = new ClipboardPanel();
        cp.setBeansToolkit(this.getBeansToolkit());
        cp.setClipManager(this.getManager());
        cp.setPreferredSize(new Dimension(400, 300));
        return cp;
    }

    protected ClipboardPanel getPanel() {
        if (this.panel == null) {
            this.setPanel(this.createPanel());
        }
        return this.panel;
    }

    protected void setPanel(ClipboardPanel panel) {
        this.panel = panel;
    }

    public ClipboardManager getManager() {
        return this.manager;
    }

    public synchronized void setManager(ClipboardManager newManager) {
        if (this.manager == newManager) {
            return;
        }
        if (this.manager != null) {
            this.manager.removeClipboardListener((ClipboardListener)this.clipboardHandler);
        }
        this.manager = newManager;
        if (this.panel != null) {
            this.panel.setClipManager(this.manager);
        }
        if (this.manager != null) {
            this.manager.addClipboardListener((ClipboardListener)this.clipboardHandler);
        }
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    protected void handleClipboardChanged(ClipboardManager manager) {
        if (this.panel != null) {
            this.panel.refresh();
        }
    }

    protected class ClipboardHandler
    implements ClipboardListener {
        protected ClipboardHandler() {
        }

        public void clipboardChanged(ClipboardManager manager) {
            ClipboardView.this.handleClipboardChanged(manager);
        }
    }
}

