/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.BeanArrayList;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.DefaultFeatureDescriptorFilter;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import com.spacekiller.util.beans.customizers.DefaultCustomizer;
import com.spacekiller.util.workbench.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.beans.Customizer;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class CustomizerView
extends View {
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private BeanDropSupport beanDropSupport;
    private BeanContext dropBeanContext;
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private Customizer customizer;
    private static final Logger logger = Logger.getLogger(CustomizerView.class.getName());

    public CustomizerView() {
        this.dropBeanContext = new BeanContextSupport();
    }

    @Override
    protected Component createComponent() {
        Customizer mizer = this.getCustomizer();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(400, 400));
        panel.setOpaque(true);
        panel.setLayout(new GridLayout(1, 1));
        panel.add((Component)((Object)mizer));
        return panel;
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected void handleBeansDropped(Collection beans) {
        ArrayList list = new ArrayList();
        list.addAll(beans);
        int size = list.size();
        if (size < 1) {
            return;
        }
        if (size == 1) {
            Object bean = list.get(0);
            logger.fine("Setting bean: " + bean);
            this.getCustomizer().setObject(bean);
        } else {
            BeanArrayList beanArrayList = new BeanArrayList();
            beanArrayList.addAll(list);
            this.getCustomizer().setObject(beanArrayList);
        }
    }

    protected Customizer createCustomizer() {
        DefaultCustomizer mizer = new DefaultCustomizer();
        mizer.setBackground(Color.blue);
        mizer.setOpaque(false);
        mizer.setBeansToolkit(this.getBeansToolkit());
        boolean props = true;
        boolean meths = false;
        boolean events = false;
        boolean expert = true;
        boolean hidden = false;
        boolean readonly = true;
        DefaultFeatureDescriptorFilter filter = new DefaultFeatureDescriptorFilter(props, meths, events, expert, hidden, readonly);
        mizer.setFeatureDescriptorFilter((FeatureDescriptorFilter)filter);
        DropTarget dt = new DropTarget((Component)mizer, this.dropTargetHandler);
        mizer.setDropTarget(dt);
        return mizer;
    }

    protected Customizer getCustomizer() {
        if (this.customizer == null) {
            this.setCustomizer(this.createCustomizer());
        }
        return this.customizer;
    }

    protected void setCustomizer(Customizer customizer) {
        this.customizer = customizer;
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (CustomizerView.this.beanDropSupport == null) {
                return;
            }
            BeanContext target = CustomizerView.this.dropBeanContext;
            this.dropBeans.clear();
            CustomizerView.this.beanDropSupport.enumerateDropBeans(target, dtde, this.dropBeans);
            Sys.println((String)("DROP dragEnter: beans=" + this.dropBeans.size()));
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (CustomizerView.this.beanDropSupport == null) {
                return;
            }
            BeanContext target = CustomizerView.this.dropBeanContext;
            ArrayList temp = new ArrayList();
            boolean searchSuccess = CustomizerView.this.beanDropSupport.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null) continue;
                    if (CustomizerView.this.beanDropSupport.acceptDropBean(target, o)) {
                        accepted = true;
                        break;
                    }
                    Sys.println((String)("DROP oops, bean rejected: " + o + " (" + o.getClass() + ")"));
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                Sys.println((String)("DROP reject dragOver: " + target + " (" + target.getClass() + ")"));
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (CustomizerView.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            BeanContext target = CustomizerView.this.dropBeanContext;
            ArrayList temp = new ArrayList();
            boolean enumSuccess = CustomizerView.this.beanDropSupport.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    dtde.dropComplete(true);
                    CustomizerView.this.handleBeansDropped(this.dropBeans);
                    this.dropBeans.clear();
                    Sys.println((String)" - Drop completed.");
                    return;
                }
            }
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }
}

