/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.tooling.ToolListener;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.PreferencesPage;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchExtensions;
import com.spacekiller.util.workbench.WorkbenchListener;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchSelectionManager;
import com.spacekiller.util.workbench.WorkbenchToolContext;
import com.spacekiller.util.workbench.WorkbenchUndoManager;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectLoader;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Synchronization;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;

public class DefaultWorkbench
implements Workbench {
    private static final Logger logger = Logger.getLogger(DefaultWorkbench.class.getName());
    private Workspace workspace;
    private BeansToolkit beansToolkit;
    private RuntimeContext runtimeContext;
    private String name = "Default workbench";
    private String title;
    private boolean visible = false;
    private Window window;
    private Container contentPane;
    private WindowHandler windowHandler = new WindowHandler();
    private Perspective perspective;
    private Vector vPerspectives = new Vector();
    private Hashtable hPerspectives = new Hashtable();
    private List openPerspectives = new ArrayList();
    private EventListenerList windowListeners = new EventListenerList();
    private EventListenerList workbenchListeners = new EventListenerList();
    private JMenuBar menuBar;
    private ToolGroup menuGroup;
    private MenuGroupListener menuGroupListener = new MenuGroupListener();
    private List viewProviders = new ArrayList();
    private BeanDropSupport beanDropSupport;
    private ClipboardManager clipboardManager;
    private SelectionManager selectionManager;
    private List preferencesPages = new ArrayList();
    private WorkbenchToolContext workbenchToolContext;
    private WorkbenchUndoManager undoManager;
    private ViewProviderHandler viewProviderHandler = new ViewProviderHandler();
    private PreferencesPageHandler preferencesPageHandler = new PreferencesPageHandler();

    public DefaultWorkbench() {
        this.initDefaultWorkbench();
    }

    protected void initDefaultWorkbench() {
        try {
            Object x;
            WorkbenchPlugin wbPlugin = WorkbenchUtilities.getWorkbenchPlugin();
            BeanContext bc = wbPlugin.getViewProviders();
            if (bc != null) {
                bc.addBeanContextMembershipListener(this.viewProviderHandler);
                for (Object o : bc) {
                    if (o == null || !(o instanceof ViewProvider)) continue;
                    x = (ViewProvider)o;
                    this.addViewProvider((ViewProvider)x);
                }
            }
            if ((bc = wbPlugin.getPreferencesPages()) != null) {
                bc.addBeanContextMembershipListener(this.preferencesPageHandler);
                for (Object o : bc) {
                    if (o == null || !(o instanceof PreferencesPage)) continue;
                    x = (PreferencesPage)o;
                    this.addPreferencesPage((PreferencesPage)x);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public synchronized void addPerspective(Perspective pers) {
        this.insertPerspectiveAt(pers, this.getPerspectiveCount());
    }

    @Override
    public synchronized void closePerspective(Perspective p) {
        if (p == null) {
            return;
        }
        p.shutdown();
        Perspective current = this.getPerspective();
        if (p == current) {
            this.setPerspective(null);
        }
        this.firePerspectiveClosed(p);
    }

    protected Container createContentPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.setOpaque(true);
        return panel;
    }

    protected Window createWindow() {
        JFrame frame = new JFrame("Workbench");
        frame.setContentPane(this.getContentPane());
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(this.windowHandler);
        frame.setSize(800, 600);
        Tools.centerWindow((Window)frame);
        Tools.ensureWindowFitsScreen((Window)frame);
        return frame;
    }

    @Override
    public synchronized void dispose() {
        Window win;
        if (this.visible && (win = this.getWindow()) != null) {
            logger.fine("Dispose workbench: " + win);
            win.dispose();
            logger.fine("Workbench closed: " + win);
            this.setVisible(false);
        }
        ArrayList<Perspective> listPers = new ArrayList<Perspective>();
        int nPers = this.getPerspectiveCount();
        for (int i = 0; i < nPers; ++i) {
            Perspective pers = this.getPerspectiveAt(i);
            if (pers == null) continue;
            listPers.add(pers);
        }
        for (Perspective pers : listPers) {
            this.closePerspective(pers);
            this.removePerspective(pers);
        }
        this.workspace = null;
        this.vPerspectives = null;
        this.hPerspectives = null;
        this.openPerspectives = null;
        this.perspective = null;
        this.preferencesPages = null;
        this.menuBar = null;
        this.menuGroup = null;
        this.contentPane = null;
        this.beansToolkit = null;
        this.beanDropSupport = null;
        this.window = null;
        this.viewProviders = null;
        this.runtimeContext = null;
        this.selectionManager = null;
    }

    @Override
    public final boolean shutdownNormally() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.shutdownImpl();
        }
        try {
            ShutdownImpl si = new ShutdownImpl();
            SwingUtilities.invokeAndWait(si);
            return si.result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected boolean shutdownImpl() {
        Window win;
        block29: {
            logger.fine("Workbench.shutdownNormally: " + this);
            Workspace ws = this.getWorkspace();
            win = this.window;
            boolean promptUnsavedChanges = true;
            try {
                int execCount;
                ExecutionManager execMan;
                Platform plat = Platform.getInstance();
                if (plat != null && (execMan = plat.getExecutionManager()) != null && (execCount = execMan.getUserExecutionCount()) > 0) {
                    String title = "Running Tasks!";
                    String msg = "There are running task(s) in the background: " + execCount + "\n" + "Please stop the user-tasks before closing the application.";
                    String[] buttons = new String[]{"Continue"};
                    RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
                    rc.prompt(title, (Object)msg, buttons);
                    return false;
                }
                logger.fine("Save workbench preferences...");
                this.savePreferences();
                for (Perspective pers : this.openPerspectives) {
                    ArrayList<View> views = new ArrayList<View>();
                    int viewCount = pers.getViewCount();
                    for (int j = 0; j < viewCount; ++j) {
                        View v = pers.getViewAt(j);
                        if (v == null) continue;
                        views.add(v);
                    }
                    for (View v : views) {
                        if (v.promptClose()) continue;
                        return false;
                    }
                }
                SyncManager syncMan = ws.getSyncManager();
                if (syncMan != null && syncMan.isActivated()) {
                    int button;
                    AbstractButton[] buttons;
                    JButton buttonCancel;
                    Insets bMargins;
                    JPanel msgPanel;
                    JTextArea msgArea;
                    String msgText;
                    String title;
                    Synchronization sync = syncMan.synchronizeAll();
                    int count = sync.getChangeCount();
                    if (count > 0) {
                        if (win != null) {
                            win.toFront();
                        }
                        logger.fine("INFO: Unsaved changes found: " + count);
                        RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
                        title = "Close without saving ?";
                        msgText = "";
                        msgText = msgText + "There are unsaved changes: " + count + "\n";
                        msgText = msgText + "\n";
                        msgText = msgText + "Do you want to save or discard ?";
                        msgText = msgText + "\n";
                        msgArea = new JTextArea();
                        msgArea.setText(msgText);
                        msgArea.setOpaque(false);
                        msgArea.setEditable(false);
                        msgPanel = new JPanel();
                        msgPanel.setLayout(new FlowLayout(0, 5, 5));
                        msgPanel.add(msgArea);
                        bMargins = new Insets(2, 4, 2, 4);
                        JButton buttonSave = new JButton("Save");
                        buttonSave.setMargin(bMargins);
                        buttonSave.setToolTipText("Save changes");
                        JButton buttonDiscard = new JButton("Discard");
                        buttonDiscard.setMargin(bMargins);
                        buttonDiscard.setToolTipText("Discard changes!");
                        buttonCancel = new JButton("Cancel");
                        buttonCancel.setMargin(bMargins);
                        buttonCancel.setToolTipText("Cancel dialog and return to workbench...");
                        try {
                            buttonSave.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/workspace_save.gif")));
                            buttonDiscard.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/discard_changes.gif")));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        msgArea.setFont(buttonSave.getFont());
                        buttons = new AbstractButton[]{buttonSave, buttonDiscard, buttonCancel};
                        button = rc.prompt(title, (Object)msgPanel, buttons);
                        switch (button) {
                            case 0: {
                                logger.fine("INFO: Saving changes...");
                                boolean wasCommitted = syncMan.isCommitted();
                                int savedCount = syncMan.saveAll();
                                logger.fine("INFO: Saved changes: " + savedCount);
                                promptUnsavedChanges = false;
                                if (!wasCommitted) break;
                                logger.fine("INFO: Committing changes...");
                                syncMan.commit();
                                break;
                            }
                            case 1: {
                                logger.fine("INFO: Discard unsaved changes: " + count);
                                promptUnsavedChanges = false;
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (!syncMan.isCommitted()) {
                        if (win != null) {
                            win.toFront();
                        }
                        RuntimeContext rc = WorkbenchExtensions.getRuntimeContext();
                        title = "Commit / Rollback ?";
                        msgText = "The transaction is not committed. \n";
                        msgText = msgText + "\n";
                        msgText = msgText + "Do you want to commit or rollback the changes ?";
                        msgText = msgText + "\n";
                        msgArea = new JTextArea();
                        msgArea.setText(msgText);
                        msgArea.setOpaque(false);
                        msgArea.setEditable(false);
                        msgPanel = new JPanel();
                        msgPanel.setLayout(new FlowLayout(0, 5, 5));
                        msgPanel.add(msgArea);
                        bMargins = new Insets(2, 4, 2, 4);
                        JButton buttonCommit = new JButton("Commit");
                        buttonCommit.setMargin(bMargins);
                        buttonCommit.setToolTipText("Commit transaction");
                        JButton buttonRollback = new JButton("Rollback");
                        buttonRollback.setMargin(bMargins);
                        buttonRollback.setToolTipText("Rollback changes!");
                        buttonCancel = new JButton("Cancel");
                        buttonCancel.setMargin(bMargins);
                        buttonCancel.setToolTipText("Cancel dialog and return to workbench...");
                        try {
                            buttonCommit.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/workspace_commit.gif")));
                            buttonRollback.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/rollback.gif")));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        msgArea.setFont(buttonCommit.getFont());
                        buttons = new AbstractButton[]{buttonCommit, buttonRollback, buttonCancel};
                        button = rc.prompt(title, (Object)msgPanel, buttons);
                        switch (button) {
                            case 0: {
                                logger.fine("INFO: Commit changes...");
                                syncMan.commit();
                                break;
                            }
                            case 1: {
                                logger.fine("INFO: Rollback changes...");
                                syncMan.rollback();
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                if (!this.closeWorkspace(promptUnsavedChanges)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.fine("Workbench.shutdownNormally: FAILED >> " + e);
                logger.log(Level.SEVERE, e.getMessage(), e);
                RuntimeContext rc = this.getRuntimeContext();
                if (rc == null) break block29;
                String tit = "Error";
                String message = "An error occured while synchronizing the changes:\n\n";
                message = message + "" + e + "\n\n";
                boolean force = rc.prompt(tit, (Object)(message = message + "Do you want to close without saving ?"));
                if (force) break block29;
                return false;
            }
        }
        if (win != null && win.isDisplayable()) {
            logger.fine("Closing window: " + win);
            this.disposeWindow(win);
        }
        if (win != null) {
            win.dispose();
            logger.fine("Window closed: " + win);
        }
        logger.fine("Closing perspective(s): " + this.openPerspectives.size());
        for (Perspective pers : this.openPerspectives) {
            this.closePerspective(pers);
        }
        this.setPerspective(null);
        if (this.vPerspectives != null) {
            int persCount = this.getPerspectiveCount();
            for (int i = persCount - 1; i >= 0; --i) {
                this.removePerspectiveAt(i);
            }
        }
        logger.fine("Workbench.shutdownNormally: DONE");
        WindowEvent wev = new WindowEvent(win, 202);
        this.handleWindowClosed(wev);
        return true;
    }

    protected void disposeWindow(Window window) {
        window.dispose();
    }

    @Override
    public boolean closeWorkspace() throws Exception {
        return this.closeWorkspace(true);
    }

    protected boolean closeWorkspace(boolean promptUnsavedChanges) throws Exception {
        Workspace ws = this.getWorkspace();
        if (ws == null) {
            return true;
        }
        SyncManager synchronizer = ws.getSyncManager();
        if (synchronizer == null) {
            return true;
        }
        ArrayList projects = new ArrayList();
        for (Object project : ws) {
            if (project == null) continue;
            projects.add(project);
        }
        this.saveProjectReferences();
        if (!synchronizer.isCommitted()) {
            RuntimeContext rc = this.getRuntimeContext();
            String title = "Rollback transaction?";
            String msg = "The transaction is not committed. \nAre you sure to rollback the saved changes ?";
            String[] buttons = new String[]{"Rollback", "Cancel"};
            int button = rc.prompt(title, (Object)msg, buttons);
            if (button != 0) {
                return false;
            }
            synchronizer.rollback();
        }
        if (!projects.isEmpty()) {
            boolean rc = this.closeProjects(projects, promptUnsavedChanges);
            if (!rc) {
                return false;
            }
            if (ws.size() > 0) {
                return false;
            }
        }
        return true;
    }

    protected void saveProjectReferences() {
    }

    @Override
    public boolean closeProjects(List projects) {
        return this.closeProjects(projects, true);
    }

    @Override
    public boolean closeProjects(List projects, boolean promptUnsavedChanges) {
        SyncManager nizer;
        Workspace ws = this.getWorkspace();
        if (ws == null) {
            return true;
        }
        if (ws.size() <= 0) {
            return true;
        }
        if (promptUnsavedChanges && (nizer = ws.getSyncManager()) != null) {
            try {
                String[] buttons;
                String msg;
                String title;
                RuntimeContext rc;
                int button;
                Synchronization sync = nizer.synchronizeAll(projects.iterator());
                int count = sync.getChangeCount();
                if (count > 0 && (button = (rc = this.getRuntimeContext()).prompt(title = "Close project without saving?", (Object)(msg = "There are unsaved changes: " + count + "\n" + "Are you sure to close the selected project(s) ?"), buttons = new String[]{"Discard", "Cancel"})) != 0) {
                    return false;
                }
            }
            catch (Exception e) {
                this.handleException(e);
                return false;
            }
        }
        int count = projects.size();
        logger.fine(" - Closing " + count + " project(s)..");
        for (int c = 0; c < count; ++c) {
            ws.remove(projects.get(c));
        }
        return true;
    }

    @Override
    public boolean deleteProjects(List projects) throws Exception {
        String[] buttons;
        int button;
        Workspace ws = this.getWorkspace();
        if (ws == null) {
            return true;
        }
        if (ws.size() <= 0) {
            return true;
        }
        int count = projects.size();
        if (count < 1) {
            return true;
        }
        RuntimeContext rc = this.getRuntimeContext();
        String title = "Delete project ?";
        String msg = "Are you sure to delete the selected project ?";
        if (count > 1) {
            title = "Delete " + count + " projects ?";
            msg = "Are you sure to delete the selected project(s) ?";
        }
        if ((button = rc.prompt(title, (Object)msg, buttons = new String[]{"Delete", "Cancel"})) != 0) {
            return false;
        }
        logger.fine(" - Deleting " + count + " project(s)..");
        for (int c = 0; c < count; ++c) {
            ws.delete((Project)projects.get(c));
        }
        return true;
    }

    @Override
    public boolean loadWorkspace() {
        try {
            List projectRefs = this.loadProjectReferences();
            if (projectRefs != null && !projectRefs.isEmpty()) {
                WorkspaceLoader loader = new WorkspaceLoader(projectRefs);
                Platform plat = Platform.getInstance();
                ExecutionManager execMan = plat.getExecutionManager();
                if (execMan != null) {
                    execMan.addExecution((Execution)loader);
                }
                loader.load();
            }
            return true;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    protected List loadProjectReferences() {
        return null;
    }

    @Override
    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    protected synchronized Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(this.createContentPane());
        }
        return this.contentPane;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    @Override
    public Perspective getPerspective(String name) {
        return (Perspective)this.hPerspectives.get(name);
    }

    @Override
    public Perspective getPerspectiveAt(int i) {
        return (Perspective)this.vPerspectives.get(i);
    }

    @Override
    public int getPerspectiveCount() {
        return this.vPerspectives.size();
    }

    @Override
    public int getPerspectiveIndex(Perspective p) {
        return this.vPerspectives.indexOf(p);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected synchronized Window getWindow() {
        if (this.window == null) {
            this.setWindow(this.createWindow());
        }
        return this.window;
    }

    protected WindowHandler getWindowHandler() {
        return this.windowHandler;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    private void handleException(Throwable e) {
        logger.log(Level.WARNING, "" + e, e);
    }

    protected void handleWindowActivated(WindowEvent ev) {
        Perspective pers = this.perspective;
        if (pers != null) {
            pers.workbenchActivated(ev);
        }
        this.fireWindowActivated(ev);
    }

    protected void handleWindowDeactivated(WindowEvent ev) {
        Perspective pers = this.perspective;
        if (pers != null) {
            pers.workbenchDeactivated(ev);
        }
        this.fireWindowDeactivated(ev);
    }

    protected void handleWindowIconified(WindowEvent ev) {
        Perspective pers = this.perspective;
        if (pers != null) {
            pers.workbenchIconified(ev);
        }
        this.fireWindowIconified(ev);
    }

    protected void handleWindowDeiconified(WindowEvent ev) {
        Perspective pers = this.perspective;
        if (pers != null) {
            pers.workbenchDeiconified(ev);
        }
        this.fireWindowDeiconified(ev);
    }

    protected void handleWindowClosed(final WindowEvent ev) {
        if (!this.visible) {
            return;
        }
        Window win = ev.getWindow();
        logger.fine("handleWindowClosed: " + win);
        if (win != this.getWindow()) {
            return;
        }
        if (win.isDisplayable()) {
            logger.info("Ignored faked event: " + ev);
            return;
        }
        logger.fine("Workbench window closed: " + this.window);
        this.visible = false;
        this.shutdownCompleted();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Object[] ll = DefaultWorkbench.this.windowListeners.getListenerList();
                for (int c = 1; c < ll.length; c += 2) {
                    ((WindowListener)ll[c]).windowClosed(ev);
                }
            }
        }).start();
    }

    protected void handleWindowClosing(WindowEvent ev) {
        logger.finer("handleWindowClosing: " + ev.getWindow());
        this.fireWindowClosing(ev);
        Window win = ev.getWindow();
        if (win != null && win == this.window) {
            this.shutdownNormally();
        }
    }

    protected void handleWindowOpened(WindowEvent ev) {
        this.fireWindowOpened(ev);
    }

    protected synchronized void insertPerspectiveAt(Perspective pers, int i) {
        if (pers == null) {
            return;
        }
        String name = pers.getName();
        if (name == null) {
            return;
        }
        this.vPerspectives.insertElementAt(pers, i);
        this.hPerspectives.put(name, pers);
        pers.setWorkbench(this);
        this.firePerspectiveAdded(pers);
    }

    protected void installPerspective(Perspective newPerspective) {
        logger.fine("## Workbench.installPerspective: " + newPerspective);
        if (newPerspective != null) {
            newPerspective.setWorkbench(this);
            this.installMenuBar(newPerspective);
            this.installContentPane(newPerspective);
            Platform.getInstance().debugReference((Object)newPerspective);
        }
    }

    protected void installMenuBar(Perspective newPerspective) {
        ToolGroup menuGroup = newPerspective.getMenuGroup();
        this.setMenuGroup(menuGroup);
        if (menuGroup != null) {
            WorkbenchToolContext ctx = this.getWorkbenchToolContext();
            JMenuBar menuBar = (JMenuBar)menuGroup.createInstance((ToolContext)ctx, JMenuBar.class);
            this.setMenuBar(menuBar);
            this.refreshMenuBar();
            menuGroup.addToolListener((ToolListener)this.menuGroupListener);
        } else {
            this.setMenuBar(null);
        }
    }

    protected void installContentPane(Perspective newPerspective) {
        Component component = newPerspective.getComponent();
        if (component != null) {
            ((JFrame)this.getWindow()).getContentPane().add(component);
        }
    }

    protected void installView(View view) {
        Component comp = view.getComponent();
        if (comp != null) {
            this.getContentPane().add(comp);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public synchronized void openPerspective(Perspective p) {
        if (p != null && p != this.getPerspective()) {
            this.setPerspective(p);
        }
    }

    @Override
    public synchronized void removePerspective(Perspective pers) {
        Object o;
        if (pers == null) {
            return;
        }
        if (pers.getWorkbench() != this) {
            return;
        }
        this.closePerspective(pers);
        this.vPerspectives.removeElement(pers);
        String name = pers.getName();
        if (name != null && (o = this.hPerspectives.get(name)) == pers) {
            this.hPerspectives.remove(name);
        }
        pers.setWorkbench(null);
        this.firePerspectiveRemoved(pers);
    }

    @Override
    public synchronized void removePerspectiveAt(int i) {
        this.removePerspective(this.getPerspectiveAt(i));
    }

    public void setBeansToolkit(BeansToolkit newBeansToolkit) {
        this.beansToolkit = newBeansToolkit;
    }

    protected void setContentPane(Container newContentPane) {
        this.contentPane = newContentPane;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public synchronized void setPerspective(Perspective newPerspective) {
        if (this.openPerspectives == null) {
            return;
        }
        Perspective old = this.perspective;
        if (old == newPerspective) {
            return;
        }
        if (old != null) {
            try {
                this.uninstallPerspective(old);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
        this.getContentPane().removeAll();
        this.perspective = newPerspective;
        boolean opened = false;
        if (newPerspective != null) {
            opened = !newPerspective.isComponentInitialized();
            try {
                this.installPerspective(newPerspective);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            if (!this.openPerspectives.contains(newPerspective)) {
                this.openPerspectives.add(newPerspective);
            }
        }
        this.getWindow().validate();
        this.getWindow().repaint();
        if (old != null) {
            this.firePerspectiveDeactivated(old);
        }
        if (opened) {
            this.firePerspectiveOpened(newPerspective);
        }
        if (newPerspective != null) {
            this.firePerspectiveActivated(newPerspective);
        }
    }

    public void setRuntimeContext(RuntimeContext newRuntimeContext) {
        this.runtimeContext = newRuntimeContext;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    protected void setVisible(boolean newVisible) {
        this.visible = newVisible;
    }

    protected void setWindow(Window newWindow) {
        this.window = newWindow;
    }

    public void setWorkspace(Workspace newWorkspace) {
        this.workspace = newWorkspace;
    }

    @Override
    public synchronized void show() {
        Window win = this.getWindow();
        if (win == null) {
            return;
        }
        if (this.visible) {
            Frame frame;
            if (win instanceof Frame && (frame = (Frame)win).getState() == 1) {
                frame.setState(0);
            }
            win.toFront();
        } else {
            this.refresh();
            win.setVisible(true);
            this.setVisible(true);
        }
    }

    protected void shutdownCompleted() {
    }

    protected void savePreferences() {
    }

    protected void uninstallPerspective(Perspective oldPerspective) {
        if (oldPerspective == null) {
            return;
        }
        if (oldPerspective.getWorkbench() != this) {
            return;
        }
        ((JFrame)this.getWindow()).setJMenuBar(null);
        this.getContentPane().removeAll();
        if (this.menuGroup != null) {
            this.menuGroup.removeToolListener((ToolListener)this.menuGroupListener);
        }
        oldPerspective.setWorkbench(null);
    }

    @Override
    public void refresh() {
        if (this.perspective != null) {
            logger.fine("Refresh: " + this.perspective);
            this.perspective.refresh();
        }
        this.refreshMenuBar();
    }

    @Override
    public void addWindowListener(WindowListener l) {
        this.windowListeners.add(WindowListener.class, l);
    }

    @Override
    public void removeWindowListener(WindowListener l) {
        this.windowListeners.remove(WindowListener.class, l);
    }

    protected synchronized void fireWindowClosing(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowClosing(ev);
        }
    }

    protected synchronized void fireWindowClosed(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowClosed(ev);
        }
    }

    protected synchronized void fireWindowOpened(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowOpened(ev);
        }
    }

    protected synchronized void fireWindowActivated(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowActivated(ev);
        }
    }

    protected synchronized void fireWindowDeactivated(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowDeactivated(ev);
        }
    }

    protected synchronized void fireWindowIconified(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowIconified(ev);
        }
    }

    protected synchronized void fireWindowDeiconified(WindowEvent ev) {
        Object[] ll = this.windowListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WindowListener)ll[c]).windowDeiconified(ev);
        }
    }

    protected JMenuBar getMenuBar() {
        return this.menuBar;
    }

    protected void setMenuBar(JMenuBar newMenuBar) {
        this.menuBar = newMenuBar;
    }

    protected void refreshMenuBar() {
        JFrame frame = (JFrame)this.getWindow();
        boolean showMenuBar = false;
        ToolGroup group = this.getMenuGroup();
        if (group != null && group.getChildCount() > 0) {
            showMenuBar = true;
        }
        if (showMenuBar) {
            JMenuBar bar = this.getMenuBar();
            if (frame.getJMenuBar() != bar) {
                frame.setJMenuBar(bar);
            }
        } else if (frame.getJMenuBar() != null) {
            frame.setJMenuBar(null);
        }
    }

    protected ToolGroup getMenuGroup() {
        return this.menuGroup;
    }

    protected void setMenuGroup(ToolGroup menuGroup) {
        this.menuGroup = menuGroup;
    }

    @Override
    public void addWorkbenchListener(WorkbenchListener l) {
        this.workbenchListeners.add(WorkbenchListener.class, l);
    }

    @Override
    public void removeWorkbenchListener(WorkbenchListener l) {
        this.workbenchListeners.remove(WorkbenchListener.class, l);
    }

    protected synchronized void firePerspectiveAdded(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveAdded(pers);
        }
    }

    protected synchronized void firePerspectiveRemoved(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveRemoved(pers);
        }
    }

    protected synchronized void firePerspectiveOpened(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveOpened(pers);
        }
    }

    protected synchronized void firePerspectiveClosed(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveClosed(pers);
        }
    }

    protected synchronized void firePerspectiveActivated(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveActivated(pers);
        }
    }

    protected synchronized void firePerspectiveDeactivated(Perspective pers) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).perspectiveDeactivated(pers);
        }
    }

    protected synchronized void fireViewProviderAdded(ViewProvider vp) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).viewProviderAdded(vp);
        }
    }

    protected synchronized void fireViewProviderRemoved(ViewProvider vp) {
        Object[] ll = this.workbenchListeners.getListenerList();
        for (int c = 1; c < ll.length; c += 2) {
            ((WorkbenchListener)ll[c]).viewProviderRemoved(vp);
        }
    }

    @Override
    public boolean isPerspectiveActivated(Perspective p) {
        return p == this.getPerspective();
    }

    @Override
    public boolean isPerspectiveOpened(Perspective p) {
        return this.openPerspectives.contains(p);
    }

    @Override
    public void addViewProvider(ViewProvider vp) {
        if (vp != null) {
            this.viewProviders.add(vp);
            this.fireViewProviderAdded(vp);
        }
    }

    @Override
    public ViewProvider getViewProviderAt(int i) {
        return (ViewProvider)this.viewProviders.get(i);
    }

    @Override
    public int getViewProviderCount() {
        return this.viewProviders.size();
    }

    @Override
    public ViewProvider getViewProvider(String id) {
        for (ViewProvider vp : this.viewProviders) {
            if (!id.equals(vp.getId())) continue;
            return vp;
        }
        return null;
    }

    @Override
    public void removeViewProvider(ViewProvider vp) {
        if (this.viewProviders.remove(vp)) {
            this.fireViewProviderRemoved(vp);
        }
    }

    @Override
    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    @Override
    public SelectionManager getSelectionManager() {
        if (this.selectionManager == null) {
            this.setSelectionManager(new WorkbenchSelectionManager(this));
        }
        return this.selectionManager;
    }

    protected void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    @Override
    public PreferencesPage getPreferencesPageAt(int i) {
        return (PreferencesPage)this.preferencesPages.get(i);
    }

    @Override
    public int getPreferencesPageCount() {
        return this.preferencesPages.size();
    }

    @Override
    public void addPreferencesPage(PreferencesPage page) {
        if (page != null && !this.preferencesPages.contains(page)) {
            this.preferencesPages.add(page);
        }
    }

    @Override
    public void removePreferencesPage(PreferencesPage page) {
        this.preferencesPages.remove(page);
    }

    @Override
    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    @Override
    public void switchWorkspace() {
        try {
            Workspace ws = this.getWorkspace();
            if (ws == null) {
                return;
            }
            SyncManager sync = ws.getSyncManager();
            if (sync == null) {
                return;
            }
            sync.openSwitchDatabaseDialog((Object)this);
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    protected WorkbenchToolContext createWorkbenchToolContext() {
        WorkbenchToolContext wtc = new WorkbenchToolContext();
        return wtc;
    }

    @Override
    public WorkbenchToolContext getWorkbenchToolContext() {
        if (this.workbenchToolContext == null) {
            this.setWorkbenchToolContext(this.createWorkbenchToolContext());
        }
        return this.workbenchToolContext;
    }

    public void setWorkbenchToolContext(WorkbenchToolContext workbenchToolContext) {
        this.workbenchToolContext = workbenchToolContext;
        if (workbenchToolContext != null) {
            Platform plat = Platform.getInstance();
            Workspace ws = this.getWorkspace();
            DefaultWorkbench wb = this;
            workbenchToolContext.initWorkbenchToolContext(plat, ws, wb);
        }
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(WorkbenchUndoManager undoManager) {
        this.undoManager = undoManager;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        WorkbenchUndoManager um = this.undoManager;
        if (um != null) {
            um.addUndoableEditListener(l);
        }
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        WorkbenchUndoManager um = this.undoManager;
        if (um != null) {
            um.removeUndoableEditListener(l);
        }
    }

    protected class PreferencesPageHandler
    implements BeanContextMembershipListener {
        protected PreferencesPageHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                try {
                    PreferencesPage view = (PreferencesPage)next;
                    DefaultWorkbench.this.addPreferencesPage(view);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                try {
                    PreferencesPage view = (PreferencesPage)next;
                    DefaultWorkbench.this.removePreferencesPage(view);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    protected class ViewProviderHandler
    implements BeanContextMembershipListener {
        protected ViewProviderHandler() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                try {
                    ViewProvider view = (ViewProvider)next;
                    DefaultWorkbench.this.addViewProvider(view);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            Iterator i = bcme.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                try {
                    ViewProvider view = (ViewProvider)next;
                    DefaultWorkbench.this.removeViewProvider(view);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    protected class ShutdownImpl
    implements Runnable {
        protected boolean result;

        protected ShutdownImpl() {
        }

        @Override
        public void run() {
            this.result = DefaultWorkbench.this.shutdownImpl();
        }
    }

    protected class WorkspaceLoader
    extends AbstractExecution {
        private Collection projectReferences;

        public WorkspaceLoader(Collection projectReferences) {
            this.projectReferences = projectReferences;
            this.setName("WorkspaceLoader");
            DefaultWorkbench.this.setTitle("Loading workspace");
        }

        protected void load() throws Exception {
            super.run();
        }

        protected void execute() throws Exception {
            Workspace ws = DefaultWorkbench.this.getWorkspace();
            ArrayList list = new ArrayList();
            list.addAll(this.projectReferences);
            int num = list.size();
            logger.fine("Loading projects: " + num);
            ProjectLoader projectLoader = WorkbenchExtensions.createProjectLoader(ws);
            for (int i = 0; i < num; ++i) {
                this.setProgress((double)i / (double)num);
                ProjectReference ref = (ProjectReference)list.get(i);
                if (ref == null) {
                    logger.fine("DEBUG: ProjectReference==null");
                    continue;
                }
                logger.fine("Loading project: " + ref.getProjectName() + " (" + ref.getProjectClassName() + ")");
                Project project = projectLoader.getProject(ref);
                if (project == null) {
                    logger.fine("WARNING: project not found: " + ref);
                    continue;
                }
                logger.fine(" -> Project loaded: " + ref);
            }
            this.setProgress(1.0);
        }
    }

    protected class MenuGroupListener
    implements ToolListener {
        protected MenuGroupListener() {
        }

        public void childrenAdded(ToolEvent ev) {
            DefaultWorkbench.this.refreshMenuBar();
        }

        public void childrenRemoved(ToolEvent ev) {
            DefaultWorkbench.this.refreshMenuBar();
        }

        public void toolChanged(Tool tool) {
            DefaultWorkbench.this.refreshMenuBar();
        }
    }

    protected class WindowHandler
    implements WindowListener {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowActivated(ev);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowDeactivated(ev);
        }

        @Override
        public void windowIconified(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowIconified(ev);
        }

        @Override
        public void windowDeiconified(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowDeiconified(ev);
        }

        @Override
        public void windowOpened(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowOpened(ev);
        }

        @Override
        public void windowClosed(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowClosed(ev);
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            DefaultWorkbench.this.handleWindowClosing(ev);
        }
    }
}

