/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public abstract class DesktopManagerBase
extends DefaultDesktopManager {
    private static final long serialVersionUID = 1272465430892340295L;
    protected JDesktopPane desktopPane;
    private Rectangle rv = new Rectangle();

    public DesktopManagerBase(JDesktopPane desktopPane) {
        this.setDesktopPane(desktopPane);
    }

    protected JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    protected void setDesktopPane(JDesktopPane desktopPane) {
        this.desktopPane = desktopPane;
    }

    @Override
    public void beginDraggingFrame(JComponent f) {
        super.beginDraggingFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        super.dragFrame(f, newX, newY);
        this.refreshPreferredSize();
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        super.endDraggingFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        super.beginResizingFrame(f, direction);
        this.refreshPreferredSize();
    }

    @Override
    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        super.resizeFrame(f, newX, newY, newWidth, newHeight);
        this.refreshPreferredSize();
    }

    @Override
    public void endResizingFrame(JComponent f) {
        super.endResizingFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void openFrame(JInternalFrame f) {
        super.openFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        super.closeFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void maximizeFrame(JInternalFrame f) {
        super.maximizeFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        super.minimizeFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        super.iconifyFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        super.deiconifyFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        Rectangle r;
        super.activateFrame(f);
        this.refreshPreferredSize();
        if (f != null && (r = f.getBounds()) != null) {
            this.desktopPane.scrollRectToVisible(r);
        }
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        super.deactivateFrame(f);
        this.refreshPreferredSize();
    }

    @Override
    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        super.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        this.refreshPreferredSize();
    }

    protected void refreshPreferredSize() {
        Dimension pref;
        int num;
        JDesktopPane pane = this.desktopPane;
        if (pane == null) {
            return;
        }
        int width = 0;
        int height = 0;
        JInternalFrame[] frames = pane.getAllFrames();
        int n = num = frames == null ? 0 : frames.length;
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                JInternalFrame frame = frames[i];
                if (frame == null || frame.isIcon()) continue;
                this.rv = frame.getBounds(this.rv);
                if (this.rv == null) continue;
                int w = this.rv.x + this.rv.width;
                int h = this.rv.y + this.rv.height;
                if (w > width) {
                    width = w;
                }
                if (h <= height) continue;
                height = h;
            }
        }
        if ((pref = pane.getPreferredSize()) != null && pref.width == width && pref.height == height) {
            return;
        }
        if (pref == null) {
            pref = new Dimension();
        }
        pref.width = width;
        pref.height = height;
        pane.setPreferredSize(pref);
        Container parent = pane.getParent();
        if (parent != null) {
            parent.doLayout();
        }
    }
}

