/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Data;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FileDetailsTableModel
implements TableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_SIZE = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_MODIFIED = 3;
    public static final int COLUMNS = 4;
    private List records = new ArrayList();
    private int columnCount = 4;
    private transient List tableModelListeners;
    private FileTypeRegistry fileTypeRegistry;
    private Comparator fileComparator;

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Last_modified";
            }
        }
        return "Column" + columnIndex;
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        File file = this.getFileAt(rowIndex);
        if (file == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return file.getName();
            }
            case 1: {
                return file.isFile() ? Data.toLong((long)file.length()) : null;
            }
            case 2: {
                return this.getFileType(file);
            }
            case 3: {
                return Data.toLong((long)file.lastModified());
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public File getFileAt(int i) {
        return (File)this.records.get(i);
    }

    public FileType getFileType(File file) {
        if (this.fileTypeRegistry == null) {
            return null;
        }
        return this.fileTypeRegistry.getFileType(file);
    }

    public synchronized void addFile(File rec) {
        int row = this.records.size();
        if (this.fileComparator != null) {
            // empty if block
        }
        this.records.add(rec);
        this.fireTableRowsInserted(row, row);
    }

    public synchronized void removeFileAt(int i) {
        this.records.remove(i);
        this.fireTableRowsDeleted(i, i);
    }

    public synchronized void removeFile(File x) {
        int i = this.records.indexOf(x);
        if (i >= 0) {
            this.records.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (this.tableModelListeners == null) {
            return;
        }
        int currentSize = this.tableModelListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            TableModelListener ls = (TableModelListener)this.tableModelListeners.get(index);
            if (ls == null) continue;
            ls.tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new LinkedList();
        }
        this.tableModelListeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    public TableModelListener[] getTableModelListeners() {
        if (this.tableModelListeners == null) {
            return new TableModelListener[0];
        }
        return this.tableModelListeners.toArray(new TableModelListener[this.tableModelListeners.size()]);
    }

    public synchronized void clear() {
        if (this.records.isEmpty()) {
            return;
        }
        int num = this.records.size();
        this.records.clear();
        this.fireTableRowsDeleted(0, num - 1);
    }

    protected void sort() {
        int rows = this.records.size();
        if (rows < 1) {
            return;
        }
        Comparator comparator = this.getFileComparator();
        if (comparator == null) {
            return;
        }
        TreeSet set = new TreeSet(comparator);
        set.addAll(this.records);
        ArrayList newList = new ArrayList();
        newList.addAll(set);
        this.records = newList;
        int firstRow = 0;
        int lastRow = rows - 1;
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public Comparator getFileComparator() {
        return this.fileComparator;
    }

    public synchronized void setFileComparator(Comparator fileComparator) {
        this.fileComparator = fileComparator;
        this.sort();
    }

    public FileTypeRegistry getFileTypeRegistry() {
        return this.fileTypeRegistry;
    }

    public void setFileTypeRegistry(FileTypeRegistry fileTypeRegistry) {
        this.fileTypeRegistry = fileTypeRegistry;
    }
}

