/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Data;
import com.spacekiller.util.FileType;
import com.spacekiller.util.FileTypeRegistry;
import com.spacekiller.util.beans.AbstractSelection;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanObserver;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.table.TableColumnProvider;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.FileDetailsTableModel;
import com.spacekiller.util.workbench.FileViewer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class FileDetailsTableViewer
extends JPanel
implements FileViewer,
BeanObserver,
Selectable {
    private static final long serialVersionUID = -5523001096097057621L;
    private FileDetailsTableModel model;
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private FileTypeRegistry fileTypeRegistry;
    private List tableColumnProviders;
    private TableColumnModel columnModel;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private FileDetailsSelection fileDetailsSelection;
    private ToolGroup popupMenuToolGroup;
    private transient ActionListener actionListeners;
    private FileComparator fileComparator;
    private FileNameComparator fileNameComparator;
    private FileSizeComparator fileSizeComparator;
    private FileTypeComparator fileTypeComparator;
    private FileModifiedComparator fileModifiedComparator;
    private static final Logger logger = Logger.getLogger(FileDetailsTableViewer.class.getName());

    public FileDetailsTableViewer() {
        this.initialize();
        this.initFileDetailsTableViewer();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        this.setLayout(gridLayout);
        this.setSize(new Dimension(377, 243));
        this.add((Component)this.getJScrollPane(), null);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    logger.fine("keyTyped: " + e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.jTable.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int clicks = e.getClickCount();
                    if (clicks == 2) {
                        FileDetailsTableViewer.this.openSelectedObjects();
                    }
                }

                @Override
                public void mousePressed(MouseEvent ev) {
                    if (ev.isPopupTrigger()) {
                        FileDetailsTableViewer.this.showContextPopupMenu(ev.getX(), ev.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent ev) {
                    if (ev.isPopupTrigger()) {
                        FileDetailsTableViewer.this.showContextPopupMenu(ev.getX(), ev.getY());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.jTable;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    protected void initFileDetailsTableViewer() {
        this.model = new FileDetailsTableModel();
        JTable table = this.getJTable();
        table.setAutoResizeMode(0);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setRowMargin(0);
        table.setModel(this.model);
        this.tableColumnProviders = new ArrayList();
        this.columnModel = new DefaultTableColumnModel();
        this.refreshTableColumns();
        this.getJTable().setColumnModel(this.columnModel);
        this.getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileDetailsTableViewer.this.handleSelectionChanged(e);
            }
        });
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 0x40000003;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(this.getJTable(), actions, this.dragGestureHandler);
        dgr.getComponent();
        this.fileNameComparator = new FileNameComparator();
        this.fileSizeComparator = new FileSizeComparator();
        this.fileTypeComparator = new FileTypeComparator();
        this.fileModifiedComparator = new FileModifiedComparator();
        this.fileComparator = new FileComparator();
        this.fileComparator.addComparator(this.fileNameComparator);
        this.model.setFileComparator(this.fileComparator);
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int col = FileDetailsTableViewer.this.getJTable().columnAtPoint(new Point(x, y));
                if (col < 0) {
                    return;
                }
                FileDetailsTableViewer.this.sortColumn(col);
            }
        });
    }

    @Override
    public void setFiles(File[] files) {
        this.model.clear();
        if (files != null) {
            for (int c = 0; c < files.length; ++c) {
                File f = files[c];
                if (f == null) continue;
                this.model.addFile(f);
            }
        }
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected void handleSelectionChanged(ListSelectionEvent e) {
        this.getFileDetailsSelection().handleSelectionModelValueChanged(e);
    }

    protected void openSelectedObjects() {
        ActionEvent ev = new ActionEvent(this, 1001, "action");
        this.fireActionPerformed(ev);
    }

    protected void showContextPopupMenu(int x, int y) {
        this.getComponent().requestFocus();
        Point p = new Point(x, y);
        int row = this.getJTable().rowAtPoint(p);
        if (row >= 0) {
            if (!this.getJTable().isRowSelected(row)) {
                this.getJTable().setRowSelectionInterval(row, row);
            }
        } else {
            this.getJTable().clearSelection();
        }
        ToolGroup group = this.getPopupMenuToolGroup();
        logger.fine("PopupMenuToolGroup: " + group);
        if (group != null) {
            Object instance;
            ToolContext ctx = null;
            int num = group.getChildCount();
            logger.fine("PopupMenu-Tools: " + num);
            if (num > 0 && (instance = group.createInstance(ctx, JPopupMenu.class)) != null && instance instanceof JPopupMenu) {
                JPopupMenu menu = (JPopupMenu)instance;
                menu.show(this.getJTable(), x, y);
            }
        }
    }

    public ToolGroup getPopupMenuToolGroup() {
        return this.popupMenuToolGroup;
    }

    public void setPopupMenuToolGroup(ToolGroup popupMenuToolGroup) {
        this.popupMenuToolGroup = popupMenuToolGroup;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public Selection getSelection() {
        return this.getFileDetailsSelection();
    }

    public boolean addBean(Object o) throws Exception {
        logger.fine("TODO addBean: " + o);
        return false;
    }

    protected FileDetailsSelection createFileDetailsSelection() {
        return new FileDetailsSelection();
    }

    protected FileDetailsSelection getFileDetailsSelection() {
        if (this.fileDetailsSelection == null) {
            this.setFileDetailsSelection(this.createFileDetailsSelection());
        }
        return this.fileDetailsSelection;
    }

    protected void setFileDetailsSelection(FileDetailsSelection fileDetailsSelection) {
        this.fileDetailsSelection = fileDetailsSelection;
    }

    protected Object getBeanAt(int row) {
        return this.model.getFileAt(row);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void sortColumn(int column) {
        TableColumn col = this.getJTable().getColumnModel().getColumn(column);
        int index = col.getModelIndex();
        switch (index) {
            case 0: {
                if (this.fileComparator.containsComparator(this.fileNameComparator)) {
                    this.fileNameComparator.setAscending(!this.fileNameComparator.isAscending());
                } else {
                    this.fileNameComparator.setAscending(true);
                }
                this.fileComparator.removeComparator(this.fileNameComparator);
                this.fileComparator.insertComparatorAt(this.fileNameComparator, 0);
                this.model.setFileComparator(this.fileComparator);
                break;
            }
            case 1: {
                if (this.fileComparator.containsComparator(this.fileSizeComparator)) {
                    this.fileSizeComparator.setAscending(!this.fileSizeComparator.isAscending());
                } else {
                    this.fileSizeComparator.setAscending(true);
                }
                this.fileComparator.removeComparator(this.fileSizeComparator);
                this.fileComparator.insertComparatorAt(this.fileSizeComparator, 0);
                this.model.setFileComparator(this.fileComparator);
                break;
            }
            case 2: {
                if (this.fileComparator.containsComparator(this.fileTypeComparator)) {
                    this.fileTypeComparator.setAscending(!this.fileTypeComparator.isAscending());
                } else {
                    this.fileTypeComparator.setAscending(true);
                }
                this.fileComparator.removeComparator(this.fileTypeComparator);
                this.fileComparator.insertComparatorAt(this.fileTypeComparator, 0);
                this.model.setFileComparator(this.fileComparator);
                break;
            }
            case 3: {
                if (this.fileComparator.containsComparator(this.fileModifiedComparator)) {
                    this.fileModifiedComparator.setAscending(!this.fileModifiedComparator.isAscending());
                } else {
                    this.fileModifiedComparator.setAscending(true);
                }
                this.fileComparator.removeComparator(this.fileModifiedComparator);
                this.fileComparator.insertComparatorAt(this.fileModifiedComparator, 0);
                this.model.setFileComparator(this.fileComparator);
            }
        }
    }

    public FileTypeRegistry getFileTypeRegistry() {
        return this.fileTypeRegistry;
    }

    public void setFileTypeRegistry(FileTypeRegistry fileTypeRegistry) {
        this.fileTypeRegistry = fileTypeRegistry;
        if (this.model != null) {
            this.model.setFileTypeRegistry(fileTypeRegistry);
        }
    }

    protected int actionCopy() {
        throw new UnsupportedOperationException("TODO copy files");
    }

    protected int actionCut() {
        throw new UnsupportedOperationException("TODO cut files");
    }

    protected int actionDelete() {
        throw new UnsupportedOperationException("TODO delete files");
    }

    protected int actionPaste() {
        throw new UnsupportedOperationException("TODO paste files");
    }

    public synchronized void addTableColumnProvider(TableColumnProvider p) {
        if (p != null && this.tableColumnProviders.add(p)) {
            this.refreshTableColumns();
        }
    }

    public synchronized void removeTableColumnProvider(TableColumnProvider p) {
        if (this.tableColumnProviders.remove(p)) {
            this.refreshTableColumns();
        }
    }

    public synchronized void removeAllTableColumnProviders() {
        if (this.tableColumnProviders.isEmpty()) {
            return;
        }
        this.tableColumnProviders.clear();
        this.refreshTableColumns();
    }

    protected synchronized void refreshTableColumns() {
        int old = this.columnModel.getColumnCount();
        for (int i = old - 1; i >= 0; --i) {
            this.columnModel.removeColumn(this.columnModel.getColumn(i));
        }
        for (TableColumnProvider provider : this.tableColumnProviders) {
            TableColumn column = provider.createTableColumn((TableModel)this.model);
            if (column == null) continue;
            this.columnModel.addColumn(column);
        }
    }

    protected class FileDetailsSelection
    extends AbstractSelection {
        private Map selected;

        public FileDetailsSelection() {
            super((Object)FileDetailsTableViewer.this);
            this.selected = new HashMap();
        }

        public TreePath getSelectionPathAt(int i) {
            return new TreePath(Data.toInteger((int)i));
        }

        protected synchronized void handleSelectionModelValueChanged(ListSelectionEvent e) {
            int first = e.getFirstIndex();
            int last = e.getLastIndex();
            JTable tab = FileDetailsTableViewer.this.getJTable();
            for (int i = first; i <= last; ++i) {
                Object old;
                boolean sel = tab.isRowSelected(i);
                Integer inti = Data.toInteger((int)i);
                if (sel) {
                    Object bean;
                    old = this.selected.get(inti);
                    if (old == (bean = FileDetailsTableViewer.this.getBeanAt(i))) continue;
                    if (old != null) {
                        this.removeSelectedObject(old);
                    }
                    if (bean != null) {
                        this.selected.put(inti, bean);
                        this.insertSelectedObjectAt(bean, this.getSelectedObjectCount());
                        continue;
                    }
                    this.selected.remove(inti);
                    continue;
                }
                old = this.selected.remove(inti);
                if (old == null) continue;
                this.removeSelectedObject(old);
            }
        }

        public int removeSelectedObjects() {
            return FileDetailsTableViewer.this.actionDelete();
        }

        public int copySelectedObjects() {
            return FileDetailsTableViewer.this.actionCopy();
        }

        public int cutSelectedObjects() {
            return FileDetailsTableViewer.this.actionCut();
        }

        public boolean isPasteSupported() {
            return true;
        }

        public int pasteObjects() {
            return FileDetailsTableViewer.this.actionPaste();
        }
    }

    protected static class FileModifiedComparator
    implements Comparator {
        private boolean ascending = true;

        protected FileModifiedComparator() {
        }

        public int compare(Object a, Object b) {
            long bTime;
            File fa = (File)a;
            File fb = (File)b;
            long aTime = fa.lastModified();
            if (aTime == (bTime = fb.lastModified())) {
                return 0;
            }
            if (this.ascending) {
                return aTime < bTime ? -1 : 1;
            }
            return aTime < bTime ? 1 : -1;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    protected class FileTypeComparator
    implements Comparator {
        private boolean ascending = true;

        protected FileTypeComparator() {
        }

        public int compare(Object a, Object b) {
            FileType bType;
            FileType aType;
            File fa = (File)a;
            File fb = (File)b;
            if (FileDetailsTableViewer.this.fileTypeRegistry != null && (aType = FileDetailsTableViewer.this.fileTypeRegistry.getFileType(fa)) != (bType = FileDetailsTableViewer.this.fileTypeRegistry.getFileType(fb))) {
                int x;
                if (aType == null) {
                    return this.ascending ? -1 : 1;
                }
                if (bType == null) {
                    return this.ascending ? 1 : -1;
                }
                String aTypeName = aType.getName();
                String bTypeName = bType.getName();
                if (aTypeName != null && (this.ascending ? (x = aTypeName.compareTo(bTypeName)) != 0 : (x = bTypeName.compareTo(aTypeName)) != 0)) {
                    return x;
                }
            }
            String aName = fa.getName();
            String bName = fb.getName();
            int x = aName.lastIndexOf(".");
            String aExt = "";
            if (x >= 0) {
                aExt = aName.substring(x).toLowerCase();
            }
            x = bName.lastIndexOf(".");
            String bExt = "";
            if (x >= 0) {
                bExt = bName.substring(x).toLowerCase();
            }
            if (this.ascending) {
                return aExt.compareTo(bExt);
            }
            return bExt.compareTo(aExt);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    protected static class FileSizeComparator
    implements Comparator {
        private boolean ascending = true;

        protected FileSizeComparator() {
        }

        public int compare(Object a, Object b) {
            long bSize;
            File fa = (File)a;
            File fb = (File)b;
            long aSize = fa.length();
            if (aSize == (bSize = fb.length())) {
                return 0;
            }
            if (this.ascending) {
                return aSize < bSize ? -1 : 1;
            }
            return aSize < bSize ? 1 : -1;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    protected static class FileNameComparator
    implements Comparator {
        private boolean ascending = true;

        protected FileNameComparator() {
        }

        public int compare(Object a, Object b) {
            boolean bDir;
            File fa = (File)a;
            File fb = (File)b;
            boolean aDir = fa.isDirectory();
            if (aDir != (bDir = fb.isDirectory())) {
                if (this.ascending) {
                    return aDir ? -1 : 1;
                }
                return aDir ? 1 : -1;
            }
            String aName = fa.getName().toLowerCase();
            String bName = fb.getName().toLowerCase();
            if (this.ascending) {
                return aName.compareTo(bName);
            }
            return bName.compareTo(aName);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }

    protected static class FileComparator
    implements Comparator {
        private List comparators = new ArrayList();

        public int compare(Object a, Object b) {
            int bHash;
            File fa = (File)a;
            File fb = (File)b;
            int num = this.comparators.size();
            for (int i = 0; i < num; ++i) {
                int x = ((Comparator)this.comparators.get(i)).compare(fa, fb);
                if (x == 0) continue;
                return x;
            }
            int aHash = System.identityHashCode(fa);
            return aHash < (bHash = System.identityHashCode(fb)) ? -1 : 1;
        }

        public int getComparatorCount() {
            return this.comparators.size();
        }

        public Comparator getComparatorAt(int i) {
            return (Comparator)this.comparators.get(i);
        }

        public boolean containsComparator(Comparator c) {
            return this.comparators.contains(c);
        }

        public void insertComparatorAt(Comparator c, int i) {
            this.comparators.add(i, c);
        }

        public void addComparator(Comparator c) {
            this.comparators.add(c);
        }

        public void removeComparator(Comparator c) {
            this.comparators.remove(c);
        }

        public void removeComparatorAt(int i) {
            this.comparators.remove(i);
        }

        public void removeAllComparators() {
            this.comparators.clear();
        }
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            int[] rows = FileDetailsTableViewer.this.getJTable().getSelectedRows();
            if (rows == null) {
                return;
            }
            if (rows.length < 1) {
                return;
            }
            ArrayList<File> beans = new ArrayList<File>();
            for (int c = 0; c < rows.length; ++c) {
                int row = rows[c];
                File file = FileDetailsTableViewer.this.model.getFileAt(row);
                if (file == null) continue;
                beans.add(file);
            }
            if (beans.isEmpty()) {
                return;
            }
            FileDetailsTableViewer.this.dragSourceHandler.setBeanDropSupport(FileDetailsTableViewer.this.getBeanDropSupport());
            FileDetailsTableViewer.this.dragSourceHandler.startDrag(dge, beans);
        }
    }
}

