/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileType;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.Selectable;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.beans.SelectionEvent;
import com.spacekiller.util.beans.SelectionListener;
import com.spacekiller.util.beans.model.BeanTreeComparator;
import com.spacekiller.util.table.RowComparator;
import com.spacekiller.util.table.TableCellFormatter;
import com.spacekiller.util.table.TableColumnProvider;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.FileDetailsTableModel;
import com.spacekiller.util.workbench.FileDetailsTableViewer;
import com.spacekiller.util.workbench.FileExplorer;
import com.spacekiller.util.workbench.FileTreeView;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FileExplorerView
extends View
implements Selectable {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private BeanTreeComparator beanTreeComparator;
    private ToolGroup popupMenuToolGroup;
    private List tableColumnProviders;
    private DateFormat dateFormat;
    private FileExplorer explorer;
    private FolderSelectionListener folderSelectionListener = new FolderSelectionListener();
    private boolean refreshing = false;
    private static final Logger logger = Logger.getLogger(FileExplorerView.class.getName());

    public FileExplorerView() {
        this.initFileExplorerView();
    }

    protected void initFileExplorerView() {
        this.dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        this.tableColumnProviders = new ArrayList();
        this.initDefaultTableColumnProviders();
    }

    @Override
    protected Component createComponent() {
        return this.getExplorer();
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected void initExplorer() {
        FileExplorer exp = new FileExplorer();
        this.setExplorer(exp);
        exp.setPreferredSize(new Dimension(600, 500));
        FileDetailsTableViewer fileViewer = new FileDetailsTableViewer();
        fileViewer.setBeansToolkit(this.getBeansToolkit());
        fileViewer.setBeanDropSupport(this.getBeanDropSupport());
        fileViewer.setPopupMenuToolGroup(this.getPopupMenuToolGroup());
        for (TableColumnProvider p : this.tableColumnProviders) {
            fileViewer.addTableColumnProvider(p);
        }
        exp.setFileViewer(fileViewer);
        FileTreeView fileTree = new FileTreeView();
        fileTree.setBeansToolkit(this.getBeansToolkit());
        fileTree.setBeanDropSupport(this.getBeanDropSupport());
        fileTree.setBeanTreeComparator(this.getBeanTreeComparator());
        fileTree.setPopupMenuToolGroup(this.getPopupMenuToolGroup());
        fileTree.setHideFiles(true);
        exp.setFileTreeView(fileTree);
        Selection selection = fileTree.getBeanSelection();
        if (selection != null) {
            selection.addSelectionListener((SelectionListener)this.folderSelectionListener);
        }
        JComponent comp = (JComponent)fileTree.getComponent();
        comp.setMinimumSize(new Dimension(200, 300));
        SwingUtilities.invokeLater(new ExplorerInitializer());
    }

    public FileExplorer getExplorer() {
        if (this.explorer == null) {
            this.initExplorer();
        }
        return this.explorer;
    }

    protected void setExplorer(FileExplorer explorer) {
        this.explorer = explorer;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public BeanTreeComparator getBeanTreeComparator() {
        return this.beanTreeComparator;
    }

    public void setBeanTreeComparator(BeanTreeComparator beanTreeComparator) {
        this.beanTreeComparator = beanTreeComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSelectionChanged(SelectionEvent ev) {
        if (this.refreshing) {
            return;
        }
        try {
            int num;
            this.refreshing = true;
            if (ev.getType() == 1 && (num = ev.getObjectCount()) > 0) {
                Object obj = ev.getObject(0);
                logger.fine("Selected: " + obj);
                File dir = null;
                if (obj instanceof File) {
                    dir = (File)obj;
                } else if (obj instanceof FileContext) {
                    FileContext fc = (FileContext)obj;
                    dir = fc.getFile();
                }
                if (dir != null) {
                    if (!(dir = dir.getAbsoluteFile()).isDirectory()) {
                        dir = dir.getParentFile();
                    }
                    FileExplorer exp = this.getExplorer();
                    exp.setDirectory(dir);
                }
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public ToolGroup getPopupMenuToolGroup() {
        return this.popupMenuToolGroup;
    }

    public void setPopupMenuToolGroup(ToolGroup popupMenuToolGroup) {
        this.popupMenuToolGroup = popupMenuToolGroup;
    }

    public Selection getSelection() {
        return this.explorer.getSelection();
    }

    protected void initDefaultTableColumnProviders() {
        this.addTableColumnProvider(new FileNameTableColumnProvider());
        this.addTableColumnProvider(new FileSizeTableColumnProvider());
        this.addTableColumnProvider(new FileTypeTableColumnProvider());
        this.addTableColumnProvider(new FileModifiedTableColumnProvider());
    }

    public void addTableColumnProvider(TableColumnProvider p) {
        this.addTableColumnProvider(p, this.tableColumnProviders.size());
    }

    public void addTableColumnProvider(TableColumnProvider p, int index) {
        if (p != null) {
            this.tableColumnProviders.add(index, p);
        }
    }

    public void removeTableColumnProvider(TableColumnProvider p) {
        this.tableColumnProviders.remove(p);
    }

    protected String sizeString(long size) {
        if (size < 1024L) {
            return "" + size + " B";
        }
        long kb = (size - 1L) / 1024L + 1L;
        String s = "" + kb;
        return s + " KB";
    }

    protected String dateString(long millis) {
        return this.dateFormat.format(new Date(millis));
    }

    protected class FileModifiedTableColumnProvider
    implements TableColumnProvider {
        protected FileModifiedTableColumnProvider() {
        }

        public TableColumn createTableColumn(TableModel model) {
            FileDetailsCellRenderer renderer = new FileDetailsCellRenderer((FileDetailsTableModel)model);
            TableColumn col = new TableColumn(3, 110, renderer, null);
            col.setHeaderValue("Last modified");
            return col;
        }

        public RowComparator createRowComparator(TableModel model, boolean ascending, boolean ignoreCase) {
            return null;
        }

        public TableCellFormatter createCellFormatter(TableModel model) {
            return null;
        }
    }

    protected class FileTypeTableColumnProvider
    implements TableColumnProvider {
        protected FileTypeTableColumnProvider() {
        }

        public TableColumn createTableColumn(TableModel model) {
            FileDetailsCellRenderer renderer = new FileDetailsCellRenderer((FileDetailsTableModel)model);
            TableColumn col = new TableColumn(2, 110, renderer, null);
            col.setHeaderValue("Type");
            return col;
        }

        public RowComparator createRowComparator(TableModel model, boolean ascending, boolean ignoreCase) {
            return null;
        }

        public TableCellFormatter createCellFormatter(TableModel model) {
            return null;
        }
    }

    protected class FileSizeTableColumnProvider
    implements TableColumnProvider {
        protected FileSizeTableColumnProvider() {
        }

        public TableColumn createTableColumn(TableModel model) {
            FileDetailsCellRenderer renderer = new FileDetailsCellRenderer((FileDetailsTableModel)model);
            TableColumn col = new TableColumn(1, 80, renderer, null);
            col.setHeaderValue("Size");
            return col;
        }

        public RowComparator createRowComparator(TableModel model, boolean ascending, boolean ignoreCase) {
            return null;
        }

        public TableCellFormatter createCellFormatter(TableModel model) {
            return null;
        }
    }

    protected class FileNameTableColumnProvider
    implements TableColumnProvider {
        protected FileNameTableColumnProvider() {
        }

        public TableColumn createTableColumn(TableModel model) {
            FileDetailsCellRenderer renderer = new FileDetailsCellRenderer((FileDetailsTableModel)model);
            TableColumn col = new TableColumn(0, 250, renderer, null);
            col.setHeaderValue("Name");
            return col;
        }

        public RowComparator createRowComparator(TableModel model, boolean ascending, boolean ignoreCase) {
            return null;
        }

        public TableCellFormatter createCellFormatter(TableModel model) {
            return null;
        }
    }

    protected class FileDetailsCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3930252475424492752L;
        private FileDetailsTableModel model;

        public FileDetailsCellRenderer(FileDetailsTableModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            BeansToolkit btk;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            Icon icon = null;
            int halign = 2;
            TableColumn col = table.getColumnModel().getColumn(column);
            int colIndex = col.getModelIndex();
            File file = this.model.getFileAt(row);
            if (colIndex == 0 && (btk = FileExplorerView.this.getBeansToolkit()) != null) {
                icon = btk.getIcon((Object)file);
            }
            if (colIndex == 1) {
                halign = 4;
                if (value == null) {
                    text = "";
                } else if (value instanceof Long) {
                    long size = (Long)value;
                    text = "" + FileExplorerView.this.sizeString(size) + " ";
                }
            }
            if (colIndex == 2) {
                FileType type = null;
                if (value != null && value instanceof FileType && (type = (FileType)value) != null) {
                    text = type.getName();
                }
                if (text == null && file != null && file.isFile()) {
                    text = file.getName();
                    int j = text.lastIndexOf(".");
                    text = j < 0 ? null : text.substring(j + 1);
                }
                if (text == null) {
                    text = "";
                }
            }
            if (colIndex == 3 && value != null && value instanceof Long) {
                long date = (Long)value;
                text = FileExplorerView.this.dateString(date);
            }
            this.setText(text == null ? "" + value : text);
            this.setHorizontalAlignment(halign);
            this.setIcon(icon);
            return this;
        }
    }

    protected class ExplorerInitializer
    implements Runnable {
        protected ExplorerInitializer() {
        }

        @Override
        public void run() {
            FileTreeView fileTree = FileExplorerView.this.explorer.getFileTreeView();
            fileTree.setRootFile(null);
            FileExplorerView.this.explorer.setDirectory(new File("."));
        }
    }

    protected class FolderSelectionListener
    implements SelectionListener {
        protected FolderSelectionListener() {
        }

        public void selectionChanged(SelectionEvent ev) {
            FileExplorerView.this.handleSelectionChanged(ev);
        }
    }
}

