/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.FileContext;
import com.spacekiller.util.beans.FileDirNode;
import com.spacekiller.util.beans.model.BeanTreeNode;
import com.spacekiller.util.workbench.BeanTreeView;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class FileTreeView
extends BeanTreeView {
    private File rootFile;
    private boolean hideFiles;
    private static final Logger logger = Logger.getLogger(FileTreeView.class.getName());

    public FileTreeView() {
        this.initFileView();
    }

    protected void initFileView() {
        this.setName("FileView");
        this.setTitle("Files");
    }

    @Override
    protected Component createComponent() {
        long ms = -System.currentTimeMillis();
        Component rc = super.createComponent();
        logger.fine("FileTreeView component created in " + (ms += System.currentTimeMillis()) + " ms.");
        if (rc instanceof JComponent) {
            ((JComponent)rc).setPreferredSize(new Dimension(250, 500));
        }
        return rc;
    }

    public File getRootFile() {
        return this.rootFile;
    }

    public synchronized void setRootFile(File newRootFile) {
        this.rootFile = newRootFile;
        BeanContextSupport rootContext = new BeanContextSupport();
        if (this.rootFile == null) {
            File[] roots = File.listRoots();
            if (roots == null || roots.length < 1) {
                roots = new File[]{new File(".")};
            }
            int num = roots.length;
            for (int c = 0; c < num; ++c) {
                rootContext.add(this.createRootFileContext(roots[c]));
            }
        } else {
            rootContext.add(this.createRootFileContext(this.rootFile));
        }
        this.setRootContext(rootContext);
    }

    protected FileContext createRootFileContext(File file) {
        if (this.hideFiles) {
            return new FileDirNode.NamedDirOnlyNode(file, file.getPath());
        }
        return new FileDirNode.NamedFileDirNode(file, file.getPath());
    }

    public synchronized void setSelectedFile(File f) {
        BeanContext rootContext = this.getRootContext();
        FileContext selContext = null;
        if (f != null && rootContext != null) {
            for (Object o : rootContext) {
                if (o == null || !(o instanceof FileContext)) continue;
                FileContext fc = (FileContext)o;
                File rf = fc.getFile();
                if (rf != null && rf.equals(f)) {
                    selContext = fc;
                }
                if (selContext == null) {
                    selContext = fc.getChild(f);
                }
                if (selContext == null) continue;
                break;
            }
        }
        if (selContext != null) {
            TreePath selPath = this.getTreePath(selContext);
            logger.fine("FileContext: " + selContext + " >> " + selPath);
            if (selPath != null) {
                TreePath parentPath;
                BeanTreeNode oldNode;
                Object oldBean;
                TreePath oldPath;
                TreePath[] oldPaths = this.getBeanTree().getSelectionPaths();
                if (oldPaths != null && oldPaths.length == 1 && (oldPath = oldPaths[0]) != null && (oldBean = (oldNode = (BeanTreeNode)oldPath.getLastPathComponent()).getBean()) != null && oldBean instanceof FileContext) {
                    FileContext fc = (FileContext)oldBean;
                    File oldFile = fc.getFile();
                    File newFile = selContext.getFile();
                    if (oldFile != null && newFile != null && newFile.equals(oldFile)) {
                        return;
                    }
                }
                if ((parentPath = selPath.getParentPath()) != null) {
                    this.getBeanTree().expandPath(parentPath);
                }
                this.getBeanTree().setSelectionPath(selPath);
                this.getBeanTree().scrollPathToVisible(selPath);
                return;
            }
        }
        this.getBeanTree().clearSelection();
    }

    public boolean isHideFiles() {
        return this.hideFiles;
    }

    public void setHideFiles(boolean hideFiles) {
        this.hideFiles = hideFiles;
    }
}

