/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.swing.GridBagResizeSupport;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class GridBagView
extends View {
    private Map gridBagConstraints = new HashMap();

    public void addView(View v, GridBagConstraints gbc) {
        this.setGridBagConstraints(v, gbc);
        super.addChild(v);
    }

    @Override
    protected Component createComponent() {
        return this.createGridBagPanel();
    }

    private JPanel createGridBagPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(false);
        new GridBagResizeSupport((Container)panel);
        return panel;
    }

    public GridBagConstraints getGridBagConstraints(View view) {
        return (GridBagConstraints)this.gridBagConstraints.get(view);
    }

    @Override
    protected void installChildComponent(View child, Component childComponent) {
        if (childComponent != null) {
            JPanel panel = (JPanel)this.getComponent();
            GridBagConstraints gbc = this.getGridBagConstraints(child);
            if (gbc == null) {
                gbc = new GridBagConstraints();
            }
            panel.add(childComponent, gbc);
        }
    }

    public void removeView(View v) {
        super.removeChild(v);
        this.setGridBagConstraints(v, null);
    }

    public void setGridBagConstraints(View view, GridBagConstraints gbc) {
        if (view != null) {
            if (gbc == null) {
                this.gridBagConstraints.remove(view);
            } else {
                this.gridBagConstraints.put(view, gbc);
            }
        }
    }

    @Override
    protected void uninstallChildComponent(View child, Component childComponent) {
        if (childComponent != null) {
            JPanel panel = (JPanel)this.getComponent();
            panel.remove(childComponent);
        }
    }
}

