/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workbench;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.TransListCellRenderer;
import com.spacekiller.util.workspace.ProjectType;
import com.spacekiller.util.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class NewProjectDialog
extends JPanel {
    private static final long serialVersionUID = 905334169026832740L;
    private DefaultListModel ivjDefaultListModelTypes = null;
    private JButton ivjJButton = null;
    private JLabel ivjJLabel1 = null;
    private JList ivjJListTypes = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private boolean ivjConnPtoP2Aligning = false;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private ListSelectionModel ivjselectionModel1 = null;
    private boolean ivjConnPtoP3Aligning = false;
    private Document ivjdocumentName = null;
    private JButton ivjJButtonCreate = null;
    private JLabel ivjJLabel = null;
    private JTextField ivjJTextFieldName = null;
    private JDialog dialog;
    private Workspace workspace;
    private boolean confirmed = false;
    private Font rendererFont;
    private static final Logger logger = Logger.getLogger(NewProjectDialog.class.getName());

    public NewProjectDialog() {
        this.initialize();
    }

    private void action_Cancel() {
        this.setConfirmed(false);
        this.getDialog().dispose();
    }

    private void action_Create() {
        this.setConfirmed(true);
        this.getDialog().dispose();
    }

    private void checkEnable() {
        this.getJButtonCreate().setEnabled(this.getProjectName().length() > 0 && this.getProjectType() != null);
    }

    private void connEtoC1(ListSelectionEvent arg1) {
        try {
            this.selectionModel1_ValueChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(DocumentEvent evt) {
        try {
            this.documentName_Document();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.action_Create();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.action_Cancel();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5() {
        try {
            this.newProjectDialog_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.getJButtonCreate().doClick(1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getJListTypes().setModel(this.getDefaultListModelTypes());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetSource() {
        try {
            if (!this.ivjConnPtoP2Aligning) {
                this.ivjConnPtoP2Aligning = true;
                if (this.getselectionModel1() != null) {
                    this.getJListTypes().setSelectionModel(this.getselectionModel1());
                }
                this.ivjConnPtoP2Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP2Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            if (!this.ivjConnPtoP2Aligning) {
                this.ivjConnPtoP2Aligning = true;
                this.setselectionModel1(this.getJListTypes().getSelectionModel());
                this.ivjConnPtoP2Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP2Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetSource() {
        try {
            if (!this.ivjConnPtoP3Aligning) {
                this.ivjConnPtoP3Aligning = true;
                if (this.getdocumentName() != null) {
                    this.getJTextFieldName().setDocument(this.getdocumentName());
                }
                this.ivjConnPtoP3Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP3Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            if (!this.ivjConnPtoP3Aligning) {
                this.ivjConnPtoP3Aligning = true;
                this.setdocumentName(this.getJTextFieldName().getDocument());
                this.ivjConnPtoP3Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP3Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void documentName_Document() {
        this.checkEnable();
    }

    private DefaultListModel getDefaultListModelTypes() {
        if (this.ivjDefaultListModelTypes == null) {
            try {
                this.ivjDefaultListModelTypes = new DefaultListModel();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultListModelTypes;
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            JFrame frame = new JFrame();
            try {
                frame.setIconImage(Tools.createImage((Component)frame, this.getClass(), (String)"/com/spacekiller/util/workbench/icons/newejbprj_wiz.gif"));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.dialog = new JDialog(frame);
            this.dialog.setTitle("Create Project");
            this.dialog.setContentPane(this);
        }
        return this.dialog;
    }

    private Document getdocumentName() {
        return this.ivjdocumentName;
    }

    private JButton getJButton() {
        if (this.ivjJButton == null) {
            try {
                this.ivjJButton = new JButton();
                this.ivjJButton.setName("JButton");
                this.ivjJButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/cancel.gif")));
                this.ivjJButton.setFont(new Font("dialog", 0, 12));
                this.ivjJButton.setText("Cancel");
                this.ivjJButton.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton;
    }

    private JButton getJButtonCreate() {
        if (this.ivjJButtonCreate == null) {
            try {
                this.ivjJButtonCreate = new JButton();
                this.ivjJButtonCreate.setName("JButtonCreate");
                this.ivjJButtonCreate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/workbench/icons/newejbprj_wiz.gif")));
                this.ivjJButtonCreate.setText("Create");
                this.ivjJButtonCreate.setMargin(new Insets(2, 4, 2, 4));
                this.ivjJButtonCreate.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButtonCreate;
    }

    private JLabel getJLabel() {
        if (this.ivjJLabel == null) {
            try {
                this.ivjJLabel = new JLabel();
                this.ivjJLabel.setName("JLabel");
                this.ivjJLabel.setIcon(null);
                this.ivjJLabel.setText("Project name:");
                this.ivjJLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setIcon(null);
                this.ivjJLabel1.setText("Project type:");
                this.ivjJLabel1.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JList getJListTypes() {
        if (this.ivjJListTypes == null) {
            try {
                this.ivjJListTypes = new JList();
                this.ivjJListTypes.setName("JListTypes");
                this.ivjJListTypes.setOpaque(false);
                this.ivjJListTypes.setBounds(0, 0, 160, 120);
                this.ivjJListTypes.setSelectionMode(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJListTypes;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setOpaque(false);
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJButtonCreate = new GridBagConstraints();
                constraintsJButtonCreate.gridx = 0;
                constraintsJButtonCreate.gridy = 0;
                constraintsJButtonCreate.fill = 1;
                constraintsJButtonCreate.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButtonCreate(), constraintsJButtonCreate);
                GridBagConstraints constraintsJButton = new GridBagConstraints();
                constraintsJButton.gridx = 1;
                constraintsJButton.gridy = 0;
                constraintsJButton.fill = 1;
                constraintsJButton.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButton(), constraintsJButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getJListTypes());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JTextField getJTextFieldName() {
        if (this.ivjJTextFieldName == null) {
            try {
                this.ivjJTextFieldName = new JTextField();
                this.ivjJTextFieldName.setName("JTextFieldName");
                this.ivjJTextFieldName.setOpaque(false);
                this.ivjJTextFieldName.setColumns(30);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldName;
    }

    public String getProjectName() {
        return this.getJTextFieldName().getText().trim();
    }

    public ProjectType getProjectType() {
        int index = this.getJListTypes().getSelectedIndex();
        return index < 0 ? null : (ProjectType)this.getDefaultListModelTypes().getElementAt(index);
    }

    public Font getRendererFont() {
        return this.rendererFont;
    }

    private ListSelectionModel getselectionModel1() {
        return this.ivjselectionModel1;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    private void handleException(Throwable e) {
        logger.log(Level.WARNING, this.getClass().getName(), e);
    }

    private void initConnections() throws Exception {
        this.getJListTypes().addPropertyChangeListener(this.ivjEventHandler);
        this.getJTextFieldName().addPropertyChangeListener(this.ivjEventHandler);
        this.getJButtonCreate().addActionListener(this.ivjEventHandler);
        this.getJButton().addActionListener(this.ivjEventHandler);
        this.getJTextFieldName().addActionListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP3SetTarget();
    }

    private void initialize() {
        try {
            this.setName("NewProjectDialog");
            this.setLayout(new GridBagLayout());
            this.setSize(432, 308);
            GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
            constraintsJLabel1.gridx = 0;
            constraintsJLabel1.gridy = 1;
            constraintsJLabel1.gridwidth = 2;
            constraintsJLabel1.anchor = 17;
            constraintsJLabel1.insets = new Insets(4, 4, 0, 4);
            this.add((Component)this.getJLabel1(), constraintsJLabel1);
            GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
            constraintsJScrollPane1.gridx = 0;
            constraintsJScrollPane1.gridy = 2;
            constraintsJScrollPane1.gridwidth = 2;
            constraintsJScrollPane1.fill = 1;
            constraintsJScrollPane1.weightx = 1.0;
            constraintsJScrollPane1.weighty = 1.0;
            constraintsJScrollPane1.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
            GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
            constraintsJPanel1.gridx = 0;
            constraintsJPanel1.gridy = 3;
            constraintsJPanel1.gridwidth = 2;
            constraintsJPanel1.anchor = 13;
            constraintsJPanel1.weightx = 1.0;
            this.add((Component)this.getJPanel1(), constraintsJPanel1);
            GridBagConstraints constraintsJLabel = new GridBagConstraints();
            constraintsJLabel.gridx = 0;
            constraintsJLabel.gridy = 0;
            constraintsJLabel.anchor = 17;
            constraintsJLabel.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getJLabel(), constraintsJLabel);
            GridBagConstraints constraintsJTextFieldName = new GridBagConstraints();
            constraintsJTextFieldName.gridx = 1;
            constraintsJTextFieldName.gridy = 0;
            constraintsJTextFieldName.fill = 2;
            constraintsJTextFieldName.weightx = 1.0;
            constraintsJTextFieldName.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getJTextFieldName(), constraintsJTextFieldName);
            this.initConnections();
            this.connEtoC5();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected boolean isConfirmed() {
        return this.confirmed;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            NewProjectDialog aNewProjectDialog = new NewProjectDialog();
            frame.setContentPane(aNewProjectDialog);
            frame.setSize(aNewProjectDialog.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void newProjectDialog_Initialize() {
        this.setRendererFont(new Font("dialog", 0, 12));
        this.getJListTypes().setCellRenderer(new ProjectTypeListCellRenderer());
    }

    protected void refreshProjectTypes() {
        this.getDefaultListModelTypes().removeAllElements();
        Workspace ws = this.getWorkspace();
        if (ws != null) {
            int count = ws.getProjectTypeCount();
            for (int c = 0; c < count; ++c) {
                this.getDefaultListModelTypes().addElement(ws.getProjectTypeAt(c));
            }
            if (count > 0) {
                this.getJListTypes().setSelectedIndex(0);
            }
        }
    }

    private void selectionModel1_ValueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkEnable();
    }

    protected void setConfirmed(boolean newConfirmed) {
        this.confirmed = newConfirmed;
    }

    protected void setDialog(JDialog newDialog) {
        this.dialog = newDialog;
    }

    private void setdocumentName(Document newValue) {
        if (this.ivjdocumentName != newValue) {
            try {
                if (this.ivjdocumentName != null) {
                    this.ivjdocumentName.removeDocumentListener(this.ivjEventHandler);
                }
                this.ivjdocumentName = newValue;
                if (this.ivjdocumentName != null) {
                    this.ivjdocumentName.addDocumentListener(this.ivjEventHandler);
                }
                this.connPtoP3SetSource();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setRendererFont(Font newRendererFont) {
        this.rendererFont = newRendererFont;
    }

    private void setselectionModel1(ListSelectionModel newValue) {
        if (this.ivjselectionModel1 != newValue) {
            try {
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.removeListSelectionListener(this.ivjEventHandler);
                }
                this.ivjselectionModel1 = newValue;
                if (this.ivjselectionModel1 != null) {
                    this.ivjselectionModel1.addListSelectionListener(this.ivjEventHandler);
                }
                this.connPtoP2SetSource();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setWorkspace(Workspace newWorkspace) {
        this.workspace = newWorkspace;
    }

    public boolean showDialog() {
        if (this.workspace == null) {
            throw new NullPointerException("workspace");
        }
        this.refreshProjectTypes();
        this.getJTextFieldName().setText("");
        JDialog dlg = this.getDialog();
        this.setConfirmed(false);
        dlg.pack();
        Tools.centerWindow((Window)dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
        return this.isConfirmed();
    }

    class IvjEventHandler
    implements ActionListener,
    PropertyChangeListener,
    DocumentListener,
    ListSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == NewProjectDialog.this.getJButtonCreate()) {
                NewProjectDialog.this.connEtoC3(e);
            }
            if (e.getSource() == NewProjectDialog.this.getJButton()) {
                NewProjectDialog.this.connEtoC4(e);
            }
            if (e.getSource() == NewProjectDialog.this.getJTextFieldName()) {
                NewProjectDialog.this.connEtoM1(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (e.getDocument() == NewProjectDialog.this.getdocumentName()) {
                NewProjectDialog.this.connEtoC2(e);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == NewProjectDialog.this.getdocumentName()) {
                NewProjectDialog.this.connEtoC2(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == NewProjectDialog.this.getJListTypes() && evt.getPropertyName().equals("selectionModel")) {
                NewProjectDialog.this.connPtoP2SetTarget();
            }
            if (evt.getSource() == NewProjectDialog.this.getJTextFieldName() && evt.getPropertyName().equals("document")) {
                NewProjectDialog.this.connPtoP3SetTarget();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == NewProjectDialog.this.getdocumentName()) {
                NewProjectDialog.this.connEtoC2(e);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == NewProjectDialog.this.getselectionModel1()) {
                NewProjectDialog.this.connEtoC1(e);
            }
        }
    }

    public class ProjectTypeListCellRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = -5501630895347643414L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object o = value;
            Component rc = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (o != null && o instanceof ProjectType) {
                ProjectType type = (ProjectType)o;
                this.setFont(NewProjectDialog.this.getRendererFont());
                this.setText("" + type.getTitle());
                this.setIcon(type.getIcon());
                this.setToolTipText(type.getDescription());
            }
            return rc;
        }
    }
}

